/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.KafkaException;
import kafka.common.MessageSizeTooLargeException;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStats;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t/\u0011\u001a2\u0001A\u0005'!\rQQbD\u0007\u0002\u0017)\u0011A\u0002B\u0001\u0006kRLGn]\u0005\u0003\u001d-\u0011\u0001#\u0013;fe\u0006$xN\u001d+f[Bd\u0017\r^3\u0011\tA\u0019RcI\u0007\u0002#)\u0011!\u0003B\u0001\b[\u0016\u001c8/Y4f\u0013\t!\u0012C\u0001\nNKN\u001c\u0018mZ3B]\u0012lU\r^1eCR\f\u0007C\u0001\f\u0018\u0019\u0001!Q\u0001\u0007\u0001C\u0002e\u0011\u0011aS\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0004\u0003:L\bC\u0001\f%\t\u0015)\u0003A1\u0001\u001a\u0005\u00051\u0006C\u0001\u0006(\u0013\tA3BA\u0004M_\u001e<\u0017N\\4\t\u0011)\u0002!Q1A\u0005\n-\nqa\u00195b]:,G.F\u0001-!\riCGN\u0007\u0002])\u0011q\u0006M\u0001\u000bG>t7-\u001e:sK:$(BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011QG\f\u0002\u000e\u00052|7m[5oOF+X-^3\u0011\u0005]BT\"\u0001\u0002\n\u0005e\u0012!\u0001\u0005$fi\u000eDW\r\u001a#bi\u0006\u001c\u0005.\u001e8l\u0011!Y\u0004A!A!\u0002\u0013a\u0013\u0001C2iC:tW\r\u001c\u0011\t\u0011u\u0002!\u0011!Q\u0001\ny\n\u0011cY8ogVlWM\u001d+j[\u0016|W\u000f^'t!\tYr(\u0003\u0002A9\t\u0019\u0011J\u001c;\t\u0011\t\u0003!Q1A\u0005\n\r\u000b!b[3z\t\u0016\u001cw\u000eZ3s+\u0005!\u0005cA#I+5\taI\u0003\u0002H\t\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005%3%a\u0002#fG>$WM\u001d\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\t\u0006Y1.Z=EK\u000e|G-\u001a:!\u0011!i\u0005A!b\u0001\n\u0013q\u0015\u0001\u0004<bYV,G)Z2pI\u0016\u0014X#A(\u0011\u0007\u0015C5\u0005\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003P\u000351\u0018\r\\;f\t\u0016\u001cw\u000eZ3sA!A1\u000b\u0001BC\u0002\u0013\u0005A+\u0001\u0005dY&,g\u000e^%e+\u0005)\u0006C\u0001,Z\u001d\tYr+\u0003\u0002Y9\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAF\u0004\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003V\u0003%\u0019G.[3oi&#\u0007\u0005C\u0003`\u0001\u0011\u0005\u0001-\u0001\u0004=S:LGO\u0010\u000b\u0007C\n\u001cG-\u001a4\u0011\t]\u0002Qc\t\u0005\u0006Uy\u0003\r\u0001\f\u0005\u0006{y\u0003\rA\u0010\u0005\u0006\u0005z\u0003\r\u0001\u0012\u0005\u0006\u001bz\u0003\ra\u0014\u0005\u0006'z\u0003\r!\u0016\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0003\u001d\u0019WO\u001d:f]R,\u0012A\u001b\t\u0004W:\u0004X\"\u00017\u000b\u00055t\u0013AB1u_6L7-\u0003\u0002pY\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0002rsrt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005U4\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tAH$A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(\u0001C%uKJ\fGo\u001c:\u000b\u0005ad\u0002C\u0001\t~\u0013\tq\u0018C\u0001\tNKN\u001c\u0018mZ3B]\u0012|eMZ:fi\"9\u0011\u0011\u0001\u0001!\u0002\u0013Q\u0017\u0001C2veJ,g\u000e\u001e\u0011\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\u0005\u001d\u0011\u0001E2veJ,g\u000e\u001e+pa&\u001c\u0017J\u001c4p+\t\tI\u0001E\u00028\u0003\u0017I1!!\u0004\u0003\u0005I\u0001\u0016M\u001d;ji&|g\u000eV8qS\u000eLeNZ8\t\u0013\u0005E\u0001\u00011A\u0005\n\u0005M\u0011\u0001F2veJ,g\u000e\u001e+pa&\u001c\u0017J\u001c4p?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005m\u0001cA\u000e\u0002\u0018%\u0019\u0011\u0011\u0004\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003;\ty!!AA\u0002\u0005%\u0011a\u0001=%c!A\u0011\u0011\u0005\u0001!B\u0013\tI!A\tdkJ\u0014XM\u001c;U_BL7-\u00138g_\u0002B\u0011\"!\n\u0001\u0001\u0004%I!a\n\u0002\u001d\r|gn];nK\u0012|eMZ:fiV\u0011\u0011\u0011\u0006\t\u00047\u0005-\u0012bAA\u00179\t!Aj\u001c8h\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019$\u0001\nd_:\u001cX/\\3e\u001f\u001a47/\u001a;`I\u0015\fH\u0003BA\u000b\u0003kA!\"!\b\u00020\u0005\u0005\t\u0019AA\u0015\u0011!\tI\u0004\u0001Q!\n\u0005%\u0012aD2p]N,X.\u001a3PM\u001a\u001cX\r\u001e\u0011\t\u0013\u0005u\u0002A1A\u0005\n\u0005}\u0012AE2p]N,X.\u001a:U_BL7m\u0015;biN,\"!!\u0011\u0011\u0007]\n\u0019%C\u0002\u0002F\t\u0011!cQ8ogVlWM\u001d+pa&\u001c7\u000b^1ug\"A\u0011\u0011\n\u0001!\u0002\u0013\t\t%A\nd_:\u001cX/\\3s)>\u0004\u0018nY*uCR\u001c\b\u0005C\u0004\u0002N\u0001!\t%a\u0014\u0002\t9,\u0007\u0010\u001e\u000b\u0002\u001f!9\u00111\u000b\u0001\u0005\u0012\u0005=\u0013\u0001C7bW\u0016tU\r\u001f;\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z\u0005\t2\r\\3be\u000e+(O]3oi\u000eCWO\\6\u0015\u0005\u0005U\u0001f\u0002\u0001\u0002^\u0005\r\u0014q\r\t\u00047\u0005}\u0013bAA19\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005\u0015\u0014a\u0012+iSN\u00043\r\\1tg\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/\u001a\u0018\"\u0005\u0005%\u0014\u0001\u0003\u0019/cEr\u0003G\f\u0019")
public class ConsumerIterator<K, V>
extends IteratorTemplate<MessageAndMetadata<K, V>>
implements Logging {
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<K> keyDecoder;
    private final Decoder<V> valueDecoder;
    private final String clientId;
    private final AtomicReference<Iterator<MessageAndOffset>> current;
    private PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo;
    private long kafka$consumer$ConsumerIterator$$consumedOffset;
    private final ConsumerTopicStats consumerTopicStats;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ConsumerIterator consumerIterator = this;
        synchronized (consumerIterator) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<K> keyDecoder() {
        return this.keyDecoder;
    }

    private Decoder<V> valueDecoder() {
        return this.valueDecoder;
    }

    public String clientId() {
        return this.clientId;
    }

    private AtomicReference<Iterator<MessageAndOffset>> current() {
        return this.current;
    }

    public PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo() {
        return this.kafka$consumer$ConsumerIterator$$currentTopicInfo;
    }

    private void kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(PartitionTopicInfo x$1) {
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = x$1;
    }

    public long kafka$consumer$ConsumerIterator$$consumedOffset() {
        return this.kafka$consumer$ConsumerIterator$$consumedOffset;
    }

    private void kafka$consumer$ConsumerIterator$$consumedOffset_$eq(long x$1) {
        this.kafka$consumer$ConsumerIterator$$consumedOffset = x$1;
    }

    private ConsumerTopicStats consumerTopicStats() {
        return this.consumerTopicStats;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MessageAndMetadata<K, V> next() {
        void var1_1;
        MessageAndMetadata item = (MessageAndMetadata)super.next();
        if (this.kafka$consumer$ConsumerIterator$$consumedOffset() < 0L) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.kafka$consumer$ConsumerIterator$$consumedOffset())})));
        }
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(this.kafka$consumer$ConsumerIterator$$consumedOffset());
        String topic = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic();
        this.trace((Function0<String>)((Object)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerIterator $outer;
            private final String topic$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Setting %s consumed offset to %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToLong(this.$outer.kafka$consumer$ConsumerIterator$$consumedOffset())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }));
        this.consumerTopicStats().getConsumerTopicStats(topic).messageRate().mark();
        this.consumerTopicStats().getConsumerAllTopicStats().messageRate().mark();
        return var1_1;
    }

    @Override
    public MessageAndMetadata<K, V> makeNext() {
        FetchedDataChunk currentDataChunk = null;
        Iterator<MessageAndOffset> localCurrent = this.current().get();
        if (localCurrent == null || !localCurrent.hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                currentDataChunk = this.channel().take();
            } else {
                currentDataChunk = this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS);
                if (currentDataChunk == null) {
                    this.resetState();
                    throw new ConsumerTimeoutException();
                }
            }
            if (currentDataChunk == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                this.debug((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Received the shutdown command";
                    }
                }));
                return (MessageAndMetadata)this.allDone();
            }
            this.kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(currentDataChunk.topicInfo());
            long cdcFetchOffset = currentDataChunk.fetchOffset();
            long ctiConsumeOffset = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset();
            if (ctiConsumeOffset < cdcFetchOffset) {
                this.error((Function0<String>)((Object)new Serializable(this, cdcFetchOffset, ctiConsumeOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ConsumerIterator $outer;
                    private final long cdcFetchOffset$1;
                    private final long ctiConsumeOffset$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("consumed offset: %d doesn't match fetch offset: %d for %s;\n Consumer may lose data")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.ctiConsumeOffset$1), BoxesRunTime.boxToLong(this.cdcFetchOffset$1), this.$outer.kafka$consumer$ConsumerIterator$$currentTopicInfo()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.cdcFetchOffset$1 = cdcFetchOffset$1;
                        this.ctiConsumeOffset$1 = ctiConsumeOffset$1;
                    }
                }));
                this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(cdcFetchOffset);
            }
            localCurrent = currentDataChunk.messages().iterator();
            this.current().set(localCurrent);
            if (currentDataChunk.messages().validBytes() == 0) {
                throw new MessageSizeTooLargeException(new StringBuilder().append((Object)"Found a message larger than the maximum fetch size of this consumer on topic ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%s partition %d at fetch offset %d. Increase the fetch size, or decrease the maximum message size the broker will allow.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{currentDataChunk.topicInfo().topic(), BoxesRunTime.boxToInteger(currentDataChunk.topicInfo().partitionId()), BoxesRunTime.boxToLong(currentDataChunk.fetchOffset())}))).toString());
            }
        }
        MessageAndOffset item = localCurrent.next();
        while (item.offset() < this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset() && localCurrent.hasNext()) {
            item = localCurrent.next();
        }
        this.kafka$consumer$ConsumerIterator$$consumedOffset_$eq(item.nextOffset());
        item.message().ensureValid();
        return new MessageAndMetadata<K, V>(this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic(), this.kafka$consumer$ConsumerIterator$$currentTopicInfo().partitionId(), item.message(), item.offset(), this.keyDecoder(), this.valueDecoder(), item.message().timestamp(), item.message().timestampType());
    }

    public void clearCurrentChunk() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Clearing the current data chunk for this consumer iterator";
            }
        }));
        this.current().set(null);
    }

    public ConsumerIterator(BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<K> keyDecoder, Decoder<V> valueDecoder, String clientId) {
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        this.clientId = clientId;
        Logging$class.$init$(this);
        this.current = new AtomicReference<Object>(null);
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = null;
        this.kafka$consumer$ConsumerIterator$$consumedOffset = -1L;
        this.consumerTopicStats = ConsumerTopicStatsRegistry$.MODULE$.getConsumerTopicStat(clientId);
    }
}

