/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import com.typesafe.scalalogging.Logger;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.TimeUnit;
import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponse$;
import kafka.api.GroupCoordinatorRequest;
import kafka.api.GroupCoordinatorResponse;
import kafka.api.GroupCoordinatorResponse$;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetCommitResponse$;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetFetchResponse$;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.OffsetResponse$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.FetchRequestAndResponseStats;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.consumer.SimpleConsumer$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001\u001d\u0011abU5na2,7i\u001c8tk6,'O\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0017\u0003\u0011Awn\u001d;\u0016\u0003]\u0001\"\u0001G\u000e\u000f\u0005%I\u0012B\u0001\u000e\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011A$\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iQ\u0001\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u000b!|7\u000f\u001e\u0011\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\nA\u0001]8siV\t1\u0005\u0005\u0002\nI%\u0011QE\u0003\u0002\u0004\u0013:$\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000bA|'\u000f\u001e\u0011\t\u0011%\u0002!Q1A\u0005\u0002\t\n\u0011b]8US6,w.\u001e;\t\u0011-\u0002!\u0011!Q\u0001\n\r\n!b]8US6,w.\u001e;!\u0011!i\u0003A!b\u0001\n\u0003\u0011\u0013A\u00032vM\u001a,'oU5{K\"Aq\u0006\u0001B\u0001B\u0003%1%A\u0006ck\u001a4WM]*ju\u0016\u0004\u0003\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012D\u0001b\r\u0001\u0003\u0002\u0003\u0006IaF\u0001\nG2LWM\u001c;JI\u0002BQ!\u000e\u0001\u0005\u0002Y\na\u0001P5oSRtDCB\u001c:umbT\b\u0005\u00029\u00015\t!\u0001C\u0003\u0016i\u0001\u0007q\u0003C\u0003\"i\u0001\u00071\u0005C\u0003*i\u0001\u00071\u0005C\u0003.i\u0001\u00071\u0005C\u00032i\u0001\u0007q\u0003C\u0004@\u0001\t\u0007I\u0011\u0002!\u0002\t1|7m[\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005Y\u0006twMC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%AB(cU\u0016\u001cG\u000f\u0003\u0004K\u0001\u0001\u0006I!Q\u0001\u0006Y>\u001c7\u000e\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0003=\u0011Gn\\2lS:<7\t[1o]\u0016dW#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E#\u0011a\u00028fi^|'o[\u0005\u0003'B\u0013qB\u00117pG.LgnZ\"iC:tW\r\u001c\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002!\tdwnY6j]\u001e\u001c\u0005.\u00198oK2\u0004\u0003bB,\u0001\u0005\u0004%I\u0001W\u0001\u001dM\u0016$8\r\u001b*fcV,7\u000f^!oIJ+7\u000f]8og\u0016\u001cF/\u0019;t+\u0005I\u0006C\u0001\u001d[\u0013\tY&A\u0001\u000fGKR\u001c\u0007NU3rk\u0016\u001cH/\u00118e%\u0016\u001c\bo\u001c8tKN#\u0018\r^:\t\ru\u0003\u0001\u0015!\u0003Z\u0003u1W\r^2i%\u0016\fX/Z:u\u0003:$'+Z:q_:\u001cXm\u0015;biN\u0004\u0003bB0\u0001\u0001\u0004%I\u0001Y\u0001\tSN\u001cEn\\:fIV\t\u0011\r\u0005\u0002\nE&\u00111M\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d)\u0007\u00011A\u0005\n\u0019\fA\"[:DY>\u001cX\rZ0%KF$\"a\u001a6\u0011\u0005%A\u0017BA5\u000b\u0005\u0011)f.\u001b;\t\u000f-$\u0017\u0011!a\u0001C\u0006\u0019\u0001\u0010J\u0019\t\r5\u0004\u0001\u0015)\u0003b\u0003%I7o\u00117pg\u0016$\u0007\u0005C\u0003p\u0001\u0011%\u0001/A\u0004d_:tWm\u0019;\u0015\u00039CQA\u001d\u0001\u0005\nM\f!\u0002Z5tG>tg.Z2u)\u00059\u0007\"B;\u0001\t\u0013\u0019\u0018!\u0003:fG>tg.Z2u\u0011\u00159\b\u0001\"\u0001t\u0003m!\u0017n]2p]:,7\r\u001e+p\u0011\u0006tG\r\\3KCZ\f\u0017j\u0014\"vO\")\u0011\u0010\u0001C\u0001g\u0006)1\r\\8tK\")1\u0010\u0001C\u0005y\u0006Y1/\u001a8e%\u0016\fX/Z:u)\ri\u00181\u0003\t\u0004}\u0006=Q\"A@\u000b\u0007E\u000b\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB2p[6|gNC\u0002\u0006\u0003\u000fQA!!\u0003\u0002\f\u00051\u0011\r]1dQ\u0016T!!!\u0004\u0002\u0007=\u0014x-C\u0002\u0002\u0012}\u0014aBT3uo>\u00148NU3dK&4X\rC\u0004\u0002\u0016i\u0004\r!a\u0006\u0002\u000fI,\u0017/^3tiB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e\u0011\t1!\u00199j\u0013\u0011\t\t#a\u0007\u0003#I+\u0017/^3ti>\u0013(+Z:q_:\u001cX\rC\u0004\u0002&\u0001!\t!a\n\u0002\tM,g\u000e\u001a\u000b\u0005\u0003S\ty\u0003\u0005\u0003\u0002\u001a\u0005-\u0012\u0002BA\u0017\u00037\u0011Q\u0003V8qS\u000elU\r^1eCR\f'+Z:q_:\u001cX\r\u0003\u0005\u0002\u0016\u0005\r\u0002\u0019AA\u0019!\u0011\tI\"a\r\n\t\u0005U\u00121\u0004\u0002\u0015)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002:Q!\u00111HA!!\u0011\tI\"!\u0010\n\t\u0005}\u00121\u0004\u0002\u0019\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\u0014Vm\u001d9p]N,\u0007\u0002CA\u000b\u0003o\u0001\r!a\u0011\u0011\t\u0005e\u0011QI\u0005\u0005\u0003\u000f\nYBA\fHe>,\boQ8pe\u0012Lg.\u0019;peJ+\u0017/^3ti\"9\u00111\n\u0001\u0005\u0002\u00055\u0013!\u00024fi\u000eDG\u0003BA(\u0003+\u0002B!!\u0007\u0002R%!\u00111KA\u000e\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\"A\u0011QCA%\u0001\u0004\t9\u0006\u0005\u0003\u0002\u001a\u0005e\u0013\u0002BA.\u00037\u0011ABR3uG\"\u0014V-];fgRDq!a\u0018\u0001\t\u0003\t\t'\u0001\thKR|eMZ:fiN\u0014UMZ8sKR!\u00111MA5!\u0011\tI\"!\u001a\n\t\u0005\u001d\u00141\u0004\u0002\u000f\u001f\u001a47/\u001a;SKN\u0004xN\\:f\u0011!\t)\"!\u0018A\u0002\u0005-\u0004\u0003BA\r\u0003[JA!a\u001c\u0002\u001c\tiqJ\u001a4tKR\u0014V-];fgRDq!a\u001d\u0001\t\u0003\t)(A\u0007d_6l\u0017\u000e^(gMN,Go\u001d\u000b\u0005\u0003o\ni\b\u0005\u0003\u0002\u001a\u0005e\u0014\u0002BA>\u00037\u0011Ac\u00144gg\u0016$8i\\7nSR\u0014Vm\u001d9p]N,\u0007\u0002CA\u000b\u0003c\u0002\r!a \u0011\t\u0005e\u0011\u0011Q\u0005\u0005\u0003\u0007\u000bYBA\nPM\u001a\u001cX\r^\"p[6LGOU3rk\u0016\u001cH\u000fC\u0004\u0002\b\u0002!\t!!#\u0002\u0019\u0019,Go\u00195PM\u001a\u001cX\r^:\u0015\t\u0005-\u0015\u0011\u0013\t\u0005\u00033\ti)\u0003\u0003\u0002\u0010\u0006m!aE(gMN,GOR3uG\"\u0014Vm\u001d9p]N,\u0007\u0002CA\u000b\u0003\u000b\u0003\r!a%\u0011\t\u0005e\u0011QS\u0005\u0005\u0003/\u000bYB\u0001\nPM\u001a\u001cX\r\u001e$fi\u000eD'+Z9vKN$\bBBAN\u0001\u0011%1/A\nhKR|%/T1lK\u000e{gN\\3di&|g\u000eC\u0004\u0002 \u0002!\t!!)\u0002-\u0015\f'\u000f\\5fgR|%\u000fT1uKN$xJ\u001a4tKR$\u0002\"a)\u0002*\u0006]\u00161\u0018\t\u0004\u0013\u0005\u0015\u0016bAAT\u0015\t!Aj\u001c8h\u0011!\tY+!(A\u0002\u00055\u0016!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B!\u0011qVAZ\u001b\t\t\tLC\u0002\u0002\u0004\u0011IA!!.\u00022\n\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005e\u0016Q\u0014a\u0001\u0003G\u000b\u0001#Z1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;\t\u000f\u0005u\u0016Q\u0014a\u0001G\u0005Q1m\u001c8tk6,'/\u00133)\u0007\u0001\t\t\rE\u0002\u0010\u0003\u0007L1!!2\u0011\u0005)!\bN]3bIN\fg-\u001a\u0015\b\u0001\u0005%\u0017qZAj!\rI\u00111Z\u0005\u0004\u0003\u001bT!A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011\u0011[\u0001\u0002\u0018QC\u0017n\u001d\u0011dY\u0006\u001c8\u000f\t5bg\u0002\u0012W-\u001a8!I\u0016\u0004(/Z2bi\u0016$\u0007%\u00198eA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012\u0004\u0013N\u001c\u0011bA\u0019,H/\u001e:fAI,G.Z1tK:\u0002\u0003\u000b\\3bg\u0016\u0004So]3!_J<g&\u00199bG\",gf[1gW\u0006t3\r\\5f]R\u001chfY8ogVlWM\u001d\u0018LC\u001a\\\u0017mQ8ogVlWM\u001d\u0011j]N$X-\u00193/C\t\t).\u0001\u00051]E\nd\u0006\r\u00181\u0001")
public class SimpleConsumer
implements Logging {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private final String clientId;
    private final Object lock;
    private final BlockingChannel blockingChannel;
    private final FetchRequestAndResponseStats fetchRequestAndResponseStats;
    private boolean isClosed;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        SimpleConsumer simpleConsumer = this;
        synchronized (simpleConsumer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String clientId() {
        return this.clientId;
    }

    private Object lock() {
        return this.lock;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    private FetchRequestAndResponseStats fetchRequestAndResponseStats() {
        return this.fetchRequestAndResponseStats;
    }

    private boolean isClosed() {
        return this.isClosed;
    }

    private void isClosed_$eq(boolean x$1) {
        this.isClosed = x$1;
    }

    private BlockingChannel connect() {
        this.close();
        this.blockingChannel().connect();
        return this.blockingChannel();
    }

    private void disconnect() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleConsumer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Disconnecting from ").append((Object)Utils.formatAddress(this.$outer.host(), Predef$.MODULE$.int2Integer(this.$outer.port()))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.blockingChannel().disconnect();
    }

    private void reconnect() {
        this.disconnect();
        this.connect();
    }

    public void disconnectToHandleJavaIOBug() {
        this.disconnect();
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.isClosed_$eq(true);
            return;
        }
    }

    public NetworkReceive kafka$consumer$SimpleConsumer$$sendRequest(RequestOrResponse request) {
        Object object = this.lock();
        synchronized (object) {
            ObjectRef<Object> response = ObjectRef.create(null);
            this.liftedTree1$1(request, response);
            NetworkReceive networkReceive = (NetworkReceive)response.elem;
            return networkReceive;
        }
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        NetworkReceive response = this.kafka$consumer$SimpleConsumer$$sendRequest(request);
        return TopicMetadataResponse$.MODULE$.readFrom(response.payload());
    }

    public GroupCoordinatorResponse send(GroupCoordinatorRequest request) {
        NetworkReceive response = this.kafka$consumer$SimpleConsumer$$sendRequest(request);
        return GroupCoordinatorResponse$.MODULE$.readFrom(response.payload());
    }

    public FetchResponse fetch(FetchRequest request) {
        ObjectRef<Object> response = ObjectRef.create(null);
        KafkaTimer specificTimer = this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.host(), this.port()).requestTimer();
        KafkaTimer aggregateTimer = this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestTimer();
        aggregateTimer.time(new Serializable(this, request, response, specificTimer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleConsumer $outer;
            public final FetchRequest request$2;
            public final ObjectRef response$2;
            private final KafkaTimer specificTimer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.specificTimer$1.time(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$fetch$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.response$2.elem = this.$outer.kafka$consumer$SimpleConsumer$$anonfun$$$outer().kafka$consumer$SimpleConsumer$$sendRequest(this.$outer.request$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SimpleConsumer kafka$consumer$SimpleConsumer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
                this.response$2 = response$2;
                this.specificTimer$1 = specificTimer$1;
            }
        });
        FetchResponse fetchResponse = FetchResponse$.MODULE$.readFrom(((NetworkReceive)response.elem).payload(), request.versionId());
        int fetchedSize = fetchResponse.sizeInBytes();
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.host(), this.port()).requestSizeHist().update(fetchedSize);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestSizeHist().update(fetchedSize);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.host(), this.port()).throttleTimeStats().update(fetchResponse.throttleTimeMs(), TimeUnit.MILLISECONDS);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().throttleTimeStats().update(fetchResponse.throttleTimeMs(), TimeUnit.MILLISECONDS);
        return fetchResponse;
    }

    public OffsetResponse getOffsetsBefore(OffsetRequest request) {
        return OffsetResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(request).payload());
    }

    public OffsetCommitResponse commitOffsets(OffsetCommitRequest request) {
        return OffsetCommitResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(request).payload());
    }

    public OffsetFetchResponse fetchOffsets(OffsetFetchRequest request) {
        return OffsetFetchResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(request).payload(), request.versionId());
    }

    private void getOrMakeConnection() {
        if (!this.isClosed() && !this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    /*
     * WARNING - void declaration
     */
    public long earliestOrLatestOffset(TopicAndPartition topicAndPartition, long earliestOrLatest, int consumerId) {
        void var11_10;
        int x$5;
        Map x$1 = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(earliestOrLatest, 1))}));
        String x$2 = this.clientId();
        int x$3 = consumerId;
        short x$4 = OffsetRequest$.MODULE$.apply$default$2();
        OffsetRequest request = new OffsetRequest(x$1, x$4, x$5 = OffsetRequest$.MODULE$.apply$default$3(), x$2, x$3);
        PartitionOffsetsResponse partitionErrorAndOffset = (PartitionOffsetsResponse)this.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition);
        Errors errors = partitionErrorAndOffset.error();
        if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            long l;
            long offset2 = l = BoxesRunTime.unboxToLong(partitionErrorAndOffset.offsets().head());
            return offset2;
        }
        throw ErrorMapping$.MODULE$.exceptionFor(var11_10.error().code());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree1$1(RequestOrResponse request$1, ObjectRef response$1) {
        try {
            this.getOrMakeConnection();
            this.blockingChannel().send(request$1);
            response$1.elem = this.blockingChannel().receive();
            return;
        }
        catch (Throwable throwable) {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Reconnect due to error:";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
            try {
                this.reconnect();
                this.blockingChannel().send(request$1);
                response$1.elem = this.blockingChannel().receive();
                return;
            }
            catch (Throwable throwable2) {
                this.disconnect();
                throw throwable2;
            }
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            throw asynchronousCloseException;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            throw closedByInterruptException;
        }
    }

    public SimpleConsumer(String host, int port, int soTimeout, int bufferSize, String clientId) {
        this.host = host;
        this.port = port;
        this.soTimeout = soTimeout;
        this.bufferSize = bufferSize;
        this.clientId = clientId;
        Logging$class.$init$(this);
        ConsumerConfig$.MODULE$.validateClientId(clientId);
        this.lock = new Object();
        this.blockingChannel = new BlockingChannel(host, port, bufferSize, BlockingChannel$.MODULE$.UseDefaultBufferSize(), soTimeout);
        this.fetchRequestAndResponseStats = FetchRequestAndResponseStatsRegistry$.MODULE$.getFetchRequestAndResponseStats(clientId);
        this.isClosed = false;
    }
}

