/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import kafka.controller.StateChangeLogger$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M;Q!\u0001\u0002\t\u0002\u001d\t\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012\u0001D:dC2\fGn\\4hS:<'BA\u000f\u001f\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0010\u0002\u0007\r|W.\u0003\u0002\"5\t1Aj\\4hKJDaaI\u0005!\u0002\u0013A\u0012a\u00027pO\u001e,'\u000f\t\u0004\u0005\u0015\t\u0001QeE\u0002%\u0019\u0019\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005-B#a\u0002'pO\u001eLgn\u001a\u0005\t[\u0011\u0012\t\u0011)A\u0005]\u0005A!M]8lKJLE\r\u0005\u0002\u000e_%\u0011\u0001G\u0004\u0002\u0004\u0013:$\b\u0002\u0003\u001a%\u0005\u0003\u0005\u000b\u0011B\u001a\u0002'%t7i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u00055!\u0014BA\u001b\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001b\u000e\u0013\u0003\u0002\u0003\u0006I\u0001O\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQB\u0019Q\"\u000f\u0018\n\u0005ir!AB(qi&|g\u000eC\u0003\u0014I\u0011\u0005A\b\u0006\u0003>}}\u0002\u0005C\u0001\u0005%\u0011\u0015i3\b1\u0001/\u0011\u0015\u00114\b1\u00014\u0011\u001594\b1\u00019\u0011!1B\u0005#b\u0001\n\u0003:\u0002\u0002C\u0012%\u0011\u0003\u0005\u000b\u0015\u0002\r\t\u000b\u0011#C\u0011A#\u0002']LG\u000f[\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0015\u0005u2\u0005\"B\u001cD\u0001\u0004q\u0003\"\u0002%%\t\u0003I\u0015!E7fgN\fw-Z,ji\"\u0004&/\u001a4jqR\u0011!*\u0015\t\u0003\u0017:s!!\u0004'\n\u00055s\u0011A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\b\t\u000bI;\u0005\u0019\u0001&\u0002\u000f5,7o]1hK\u0002")
public class StateChangeLogger
implements Logging {
    private final int brokerId;
    private final boolean inControllerContext;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        StateChangeLogger stateChangeLogger = this;
        synchronized (stateChangeLogger) {
            if (!this.bitmap$0) {
                this.logger = StateChangeLogger$.MODULE$.kafka$controller$StateChangeLogger$$logger();
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public StateChangeLogger withControllerEpoch(int controllerEpoch) {
        return new StateChangeLogger(this.brokerId, this.inControllerContext, new Some<Object>(BoxesRunTime.boxToInteger(controllerEpoch)));
    }

    public String messageWithPrefix(String message) {
        return this.msgWithLogIdent(message);
    }

    public StateChangeLogger(int brokerId, boolean inControllerContext, Option<Object> controllerEpoch) {
        this.brokerId = brokerId;
        this.inControllerContext = inControllerContext;
        Logging$class.$init$(this);
        if (controllerEpoch.isDefined() && !inControllerContext) {
            throw new IllegalArgumentException("Controller epoch should only be defined if inControllerContext is true");
        }
        String prefix = inControllerContext ? "Controller" : "Broker";
        String epochEntry = controllerEpoch.fold(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int epoch) {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" epoch=", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(epoch)}));
            }
        });
        this.logIdent_$eq(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", " id=", "", "] "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prefix, BoxesRunTime.boxToInteger(brokerId), epochEntry})));
        Predef$.MODULE$.locally(BoxedUnit.UNIT);
    }
}

