/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005xAB\u0001\u0003\u0011\u0003\u0011\u0001\"A\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005YAO]1og\u0006\u001cG/[8o\u0015\t)a!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0011\u0005%QQ\"\u0001\u0002\u0007\r-\u0011\u0001\u0012\u0001\u0002\r\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b'\tQQ\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006))!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0002C\u0003\u0019\u0015\u0011\u0005\u0011$A\u0003baBd\u0017\u0010F\u0006\u001b\u0005w\u0012iHa \u0003\u0002\n\r\u0005CA\u0005\u001c\r\u0015Y!\u0001\u0001\u0002\u001d'\rYR\"\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\"AAe\u0007BC\u0002\u0013\u0005Q%A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\u00051\u0003CA\u0014+\u001d\tq\u0001&\u0003\u0002*\u001f\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIs\u0002\u0003\u0005/7\t\u0005\t\u0015!\u0003'\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007\u0005\u0003\u000517\t\u0005\r\u0011\"\u00012\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002eA\u0011abM\u0005\u0003i=\u0011A\u0001T8oO\"Aag\u0007BA\u0002\u0013\u0005q'\u0001\bqe>$WoY3s\u0013\u0012|F%Z9\u0015\u0005aZ\u0004C\u0001\b:\u0013\tQtB\u0001\u0003V]&$\bb\u0002\u001f6\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\n\u0004\u0002\u0003 \u001c\u0005\u0003\u0005\u000b\u0015\u0002\u001a\u0002\u0017A\u0014x\u000eZ;dKJLE\r\t\u0005\t\u0001n\u0011\t\u0019!C\u0001\u0003\u0006i\u0001O]8ek\u000e,'/\u00129pG\",\u0012A\u0011\t\u0003\u001d\rK!\u0001R\b\u0003\u000bMCwN\u001d;\t\u0011\u0019[\"\u00111A\u0005\u0002\u001d\u000b\u0011\u0003\u001d:pIV\u001cWM]#q_\u000eDw\fJ3r)\tA\u0004\nC\u0004=\u000b\u0006\u0005\t\u0019\u0001\"\t\u0011)[\"\u0011!Q!\n\t\u000ba\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007\u0005\u0003\u0005M7\t\u0005\r\u0011\"\u0001N\u00031!\bP\u001c+j[\u0016|W\u000f^'t+\u0005q\u0005C\u0001\bP\u0013\t\u0001vBA\u0002J]RD\u0001BU\u000e\u0003\u0002\u0004%\taU\u0001\u0011ibtG+[7f_V$Xj]0%KF$\"\u0001\u000f+\t\u000fq\n\u0016\u0011!a\u0001\u001d\"Aak\u0007B\u0001B\u0003&a*A\u0007uq:$\u0016.\\3pkRl5\u000f\t\u0005\t1n\u0011\t\u0019!C\u00013\u0006)1\u000f^1uKV\t!\f\u0005\u0002\n7&\u0011AL\u0001\u0002\u0011)J\fgn]1di&|gn\u0015;bi\u0016D\u0001BX\u000e\u0003\u0002\u0004%\taX\u0001\ngR\fG/Z0%KF$\"\u0001\u000f1\t\u000fqj\u0016\u0011!a\u00015\"A!m\u0007B\u0001B\u0003&!,\u0001\u0004ti\u0006$X\r\t\u0005\tIn\u0011)\u0019!C\u0001K\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001g!\r9GN\\\u0007\u0002Q*\u0011\u0011N[\u0001\b[V$\u0018M\u00197f\u0015\tYw\"\u0001\u0006d_2dWm\u0019;j_:L!!\u001c5\u0003\u0007M+G\u000f\u0005\u0002po6\t\u0001O\u0003\u0002re\u000611m\\7n_:T!aB:\u000b\u0005Q,\u0018AB1qC\u000eDWMC\u0001w\u0003\ry'oZ\u0005\u0003qB\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005{7\t\u0005\t\u0015!\u0003g\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b\u0005\u0003\u0005}7\t\u0005\r\u0011\"\u00012\u0003E!\bP\\*uCJ$H+[7fgR\fW\u000e\u001d\u0005\t}n\u0011\t\u0019!C\u0001\u007f\u0006)B\u000f\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHc\u0001\u001d\u0002\u0002!9A(`A\u0001\u0002\u0004\u0011\u0004\"CA\u00037\t\u0005\t\u0015)\u00033\u0003I!\bP\\*uCJ$H+[7fgR\fW\u000e\u001d\u0011)\t\u0005\r\u0011\u0011\u0002\t\u0004\u001d\u0005-\u0011bAA\u0007\u001f\tAao\u001c7bi&dW\rC\u0005\u0002\u0012m\u0011\t\u0019!C\u0001c\u00051B\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0002\u0016m\u0011\t\u0019!C\u0001\u0003/\t!\u0004\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e]0%KF$2\u0001OA\r\u0011!a\u00141CA\u0001\u0002\u0004\u0011\u0004\"CA\u000f7\t\u0005\t\u0015)\u00033\u0003]!\bP\u001c'bgR,\u0006\u000fZ1uKRKW.Z:uC6\u0004\b\u0005\u000b\u0003\u0002\u001c\u0005%\u0001B\u0002\u000b\u001c\t\u0003\t\u0019\u0003F\t\u001b\u0003K\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003gAa\u0001JA\u0011\u0001\u00041\u0003B\u0002\u0019\u0002\"\u0001\u0007!\u0007\u0003\u0004A\u0003C\u0001\rA\u0011\u0005\u0007\u0019\u0006\u0005\u0002\u0019\u0001(\t\ra\u000b\t\u00031\u0001[\u0011\u0019!\u0017\u0011\u0005a\u0001M\"AA0!\t\u0011\u0002\u0003\u0007!\u0007C\u0004\u0002\u0012\u0005\u0005\u0002\u0019\u0001\u001a\t\u0013\u0005]2\u00041A\u0005\u0002\u0005e\u0012\u0001\u00049f]\u0012LgnZ*uCR,WCAA\u001e!\u0011q\u0011Q\b.\n\u0007\u0005}rB\u0001\u0004PaRLwN\u001c\u0005\n\u0003\u0007Z\u0002\u0019!C\u0001\u0003\u000b\n\u0001\u0003]3oI&twm\u0015;bi\u0016|F%Z9\u0015\u0007a\n9\u0005C\u0005=\u0003\u0003\n\t\u00111\u0001\u0002<!A\u00111J\u000e!B\u0013\tY$A\u0007qK:$\u0017N\\4Ti\u0006$X\r\t\u0005\u000b\u0003\u001fZ\"\u0019!C\u0001\u0005\u0005E\u0013\u0001\u00027pG.,\"!a\u0015\u0011\t\u0005U\u0013qM\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005)An\\2lg*!\u0011QLA0\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003C\n\u0019'\u0001\u0003vi&d'BAA3\u0003\u0011Q\u0017M^1\n\t\u0005%\u0014q\u000b\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\t\u0011\u000554\u0004)A\u0005\u0003'\nQ\u0001\\8dW\u0002Bq!!\u001d\u001c\t\u0003\t\u0019(\u0001\u0004j]2{7m[\u000b\u0005\u0003k\nY\b\u0006\u0003\u0002x\u00055\u0005\u0003BA=\u0003wb\u0001\u0001\u0002\u0005\u0002~\u0005=$\u0019AA@\u0005\u0005!\u0016\u0003BAA\u0003\u000f\u00032ADAB\u0013\r\t)i\u0004\u0002\b\u001d>$\b.\u001b8h!\rq\u0011\u0011R\u0005\u0004\u0003\u0017{!aA!os\"I\u0011qRA8\t\u0003\u0007\u0011\u0011S\u0001\u0004MVt\u0007#\u0002\b\u0002\u0014\u0006]\u0014bAAK\u001f\tAAHY=oC6,g\bC\u0004\u0002\u001an!\t!a'\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t)\rA\u0014Q\u0014\u0005\t\u0003?\u000b9\n1\u0001\u0002\"\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\u0005\r\u0016Q\u00158\u000e\u0003)L!!\u001c6\t\u000f\u0005%6\u0004\"\u0001\u0002,\u0006y!/Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000eF\u00029\u0003[Cq!a,\u0002(\u0002\u0007a.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005M6\u0004\"\u0001\u00026\u0006\u0001\u0002O]3qCJ,gj\u001c+sC:\u001c\u0018\u000e\u001e\u000b\u0003\u0003o\u00032!CA]\u0013\r\tYL\u0001\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\rC\u0004\u0002@n!\t!!.\u00023A\u0014X\r]1sK\u001a+gnY3Qe>$WoY3s\u000bB|7\r\u001b\u0005\b\u0003\u0007\\B\u0011AAc\u0003u\u0001(/\u001a9be\u0016Len\u0019:f[\u0016tG\u000f\u0015:pIV\u001cWM]#q_\u000eDGCBA\\\u0003\u000f\fY\rC\u0004\u0002J\u0006\u0005\u0007\u0019\u0001(\u0002\u001f9,w\u000f\u0016=o)&lWm\\;u\u001bNDq!!4\u0002B\u0002\u0007!'A\bva\u0012\fG/\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\t\tn\u0007C\u0001\u0003'\f\u0011\u0004\u001d:fa\u0006\u0014X\r\u0015:pIV\u001cWM]%e%>$\u0018\r^5p]RA\u0011qWAk\u00033\fY\u000eC\u0004\u0002X\u0006=\u0007\u0019\u0001\u001a\u0002\u001b9,w\u000f\u0015:pIV\u001cWM]%e\u0011\u001d\tI-a4A\u00029Cq!!4\u0002P\u0002\u0007!\u0007C\u0004\u0002`n!\t!!9\u0002)A\u0014X\r]1sK\u0006#G\rU1si&$\u0018n\u001c8t)\u0019\t9,a9\u0002r\"A\u0011Q]Ao\u0001\u0004\t9/\u0001\u000bbI\u0012,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006\u0003S\fyO\\\u0007\u0003\u0003WT1!!<k\u0003%IW.\\;uC\ndW-C\u0002n\u0003WDq!!4\u0002^\u0002\u0007!\u0007C\u0004\u0002vn!\t!a>\u0002)A\u0014X\r]1sK\u0006\u0013wN\u001d;Pe\u000e{W.\\5u)\u0019\t9,!?\u0002~\"9\u00111`Az\u0001\u0004Q\u0016\u0001\u00038foN#\u0018\r^3\t\u000f\u00055\u00171\u001fa\u0001e!9!\u0011A\u000e\u0005\u0002\t\r\u0011a\u00049sKB\f'/Z\"p[BdW\r^3\u0015\t\u0005]&Q\u0001\u0005\b\u0003\u001b\fy\u00101\u00013\u0011\u001d\u0011Ia\u0007C\u0001\u0003k\u000b1\u0002\u001d:fa\u0006\u0014X\rR3bI\"9!QB\u000e\u0005\u0002\t=\u0011\u0001G5t!J|G-^2fe\u0016\u0003xn\u00195Fq\"\fWo\u001d;fIV\u0011!\u0011\u0003\t\u0004\u001d\tM\u0011b\u0001B\u000b\u001f\t9!i\\8mK\u0006t\u0007b\u0002B\r7\u0011%!qB\u0001\u0016Q\u0006\u001c\b+\u001a8eS:<GK]1og\u0006\u001cG/[8o\u0011\u001d\u0011ib\u0007C\u0005\u0005?\t1\u0003\u001d:fa\u0006\u0014X\r\u0016:b]NLG/[8o)>$\u0002#a.\u0003\"\t\r\"Q\u0005B\u0015\u0005W\u0011yCa\r\t\u000f\u0005m(1\u0004a\u00015\"9\u0011q\u001bB\u000e\u0001\u0004\u0011\u0004b\u0002B\u0014\u00057\u0001\rAQ\u0001\t]\u0016<X\t]8dQ\"9\u0011\u0011\u001aB\u000e\u0001\u0004q\u0005\u0002\u0003B\u0017\u00057\u0001\r!a:\u0002%9,w\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0005c\u0011Y\u00021\u00013\u0003QqWm\u001e+y]N#\u0018M\u001d;US6,7\u000f^1na\"9\u0011Q\u001aB\u000e\u0001\u0004\u0011\u0004b\u0002B\u001c7\u0011\u0005!\u0011H\u0001\u0015G>l\u0007\u000f\\3uKR\u0013\u0018M\\:ji&|g\u000eV8\u0015\u0007a\u0012Y\u0004\u0003\u0005\u0003>\tU\u0002\u0019AA\\\u0003=!(/\u00198tSRlU\r^1eCR\f\u0007b\u0002B!7\u0011%!1I\u0001\u0013m\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0003\u0012\t\u0015\u0003\u0002\u0003B\u001f\u0005\u007f\u0001\r!a.\t\u000f\t%3\u0004\"\u0003\u0003L\u00051b/\u00197jIB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0005Vl\u0007\u000f\u0006\u0003\u0003\u0012\t5\u0003\u0002\u0003B\u001f\u0005\u000f\u0002\r!a.\t\u000f\tE3\u0004\"\u0003\u0003T\u0005YB\u000f\u001b:poN#\u0018\r^3Ue\u0006t7/\u001b;j_:4\u0015-\u001b7ve\u0016$2\u0001\u000fB+\u0011!\u00119Fa\u0014A\u0002\u0005]\u0016A\u0005;y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006DqAa\u0017\u001c\t\u0003\u0011y!A\u000eqK:$\u0017N\\4Ue\u0006t7/\u001b;j_:Le\u000e\u0015:pOJ,7o\u001d\u0005\b\u0005?ZB\u0011\tB1\u0003!!xn\u0015;sS:<G#\u0001\u0014\t\u000f\t\u00154\u0004\"\u0011\u0003h\u00051Q-];bYN$BA!\u0005\u0003j!A!1\u000eB2\u0001\u0004\t9)\u0001\u0003uQ\u0006$\bb\u0002B87\u0011\u0005#\u0011O\u0001\tQ\u0006\u001c\bnQ8eKR\ta\nK\u0002\u001c\u0005k\u00022A\bB<\u0013\r\u0011Ih\b\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3\t\u000b\u0011:\u0002\u0019\u0001\u0014\t\u000bA:\u0002\u0019\u0001\u001a\t\u000b\u0001;\u0002\u0019\u0001\"\t\u000b1;\u0002\u0019\u0001(\t\r\t\u0015u\u00031\u00013\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0004\u0019\u0015\u0011\u0005!\u0011\u0012\u000b\u000e5\t-%Q\u0012BH\u0005#\u0013\u0019J!&\t\r\u0011\u00129\t1\u0001'\u0011\u0019\u0001$q\u0011a\u0001e!1\u0001Ia\"A\u0002\tCa\u0001\u0014BD\u0001\u0004q\u0005B\u0002-\u0003\b\u0002\u0007!\fC\u0004\u0003\u0006\n\u001d\u0005\u0019\u0001\u001a\t\u000f\te%\u0002\"\u0001\u0003\u001c\u0006Y!-\u001f;f)>\u001cF/\u0019;f)\rQ&Q\u0014\u0005\t\u0005?\u00139\n1\u0001\u0003\"\u0006!!-\u001f;f!\rq!1U\u0005\u0004\u0005K{!\u0001\u0002\"zi\u0016DqA!+\u000b\t\u0003\u0011Y+A\tjgZ\u000bG.\u001b3Ue\u0006t7/\u001b;j_:$bA!\u0005\u0003.\nE\u0006b\u0002BX\u0005O\u0003\rAW\u0001\t_2$7\u000b^1uK\"9\u00111 BT\u0001\u0004Q\u0006\"\u0003B[\u0015\t\u0007I\u0011\u0002B\\\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\t\u0011I\f\u0005\u0004(\u0005wS&qX\u0005\u0004\u0005{c#aA'baB!qE!1[\u0013\tiG\u0006\u0003\u0005\u0003F*\u0001\u000b\u0011\u0002B]\u0003Q1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3tA!I!\u0011\u001a\u0006\u0012\u0002\u0013\u0005!1Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t5'f\u0001\u001a\u0003P.\u0012!\u0011\u001b\t\u0005\u0005'\u0014i.\u0004\u0002\u0003V*!!q\u001bBm\u0003%)hn\u00195fG.,GMC\u0002\u0003\\>\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yN!6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private short producerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private Option<TransactionState> pendingState;
    private final ReentrantLock lock;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$7() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean isValidTransition(TransactionState transactionState, TransactionState transactionState2) {
        return TransactionMetadata$.MODULE$.isValidTransition(transactionState, transactionState2);
    }

    public static TransactionState byteToState(byte by2) {
        return TransactionMetadata$.MODULE$.byteToState(by2);
    }

    public static TransactionMetadata apply(String string2, long l, short s2, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string2, l, s2, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string2, long l, short s2, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string2, l, s2, n, l2);
    }

    private Logger logger$lzycompute() {
        TransactionMetadata transactionMetadata = this;
        synchronized (transactionMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void addPartitions(Set<TopicPartition> partitions2) {
        this.topicPartitions().$plus$plus$eq(partitions2);
    }

    public void removePartition(TopicPartition topicPartition) {
        block3: {
            block2: {
                TransactionState transactionState = this.state();
                PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block2;
                TransactionState transactionState2 = this.state();
                PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block3;
            }
            this.topicPartitions().$minus$eq(topicPartition);
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction metadata's current state is ", ", and its pending state is ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.state(), this.pendingState()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"while trying to remove partitions whose txn marker has been sent, this is not expected"})).s(Nil$.MODULE$)).toString());
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), this.state(), this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot fence producer with epoch equal to Short.MaxValue since this would overflow"})).s(Nil$.MODULE$));
        }
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), (short)(this.producerEpoch() + 1), this.txnTimeoutMs(), this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareIncrementProducerEpoch(int newTxnTimeoutMs, long updateTimestamp) {
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot allocate any more producer epochs for producerId ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.producerId())})));
        }
        int nextEpoch = this.producerEpoch() == -1 ? 0 : this.producerEpoch() + 1;
        return this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), (short)nextEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        long newTxnStartTimestamp = l;
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), newTxnStartTimestamp, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        TransactionState newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return this.producerEpoch() >= 32766;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing transaction state transition to ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{newState}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"while it already a pending state ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.pendingState().get()}))).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal new producer id ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(newProducerId)})));
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal new producer epoch ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToShort(newEpoch)})));
        }
        if (((SetLike)TransactionMetadata$.MODULE$.kafka$coordinator$transaction$TransactionMetadata$$validPreviousStates().apply(newState)).contains(this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, newEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)((Object)new Serializable(this, transitMetadata){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransactionMetadata $outer;
                private final TxnTransitMetadata transitMetadata$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " prepare transition from ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.transactionalId(), this.$outer.state(), this.transitMetadata$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.transitMetadata$1 = transitMetadata$1;
                }
            }));
            this.pendingState_$eq(new Some<TransactionState>(newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing transaction state transition to ", " failed since the target state"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{newState}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " is not a valid previous state of the current state ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{newState, this.state()}))).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)((Object)this.pendingState().getOrElse(new Serializable(this, transitMetadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionMetadata $outer;
            public final TxnTransitMetadata transitMetadata$2;

            public final Nothing$ apply() {
                this.$outer.fatal((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s transition to ", " failed since pendingState is not defined: this should not happen"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$coordinator$transaction$TransactionMetadata$$anonfun$$$outer(), this.$outer.transitMetadata$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.transactionalId()}))).append((Object)"completing transaction state transition while it does not have a pending state").toString());
            }

            public /* synthetic */ TransactionMetadata kafka$coordinator$transaction$TransactionMetadata$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transitMetadata$2 = transitMetadata$2;
            }
        }));
        TransactionState transactionState2 = transitMetadata.txnState();
        if (!(transactionState != null ? !transactionState.equals(transactionState2) : transactionState2 != null)) {
            TransactionState transactionState3 = toState;
            if (Empty$.MODULE$.equals(transactionState3)) {
                BoxedUnit boxedUnit;
                if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                    this.throwStateTransitionFailure(transitMetadata);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                    this.producerEpoch_$eq(transitMetadata.producerEpoch());
                    this.producerId_$eq(transitMetadata.producerId());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (Ongoing$.MODULE$.equals(transactionState3)) {
                BoxedUnit boxedUnit;
                if (this.validProducerEpoch(transitMetadata) && this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) && this.txnTimeoutMs() == transitMetadata.txnTimeoutMs() && this.txnStartTimestamp() <= transitMetadata.txnStartTimestamp()) {
                    this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                    this.addPartitions(transitMetadata.topicPartitions());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.throwStateTransitionFailure(transitMetadata);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                boolean bl = PrepareAbort$.MODULE$.equals(transactionState3) ? true : PrepareCommit$.MODULE$.equals(transactionState3);
                if (bl) {
                    BoxedUnit boxedUnit;
                    if (this.validProducerEpoch(transitMetadata) && this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) && this.txnTimeoutMs() == transitMetadata.txnTimeoutMs() && this.txnStartTimestamp() == transitMetadata.txnStartTimestamp()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.throwStateTransitionFailure(transitMetadata);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit4 = boxedUnit;
                } else {
                    boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState3) ? true : CompleteCommit$.MODULE$.equals(transactionState3);
                    if (bl2) {
                        BoxedUnit boxedUnit;
                        if (this.validProducerEpoch(transitMetadata) && this.txnTimeoutMs() == transitMetadata.txnTimeoutMs() && transitMetadata.txnStartTimestamp() != -1L) {
                            this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                            this.topicPartitions().clear();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.throwStateTransitionFailure(transitMetadata);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit5 = boxedUnit;
                    } else {
                        if (!PrepareEpochFence$.MODULE$.equals(transactionState3)) {
                            if (!Dead$.MODULE$.equals(transactionState3)) throw new MatchError(transactionState3);
                            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " is trying to complete a transition to "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionalId()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". This means that the transactionalId was being expired, and the only acceptable completion of "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{toState}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this operation is to remove the transaction metadata from the cache, not to persist the ", " in the log."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{toState}))).toString());
                        }
                        this.throwStateTransitionFailure(transitMetadata);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            this.debug((Function0<String>)((Object)new Serializable(this, transitMetadata){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TransactionMetadata $outer;
                private final TxnTransitMetadata transitMetadata$2;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " complete transition from ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.transactionalId(), this.$outer.state(), this.transitMetadata$2}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.transitMetadata$2 = transitMetadata$2;
                }
            }));
            this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
            this.pendingState_$eq(None$.MODULE$);
            this.state_$eq(toState);
            return;
        }
        this.throwStateTransitionFailure(transitMetadata);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)((Object)new Serializable(this, txnTransitMetadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionMetadata $outer;
            private final TxnTransitMetadata txnTransitMetadata$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s transition to ", " failed: this should not happen"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.toString(), this.txnTransitMetadata$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnTransitMetadata$1 = txnTransitMetadata$1;
            }
        }));
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " failed transition to state ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionalId(), txnTransitMetadata}))).append((Object)"due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return new StringBuilder().append((Object)"TransactionMetadata(").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transactionalId=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionalId()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.producerId())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToShort(this.producerEpoch())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnTimeoutMs=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.txnTimeoutMs())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.state()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pendingState=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.pendingState()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topicPartitions=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartitions()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnStartTimestamp=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.txnStartTimestamp())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnLastUpdateTimestamp=", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.txnLastUpdateTimestamp())}))).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)object;
        String string2 = this.transactionalId();
        String string3 = transactionMetadata.transactionalId();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        Seq fields = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionalId(), BoxesRunTime.boxToLong(this.producerId()), BoxesRunTime.boxToShort(this.producerEpoch()), BoxesRunTime.boxToInteger(this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong(this.txnStartTimestamp()), BoxesRunTime.boxToLong(this.txnLastUpdateTimestamp())}));
        return BoxesRunTime.unboxToInt(((TraversableOnce)fields.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Object x$1) {
                return x$1.hashCode();
            }
        }, Seq$.MODULE$.canBuildFrom())).foldLeft(BoxesRunTime.boxToInteger(0), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int a, int b) {
                return this.apply$mcIII$sp(a, b);
            }

            public int apply$mcIII$sp(int a, int b) {
                return 31 * a + b;
            }
        }));
    }

    public TransactionMetadata(String transactionalId, long producerId, short producerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging$class.$init$(this);
        this.pendingState = None$.MODULE$;
        this.lock = new ReentrantLock();
    }
}

