/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.CleanedTransactionMetadata$;
import kafka.log.Cleaner$;
import kafka.log.Cleaner$$anonfun$kafka$log$Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;

@ScalaSignature(bytes="\u0006\u0001\tEc!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005\"\u0002.\u0001\t#Z\u0016A\u00037pO\u001e,'OT1nKV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\rM#(/\u001b8h\u0011\u001d)\u0007\u00011A\u0005\n\u0019\f!B]3bI\n+hMZ3s+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016a\u0003\rq\u0017n\\\u0005\u0003Y&\u0014!BQ=uK\n+hMZ3s\u0011\u001dq\u0007\u00011A\u0005\n=\faB]3bI\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002Ka\"9\u0011/\\A\u0001\u0002\u00049\u0017a\u0001=%c!11\u000f\u0001Q!\n\u001d\f1B]3bI\n+hMZ3sA!9Q\u000f\u0001a\u0001\n\u00131\u0017aC<sSR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010A\bxe&$XMQ;gM\u0016\u0014x\fJ3r)\tQ\u0015\u0010C\u0004rm\u0006\u0005\t\u0019A4\t\rm\u0004\u0001\u0015)\u0003h\u000319(/\u001b;f\u0005V4g-\u001a:!\u0011\u001di\bA1A\u0005\ny\f1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u00029\u0003\u0019\u0011XmY8sI&!\u0011\u0011BA\u0002\u00059\u0011UO\u001a4feN+\b\u000f\u001d7jKJDq!!\u0004\u0001A\u0003%q0\u0001\u000feK\u000e|W\u000e\u001d:fgNLwN\u001c\"vM\u001a,'oU;qa2LWM\u001d\u0011\t\u0011\u0005E\u0001\u0001\"\u0001\u0003\u0003'\tQa\u00197fC:$B!!\u0006\u0002(A9\u0001\"a\u0006\u0002\u001c\u0005\u0005\u0012bAA\r\u0013\t1A+\u001e9mKJ\u00022\u0001CA\u000f\u0013\r\ty\"\u0003\u0002\u0005\u0019>tw\rE\u0002!\u0003GI1!!\n\u0003\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011!\tI#a\u0004A\u0002\u0005-\u0012!C2mK\u0006t\u0017M\u00197f!\r\u0001\u0013QF\u0005\u0004\u0003_\u0011!A\u0003'pOR{7\t\\3b]\"A\u00111\u0007\u0001\u0005\u0002\t\t)$A\u0004e_\u000ecW-\u00198\u0015\r\u0005U\u0011qGA\u001d\u0011!\tI#!\rA\u0002\u0005-\u0002\u0002CA\u001e\u0003c\u0001\r!a\u0007\u0002\u001f\u0011,G.\u001a;f\u0011>\u0014\u0018N_8o\u001bND\u0001\"a\u0010\u0001\t\u0003\u0011\u0011\u0011I\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015\u0017)\u000b\u0019%a\u0013\u0002n\u0005E\u00141\u000f\u0005\b\u0007\u0005u\u0002\u0019AA#!\r\u0001\u0013qI\u0005\u0004\u0003\u0013\u0012!a\u0001'pO\"A\u0011QJA\u001f\u0001\u0004\ty%\u0001\u0005tK\u001elWM\u001c;t!\u0019\t\t&!\u0019\u0002h9!\u00111KA/\u001d\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-+\u00051AH]8pizJ\u0011AC\u0005\u0004\u0003?J\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)GA\u0002TKFT1!a\u0018\n!\r\u0001\u0013\u0011N\u0005\u0004\u0003W\u0012!A\u0003'pON+w-\\3oi\"9\u0011qNA\u001f\u0001\u0004y\u0012aA7ba\"A\u00111HA\u001f\u0001\u0004\tY\u0002\u0003\u0005\u0002v\u0005u\u0002\u0019AA\u0011\u0003\u0015\u0019H/\u0019;t\u0011!\tI\b\u0001C\u0001\u0005\u0005m\u0014!C2mK\u0006t\u0017J\u001c;p)MQ\u0015QPAA\u0003\u0017\u000by)!%\u0002\u001c\u0006}\u0015\u0011VA^\u0011\u001d\ty(a\u001eA\u0002\u0019\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002\u0004\u0006]\u0004\u0019AAC\u00035\u0019x.\u001e:dKJ+7m\u001c:egB!\u0011\u0011AAD\u0013\u0011\tI)a\u0001\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm\u001d\u0005\t\u0003\u001b\u000b9\b1\u0001\u0002h\u0005!A-Z:u\u0011\u001d\ty'a\u001eA\u0002}A\u0001\"a%\u0002x\u0001\u0007\u0011QS\u0001\u000ee\u0016$\u0018-\u001b8EK2,G/Z:\u0011\u0007!\t9*C\u0002\u0002\u001a&\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001e\u0006]\u0004\u0019A\f\u0002#5\f\u0007\u0010T8h\u001b\u0016\u001c8/Y4f'&TX\r\u0003\u0005\u0002\"\u0006]\u0004\u0019AAR\u0003M!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b!\r\u0001\u0013QU\u0005\u0004\u0003O\u0013!AG\"mK\u0006tW\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007\u0002CAV\u0003o\u0002\r!!,\u0002\u001f\u0005\u001cG/\u001b<f!J|G-^2feN\u0004r!a,\u00026\u0006mqCD\u0002\t\u0003cK1!a-\n\u0003\u0019\u0001&/\u001a3fM&!\u0011qWA]\u0005\ri\u0015\r\u001d\u0006\u0004\u0003gK\u0001\u0002CA;\u0003o\u0002\r!!\t\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\u0006\u00112\u000f[8vY\u0012$\u0015n]2be\u0012\u0014\u0015\r^2i)!\t)*a1\u0002N\u0006=\u0007\u0002CAc\u0003{\u0003\r!a2\u0002\u000b\t\fGo\u00195\u0011\t\u0005\u0005\u0011\u0011Z\u0005\u0005\u0003\u0017\f\u0019AA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007\u0002CAQ\u0003{\u0003\r!a)\t\u0011\u0005E\u0017Q\u0018a\u0001\u0003+\u000b\u0001C]3uC&tG\u000b\u001f8NCJ\\WM]:\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u0006\u00112\u000f[8vY\u0012\u0014V\r^1j]J+7m\u001c:e)1\t)*!7\u0002\\\u0006u\u0017q\\At\u0011\u001d\ty'a5A\u0002}A\u0001\"a%\u0002T\u0002\u0007\u0011Q\u0013\u0005\t\u0003\u000b\f\u0019\u000e1\u0001\u0002H\"A\u0011QAAj\u0001\u0004\t\t\u000f\u0005\u0003\u0002\u0002\u0005\r\u0018\u0002BAs\u0003\u0007\u0011aAU3d_J$\u0007\u0002CA;\u0003'\u0004\r!!\t\t\u000f\u0005-\b\u0001\"\u0001\u0002n\u0006YqM]8x\u0005V4g-\u001a:t)\rQ\u0015q\u001e\u0005\b\u0003;\u000bI\u000f1\u0001\u0018\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003k\faB]3ti>\u0014XMQ;gM\u0016\u00148\u000fF\u0001K\u0011!\tI\u0010\u0001C\u0001\u0005\u0005m\u0018aE4s_V\u00048+Z4nK:$8OQ=TSj,GCCA\u007f\u0005\u0007\u0011YAa\u0004\u0003\u0014A1\u0011\u0011KA\u0000\u0003\u001fJAA!\u0001\u0002f\t!A*[:u\u0011!\ti%a>A\u0002\t\u0015\u0001CBA)\u0005\u000f\t9'\u0003\u0003\u0003\n\u0005\u0015$\u0001C%uKJ\f'\r\\3\t\u000f\t5\u0011q\u001fa\u0001/\u00059Q.\u0019=TSj,\u0007b\u0002B\t\u0003o\u0004\raF\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\t\u0005+\t9\u00101\u0001\u0002\u001c\u00051b-\u001b:tiVs7\r\\3b]\u0006\u0014G.Z(gMN,G\u000fC\u0004\u0003\u001a\u0001!IAa\u0007\u000231\f7\u000f^(gMN,GOR8s\r&\u00148\u000f^*fO6,g\u000e\u001e\u000b\u0007\u00037\u0011iBa\t\t\u0011\t}!q\u0003a\u0001\u0005C\tAa]3hgB1\u0011\u0011KA\u0000\u0003OB\u0001B!\u0006\u0003\u0018\u0001\u0007\u00111\u0004\u0005\t\u0005O\u0001A\u0011\u0001\u0002\u0003*\u0005q!-^5mI>3gm]3u\u001b\u0006\u0004Hc\u0003&\u0003,\t5\"\u0011\u0007B\u001b\u0005oAqa\u0001B\u0013\u0001\u0004\t)\u0005\u0003\u0005\u00030\t\u0015\u0002\u0019AA\u000e\u0003\u0015\u0019H/\u0019:u\u0011!\u0011\u0019D!\nA\u0002\u0005m\u0011aA3oI\"9\u0011q\u000eB\u0013\u0001\u0004y\u0002\u0002CA;\u0005K\u0001\r!!\t\t\u000f\tm\u0002\u0001\"\u0003\u0003>\u0005A\"-^5mI>3gm]3u\u001b\u0006\u0004hi\u001c:TK\u001elWM\u001c;\u0015!\u0005U%q\bB!\u0005\u000b\u00129Ea\u0013\u0003N\t=\u0003bBA@\u0005s\u0001\rA\u0012\u0005\t\u0005\u0007\u0012I\u00041\u0001\u0002h\u000591/Z4nK:$\bbBA8\u0005s\u0001\ra\b\u0005\t\u0005\u0013\u0012I\u00041\u0001\u0002\u001c\u0005Y1\u000f^1si>3gm]3u\u0011\u001d\tiJ!\u000fA\u0002]A\u0001\"!)\u0003:\u0001\u0007\u00111\u0015\u0005\t\u0003k\u0012I\u00041\u0001\u0002\"\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            block3: {
                block2: {
                    option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    if (!None$.MODULE$.equals(option)) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            return this.doClean(cleanable, deleteHorizonMs);
        }
        throw new MatchError(option);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)((Object)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        }));
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)((Object)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        }));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong(log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$11) {
                return x$11.lastModified();
            }
        }).getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.info((Function0<String>)((Object)new Serializable(this, deleteHorizonMs, log, cleanableHorizonMs){
            public static final long serialVersionUID = 0L;
            private final long deleteHorizonMs$1;
            private final Log log$1;
            private final long cleanableHorizonMs$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), new Date(this.cleanableHorizonMs$1), new Date(this.deleteHorizonMs$1)}));
            }
            {
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$1 = log$1;
                this.cleanableHorizonMs$1 = cleanableHorizonMs$1;
            }
        }));
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach(new Serializable(this, deleteHorizonMs, log, stats){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final long deleteHorizonMs$1;
            private final Log log$1;
            private final CleanerStats stats$2;

            public final void apply(Seq<LogSegment> group) {
                this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1, this.stats$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$1 = log$1;
                this.stats$2 = stats$2;
            }
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2<Object, CleanerStats>(BoxesRunTime.boxToLong(endOffset), stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments2, OffsetMap map2, long deleteHorizonMs, CleanerStats stats) {
        LogSegment firstSegment = (LogSegment)segments2.head();
        this.deleteCleanedFileIfExists$1(firstSegment.log().file());
        this.deleteCleanedFileIfExists$1(firstSegment.offsetIndex().file());
        this.deleteCleanedFileIfExists$1(firstSegment.timeIndex().file());
        this.deleteCleanedFileIfExists$1(firstSegment.txnIndex().file());
        long baseOffset = firstSegment.baseOffset();
        File x$19 = log.dir();
        long x$20 = baseOffset;
        LogConfig x$21 = log.config();
        Time x$22 = this.time;
        String x$23 = Log$.MODULE$.CleanedFileSuffix();
        int x$24 = log.initFileSize();
        boolean x$25 = Predef$.MODULE$.Boolean2boolean(log.config().preallocate());
        boolean x$26 = LogSegment$.MODULE$.open$default$5();
        LogSegment cleaned = LogSegment$.MODULE$.open(x$19, x$20, x$21, x$22, x$26, x$24, x$25, x$23);
        try {
            Iterator iter2 = segments2.iterator();
            Option currentSegmentOpt = new Some(iter2.next());
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)((Option)currentSegmentOpt).get();
                Option nextSegmentOpt = iter2.hasNext() ? new Some(iter2.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong(nextSegmentOpt.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$12) {
                        return x$12.baseOffset();
                    }
                }).getOrElse(new Serializable(this, map2){
                    public static final long serialVersionUID = 0L;
                    private final OffsetMap map$2;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.map$2.latestOffset() + 1L;
                    }
                    {
                        this.map$2 = map$2;
                    }
                }));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, new Some<TransactionIndex>(cleaned.txnIndex()));
                boolean retainDeletes = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)((Object)new Serializable(this, log, cleaned, currentSegment, startOffset, retainDeletes){
                    public static final long serialVersionUID = 0L;
                    private final Log log$3;
                    private final LogSegment cleaned$1;
                    private final LogSegment currentSegment$1;
                    private final long startOffset$1;
                    private final boolean retainDeletes$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning segment ", " in log ", " (largest timestamp ", ") "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.startOffset$1), this.log$3.name(), new Date(this.currentSegment$1.largestTimestamp())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"into ", ", ", " deletes."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}))).toString();
                    }
                    {
                        this.log$3 = log$3;
                        this.cleaned$1 = cleaned$1;
                        this.currentSegment$1 = currentSegment$1;
                        this.startOffset$1 = startOffset$1;
                        this.retainDeletes$1 = retainDeletes$1;
                    }
                }));
                this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map2, retainDeletes, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, log.activeProducersWithLastSequence(), stats);
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments2.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)((Object)new Serializable(this, log, segments2, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Swapping in cleaned segment ", " for segment(s) ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$13) {
                            return x$13.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",")}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in log ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$3.name()}))).toString();
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            }));
            log.replaceSegments(cleaned, segments2, log.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception exception) {
                    logCleaningAbortedException.addSuppressed(exception);
                }
            }
            finally {
                throw logCleaningAbortedException;
            }
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map2, boolean retainDeletes, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, Object> activeProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, map2, retainDeletes, transactionMetadata, activeProducers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanedTransactionMetadata transactionMetadata$1;
            private final Map activeProducers$1;
            private final CleanerStats stats$4;

            public boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            public void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$1, this.retainDeletes$2));
                return batch.hasProducerId() && this.activeProducers$1.get(BoxesRunTime.boxToLong(batch.producerId())).contains(BoxesRunTime.boxToInteger(batch.lastSequence())) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record2) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$3, this.retainDeletes$2, batch, record2, this.stats$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.transactionMetadata$1 = transactionMetadata$1;
                this.activeProducers$1 = activeProducers$1;
                this.stats$4 = stats$4;
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.kafka$log$Cleaner$$readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords(this.kafka$log$Cleaner$$readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result2 = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result2.messagesRead, result2.bytesRead);
            stats.recopyMessages(result2.messagesRetained, result2.bytesRetained);
            position += result2.bytesRead;
            ByteBuffer outputBuffer = result2.output;
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords(outputBuffer);
                dest.append(((RecordBatch)retained.batches().iterator().next()).baseOffset(), result2.maxOffset, result2.maxTimestamp, result2.shallowOffsetOfMaxTimestamp, retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || result2.messagesRead != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map2, boolean retainDeletes, RecordBatch batch, Record record2, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record2.offset() > map2.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record2.hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = record2.key();
            long foundOffset = map2.get(key);
            boolean redundant = foundOffset >= 0L && record2.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && !record2.hasValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)((Object)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append(BoxesRunTime.boxToInteger(this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments2, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        List grouped2 = Nil$.MODULE$;
        List segs = segments2.toList();
        while (segs.nonEmpty()) {
            List<LogSegment> group = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment(segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon(logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped2 = grouped2.$colon$colon(group.reverse());
        }
        return grouped2.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? segs.apply(1).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start2, long end, OffsetMap map2, CleanerStats stats) {
        map2.clear();
        Buffer dirty = log.logSegments(start2, end).toBuffer();
        this.info((Function0<String>)((Object)new Serializable(this, log, start2, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger(this.dirty$1.size()), BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        }));
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start2, end);
        CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, CleanedTransactionMetadata$.MODULE$.apply$default$2());
        BooleanRef full = BooleanRef.create(false);
        dirty.withFilter(new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        }).foreach(new Serializable(this, log, start2, map2, stats, dirty, transactionMetadata, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$2;
            private final long start$1;
            private final OffsetMap map$1;
            private final CleanerStats stats$3;
            public final Buffer dirty$1;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply(this.log$2.topicPartition());
                this.full$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicPartition(), segment, this.map$1, this.start$1, Predef$.MODULE$.Integer2int(this.log$2.config().maxMessageSize()), this.transactionMetadata$2, this.stats$3);
                if (this.full$1.elem) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$3 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.dirty$1.indexOf(this.segment$1)), BoxesRunTime.boxToLong(this.segment$1.baseOffset())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    }));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.stats$3 = stats$3;
                this.dirty$1 = dirty$1;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)((Object)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        }));
    }

    public boolean kafka$log$Cleaner$$buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map2, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                int position = segment.offsetIndex().lookup(startOffset).position();
                int maxDesiredMapSize = (int)((double)map2.slots() * this.dupBufferLoadFactor);
                while (position < segment.log().sizeInBytes()) {
                    this.kafka$log$Cleaner$$checkDone.apply(topicPartition);
                    this.kafka$log$Cleaner$$readBuffer().clear();
                    segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
                    MemoryRecords records = MemoryRecords.readableRecords(this.kafka$log$Cleaner$$readBuffer());
                    this.throttler.maybeThrottle(records.sizeInBytes());
                    int startPosition = position;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach(new Serializable(this, map2, startOffset, transactionMetadata, stats, maxDesiredMapSize, object){
                        public static final long serialVersionUID = 0L;
                        public final OffsetMap map$4;
                        public final long startOffset$2;
                        private final CleanedTransactionMetadata transactionMetadata$3;
                        public final CleanerStats stats$5;
                        public final int maxDesiredMapSize$1;
                        public final Object nonLocalReturnKey1$1;

                        public final void apply(MutableRecordBatch batch) {
                            if (batch.isControlBatch()) {
                                this.transactionMetadata$3.onControlBatchRead(batch);
                                this.stats$5.indexMessagesRead(1);
                            } else {
                                boolean isAborted = this.transactionMetadata$3.onBatchRead(batch);
                                if (isAborted) {
                                    this.stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                                } else {
                                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach(new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$kafka$log$Cleaner$$buildOffsetMapForSegment$1 $outer;

                                        public final void apply(Record record2) {
                                            if (record2.hasKey() && record2.offset() >= this.$outer.startOffset$2) {
                                                if (this.$outer.map$4.size() < this.$outer.maxDesiredMapSize$1) {
                                                    this.$outer.map$4.put(record2.key(), record2.offset());
                                                } else {
                                                    throw new NonLocalReturnControl$mcZ$sp(this.$outer.nonLocalReturnKey1$1, true);
                                                }
                                            }
                                            this.$outer.stats$5.indexMessagesRead(1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }
                            }
                            if (batch.lastOffset() >= this.startOffset$2) {
                                this.map$4.updateLatestOffset(batch.lastOffset());
                            }
                        }
                        {
                            this.map$4 = map$4;
                            this.startOffset$2 = startOffset$2;
                            this.transactionMetadata$3 = transactionMetadata$3;
                            this.stats$5 = stats$5;
                            this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    int bytesRead = records.validBytes();
                    stats.indexBytesRead(bytesRead);
                    if ((position += bytesRead) != startPosition) continue;
                    this.growBuffers(maxLogMessageSize);
                }
                this.restoreBuffers();
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    private final void deleteCleanedFileIfExists$1(File file) {
        Files.deleteIfExists(new File(new StringBuilder().append((Object)file.getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString()).toPath());
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append(BoxesRunTime.boxToInteger(id)).append((Object)": ").toString());
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
            }
        }));
    }
}

