/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import kafka.log.Log;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering$Long$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, Map<TopicPartition, Object> lastClean, long now) {
        Option option;
        long l;
        long logStartOffset2;
        Option<Object> lastCleanOffset = lastClean.get(topicPartition);
        long offset2 = BoxesRunTime.unboxToLong(lastCleanOffset.getOrElse(new Serializable(logStartOffset2 = ((LogSegment)log.logSegments().head()).baseOffset()){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.logStartOffset$1;
            }
            {
                this.logStartOffset$1 = logStartOffset$1;
            }
        }));
        if (offset2 < logStartOffset2) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String>)((Object)new Serializable(log, logStartOffset2, offset2){
                    public static final long serialVersionUID = 0L;
                    private final Log log$1;
                    private final long logStartOffset$1;
                    private final long offset$2;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting first dirty offset of ", " to log start offset ", " since the checkpointed offset ", " is invalid."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), BoxesRunTime.boxToLong(this.logStartOffset$1), BoxesRunTime.boxToLong(this.offset$2)}));
                    }
                    {
                        this.log$1 = log$1;
                        this.logStartOffset$1 = logStartOffset$1;
                        this.offset$2 = offset$2;
                    }
                }));
            }
            l = logStartOffset2;
        } else {
            l = offset2;
        }
        long firstDirtyOffset = l;
        long compactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        Option[] optionArray = new Option[3];
        optionArray[0] = log.firstUnstableOffset().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$4) {
                return x$4.messageOffset();
            }
        });
        optionArray[1] = Option$.MODULE$.apply(BoxesRunTime.boxToLong(log.activeSegment().baseOffset()));
        if (compactionLagMs > 0L) {
            Iterable<LogSegment> dirtyNonActiveSegments = log.logSegments(firstDirtyOffset, log.activeSegment().baseOffset());
            option = dirtyNonActiveSegments.find((Function1<LogSegment, Object>)((Object)new Serializable(log, now, compactionLagMs){
                public static final long serialVersionUID = 0L;
                public final Log log$1;
                public final long now$2;
                public final long compactionLagMs$1;

                /*
                 * WARNING - void declaration
                 */
                public final boolean apply(LogSegment s2) {
                    void var2_2;
                    boolean isUncleanable = s2.largestTimestamp() > this.now$2 - this.compactionLagMs$1;
                    LogCleanerManager$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, isUncleanable, s2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.12 $outer;
                        private final boolean isUncleanable$1;
                        private final LogSegment s$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking if log segment may be cleaned: log='", "' segment.baseOffset=", " segment.largestTimestamp=", "; now - compactionLag=", "; is uncleanable=", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.log$1.name(), BoxesRunTime.boxToLong(this.s$1.baseOffset()), BoxesRunTime.boxToLong(this.s$1.largestTimestamp()), BoxesRunTime.boxToLong(this.$outer.now$2 - this.$outer.compactionLagMs$1), BoxesRunTime.boxToBoolean(this.isUncleanable$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.isUncleanable$1 = isUncleanable$1;
                            this.s$1 = s$1;
                        }
                    }));
                    return (boolean)var2_2;
                }
                {
                    this.log$1 = log$1;
                    this.now$2 = now$2;
                    this.compactionLagMs$1 = compactionLagMs$1;
                }
            })).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$5) {
                    return x$5.baseOffset();
                }
            });
        } else {
            option = None$.MODULE$;
        }
        optionArray[2] = option;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong(((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])optionArray)).flatten((Function1<Option<Object>, GenTraversableOnce<Object>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Option<Object> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        }))).min(Ordering$Long$.MODULE$));
        this.debug((Function0<String>)((Object)new Serializable(log, topicPartition, now, lastCleanOffset, firstDirtyOffset, firstUncleanableDirtyOffset){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final TopicPartition topicPartition$9;
            private final long now$2;
            private final Option lastCleanOffset$1;
            private final long firstDirtyOffset$1;
            private final long firstUncleanableDirtyOffset$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding range of cleanable offsets for log=", " topicPartition=", ". Last clean offset=", " now=", " => firstDirtyOffset=", " firstUncleanableOffset=", " activeSegment.baseOffset=", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), this.topicPartition$9, this.lastCleanOffset$1, BoxesRunTime.boxToLong(this.now$2), BoxesRunTime.boxToLong(this.firstDirtyOffset$1), BoxesRunTime.boxToLong(this.firstUncleanableDirtyOffset$1), BoxesRunTime.boxToLong(this.log$1.activeSegment().baseOffset())}));
            }
            {
                this.log$1 = log$1;
                this.topicPartition$9 = topicPartition$9;
                this.now$2 = now$2;
                this.lastCleanOffset$1 = lastCleanOffset$1;
                this.firstDirtyOffset$1 = firstDirtyOffset$1;
                this.firstUncleanableDirtyOffset$1 = firstUncleanableDirtyOffset$1;
            }
        }));
        return new Tuple2$mcJJ$sp(firstDirtyOffset, firstUncleanableDirtyOffset);
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

