/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001\u001d\u0011\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u000e\u0001\t\u0015\r\u0011\"\u0003\u000f\u0003\u0019\u0019wN\u001c4jOV\tq\u0002\u0005\u0002\n!%\u0011\u0011C\u0001\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011B\b\u0002\u000f\r|gNZ5hA!AQ\u0003\u0001BC\u0002\u0013%a#A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!!\u0006\u000e\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0013DA\u0004NKR\u0014\u0018nY:\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\t\u0001\"\\3ue&\u001c7\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0005O\u0005!A/[7f+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ti#F\u0001\u0003US6,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000bQLW.\u001a\u0011\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005MJdB\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*\u0014A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u001b\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0015y\u0004)\u0011\"D!\tI\u0001\u0001C\u0003\u000ey\u0001\u0007q\u0002C\u0003\u0016y\u0001\u0007q\u0003C\u0003'y\u0001\u0007\u0001\u0006C\u00032y\u0001\u0007!\u0007C\u0004F\u0001\t\u0007I\u0011\u0001$\u0002#5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016l5/F\u0001H!\t!\u0004*\u0003\u0002Jk\t!Aj\u001c8h\u0011\u0019Y\u0005\u0001)A\u0005\u000f\u0006\u0011R.\u0019=UQJ|G\u000f\u001e7f)&lW-T:!\u0011\u0015i\u0005\u0001\"\u0001O\u00031)\u00070Z7qiN+gn]8s+\u0005y\u0005C\u0001\rQ\u0013\t\t\u0016D\u0001\u0004TK:\u001cxN\u001d\u0005\u0006'\u0002!\t\u0001V\u0001\re\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e\u000b\u0003+b\u0003\"\u0001\u000e,\n\u0005]+$\u0001B+oSRDQ!\u0017*A\u0002i\u000bQA^1mk\u0016\u0004\"\u0001N.\n\u0005q+$A\u0002#pk\ndW\rC\u0003_\u0001\u0011\u0005q,\u0001\fnCf\u0014WMU3d_J$\u0017I\u001c3UQJ|G\u000f\u001e7f)\r)\u0006\r\u001c\u0005\u0006Cv\u0003\rAY\u0001\be\u0016\fX/Z:u!\t\u0019\u0017N\u0004\u0002eO6\tQM\u0003\u0002g\t\u00059a.\u001a;x_J\\\u0017B\u00015f\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!A[6\u0003\u000fI+\u0017/^3ti*\u0011\u0001.\u001a\u0005\u0006[v\u0003\rA\\\u0001\u0015g\u0016tGMU3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\tQz\u0017/V\u0005\u0003aV\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005Q\u0012\u0018BA:6\u0005\rIe\u000e\u001e\u0005\u0006k\u0002!\tA^\u0001\u0012[\u0006L(-\u001a*fG>\u0014H-\u0012=f[B$HCA+x\u0011\u0015\tG\u000f1\u0001c\u0011\u0015I\b\u0001\"\u0015{\u00031!\bN]8ui2,G+[7f)\u0011950!\u0001\t\u000bqD\b\u0019A?\u0002\u0019\rd\u0017.\u001a8u\u001b\u0016$(/[2\u0011\u0005aq\u0018BA@\u001a\u0005-Y\u0015MZ6b\u001b\u0016$(/[2\t\r5A\b\u0019AA\u0002!\rA\u0012QA\u0005\u0004\u0003\u000fI\"\u0001D'fiJL7mQ8oM&<\u0007bBA\u0006\u0001\u0011E\u0013QB\u0001\u0015G2LWM\u001c;SCR,W*\u001a;sS\u000et\u0015-\\3\u0015\r\u0005=\u0011qCA\u000e!\u0011\t\t\"a\u0005\u000e\u0003iI1!!\u0006\u001b\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u00033\tI\u00011\u00013\u00035\u0019\u0018M\\5uSj,G-V:fe\"9\u0011QDA\u0005\u0001\u0004\u0011\u0014\u0001C2mS\u0016tG/\u00133\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u0005\u0001R\r_3naRlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0003\u001fAq!a\n\u0001\t\u0013\tI#\u0001\tfq\u0016l\u0007\u000f^*f]N|'OT1nKV\t!\u0007C\u0004\u0002.\u0001!I!a\f\u0002#9\fgn\\:U_B+'oY3oi\u0006<W\rF\u0002[\u0003cAq!a\r\u0002,\u0001\u0007q)A\u0003oC:|7\u000f")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public void recordExempt(double value2) {
        this.exemptSensor().record(value2);
    }

    public void maybeRecordAndThrottle(RequestChannel.Request request, Function1<Object, BoxedUnit> sendResponseCallback2) {
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.time().nanoseconds());
        }
        if (this.quotasEnabled()) {
            ClientSensors quotaSensors = this.getOrCreateQuotaSensors(request.session().sanitizedUser(), request.header().clientId());
            request.recordNetworkThreadTimeCallback_$eq(new Some<Function1<Object, BoxedUnit>>((Function1<Object, BoxedUnit>)((Object)new Serializable(this, quotaSensors){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;
                private final ClientSensors quotaSensors$1;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.recordNoThrottle(this.quotaSensors$1, this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaSensors$1 = quotaSensors$1;
                }
            })));
            this.recordAndThrottleOnQuotaViolation(quotaSensors, this.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(request.requestThreadTimeNanos()), sendResponseCallback2);
        } else {
            sendResponseCallback2.apply$mcVI$sp(0);
        }
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq(new Some<Function1<Object, BoxedUnit>>((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.recordExempt(this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })));
            this.recordExempt(this.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        return package$.MODULE$.min(super.throttleTime(clientMetric, config), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking request-time per user/client-id", "user", sanitizedUser, "client-id", clientId);
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder().append((Object)"exempt-").append(QuotaType$Request$.MODULE$).toString();
    }

    public double kafka$server$ClientRequestQuotaManager$$nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

