/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Base64;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenManager$ {
    public static final DelegationTokenManager$ MODULE$;
    private final String DefaultHmacAlgorithm;
    private final String OwnerKey;
    private final String RenewersKey;
    private final String IssueTimestampKey;
    private final String MaxTimestampKey;
    private final String ExpiryTimestampKey;
    private final String TokenIdKey;
    private final String VersionKey;
    private final int CurrentVersion;
    private final int ErrorTimestamp;

    static {
        new DelegationTokenManager$();
    }

    public String DefaultHmacAlgorithm() {
        return this.DefaultHmacAlgorithm;
    }

    public String OwnerKey() {
        return this.OwnerKey;
    }

    public String RenewersKey() {
        return this.RenewersKey;
    }

    public String IssueTimestampKey() {
        return this.IssueTimestampKey;
    }

    public String MaxTimestampKey() {
        return this.MaxTimestampKey;
    }

    public String ExpiryTimestampKey() {
        return this.ExpiryTimestampKey;
    }

    public String TokenIdKey() {
        return this.TokenIdKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public int ErrorTimestamp() {
        return this.ErrorTimestamp;
    }

    public byte[] createHmac(String tokenId, String secretKey) {
        return this.createHmac(tokenId, this.createSecretKey(secretKey.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretKey createSecretKey(byte[] keybytes) {
        return new SecretKeySpec(keybytes, this.DefaultHmacAlgorithm());
    }

    public String createBase64HMAC(String tokenId, SecretKey secretKey) {
        byte[] hmac = this.createHmac(tokenId, secretKey);
        return Base64.encoder().encodeToString(hmac);
    }

    public byte[] createHmac(String tokenId, SecretKey secretKey) {
        Mac mac = Mac.getInstance(this.DefaultHmacAlgorithm());
        try {
            mac.init(secretKey);
            return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", invalidKeyException);
        }
    }

    public Map<String, Object> toJsonCompatibleMap(DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        scala.collection.mutable.Map tokenInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        tokenInfoMap.update(this.VersionKey(), BoxesRunTime.boxToInteger(this.CurrentVersion()));
        tokenInfoMap.update(this.OwnerKey(), Sanitizer.sanitize(tokenInfo.ownerAsString()));
        tokenInfoMap.update(this.RenewersKey(), JavaConverters$.MODULE$.asJavaIterableConverter(((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewersAsString()).asScala()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String e) {
                return Sanitizer.sanitize(e);
            }
        }, Iterable$.MODULE$.canBuildFrom())).asJava());
        tokenInfoMap.update(this.IssueTimestampKey(), BoxesRunTime.boxToLong(tokenInfo.issueTimestamp()));
        tokenInfoMap.update(this.MaxTimestampKey(), BoxesRunTime.boxToLong(tokenInfo.maxTimestamp()));
        tokenInfoMap.update(this.ExpiryTimestampKey(), BoxesRunTime.boxToLong(tokenInfo.expiryTimestamp()));
        tokenInfoMap.update(this.TokenIdKey(), tokenInfo.tokenId());
        return tokenInfoMap.toMap(Predef$.MODULE$.$conforms());
    }

    public Option<TokenInformation> fromBytes(byte[] bytes2) {
        Option<JsonValue> option;
        block6: {
            Option option2;
            block5: {
                block4: {
                    if (bytes2 == null || Predef$.MODULE$.byteArrayOps(bytes2).isEmpty()) {
                        return None$.MODULE$;
                    }
                    option = Json$.MODULE$.parseBytes(bytes2);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    JsonValue js = (JsonValue)some.x();
                    JsonObject mainJs = js.asJsonObject();
                    Predef$.MODULE$.require(BoxesRunTime.unboxToInt(mainJs.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$)) == this.CurrentVersion());
                    KafkaPrincipal owner2 = SecurityUtils.parseKafkaPrincipal(Sanitizer.desanitize(mainJs.apply(this.OwnerKey()).to(DecodeJson$DecodeString$.MODULE$)));
                    Seq renewerStr = mainJs.apply(this.RenewersKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                    Seq renewers = ((TraversableLike)renewerStr.map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$1) {
                            return Sanitizer.desanitize(x$1);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final KafkaPrincipal apply(String x$2) {
                            return SecurityUtils.parseKafkaPrincipal(x$2);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    long issueTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.IssueTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
                    long expiryTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.ExpiryTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
                    long maxTimestamp = BoxesRunTime.unboxToLong(mainJs.apply(this.MaxTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
                    String tokenId = mainJs.apply(this.TokenIdKey()).to(DecodeJson$DecodeString$.MODULE$);
                    TokenInformation tokenInfo = new TokenInformation(tokenId, owner2, JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimestamp, maxTimestamp, expiryTimestamp);
                    option2 = new Some<TokenInformation>(tokenInfo);
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public boolean filterToken(KafkaPrincipal requestedPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken) {
        boolean allow = owners.isEmpty() || ((LinearSeqOptimized)owners.get()).exists(new Serializable(token){
            public static final long serialVersionUID = 0L;
            private final TokenInformation token$1;

            public final boolean apply(KafkaPrincipal owner2) {
                return this.token$1.ownerOrRenewer(owner2);
            }
            {
                this.token$1 = token$1;
            }
        }) ? (token.ownerOrRenewer(requestedPrincipal) ? true : BoxesRunTime.unboxToBoolean(authorizeToken.apply(token.tokenId()))) : false;
        return allow;
    }

    private DelegationTokenManager$() {
        MODULE$ = this;
        this.DefaultHmacAlgorithm = "HmacSHA512";
        this.OwnerKey = "owner";
        this.RenewersKey = "renewers";
        this.IssueTimestampKey = "issueTimestamp";
        this.MaxTimestampKey = "maxTimestamp";
        this.ExpiryTimestampKey = "expiryTimestamp";
        this.TokenIdKey = "tokenId";
        this.VersionKey = "version";
        this.CurrentVersion = 1;
        this.ErrorTimestamp = -1;
    }
}

