/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u000f\taa)\u001a;dQ6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\tA\u0001^5nKV\tq\u0003\u0005\u0002\u0019C5\t\u0011D\u0003\u0002\u00125)\u00111\u0004H\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015i\"B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001eL!AI\r\u0003\tQKW.\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005/\u0005)A/[7fA!Aa\u0005\u0001BC\u0002\u0013%q%A\u0003dC\u000eDW-F\u0001)!\tI#&D\u0001\u0003\u0013\tY#AA\tGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016D\u0001\"\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u000b=\u0002A\u0011\u0001\u0019\u0002\rqJg.\u001b;?)\r\t$g\r\t\u0003S\u0001AQ!\u0006\u0018A\u0002]AQA\n\u0018A\u0002!BQ!\u000e\u0001\u0005\u0002Y\n!B\\3x\u0007>tG/\u001a=u)\u00159$HQ&Z!\tI\u0003(\u0003\u0002:\u0005\taa)\u001a;dQ\u000e{g\u000e^3yi\")1\b\u000ea\u0001y\u0005Y!/Z9NKR\fG-\u0019;b!\ti\u0004)D\u0001?\u0015\ty$$\u0001\u0005sKF,Xm\u001d;t\u0013\t\teHA\u0007GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u0005\u0006\u0007R\u0002\r\u0001R\u0001\nM\u0016$8\r\u001b#bi\u0006\u0004\"!\u0012%\u000f\u0005%2\u0015BA$\u0003\u000311U\r^2i'\u0016\u001c8/[8o\u0013\tI%JA\u0004S\u000bF{V*\u0011)\u000b\u0005\u001d\u0013\u0001\"\u0002'5\u0001\u0004i\u0015\u0001\u0003;p\r>\u0014x-\u001a;\u0011\u00079\u001bV+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003vi&d'\"\u0001*\u0002\t)\fg/Y\u0005\u0003)>\u0013A\u0001T5tiB\u0011akV\u0007\u00025%\u0011\u0001L\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015QF\u00071\u0001\\\u0003)I7OR8mY><XM\u001d\t\u0003\u0013qK!!\u0018\u0006\u0003\u000f\t{w\u000e\\3b]\")q\f\u0001C\u0001A\u0006)\u0002/\u0019:uSRLwN\\:U_2{wm\u0015;sS:<GCA1i!\t\u0011WM\u0004\u0002\nG&\u0011AMC\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e\u0015!)\u0011N\u0018a\u0001U\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u00079[W+\u0003\u0002m\u001f\nQ1i\u001c7mK\u000e$\u0018n\u001c8")
public class FetchManager
implements Logging {
    private final Time time;
    private final FetchSessionCache cache;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FetchManager fetchManager = this;
        synchronized (fetchManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FetchContext newContext(FetchMetadata reqMetadata, Map<TopicPartition, FetchRequest.PartitionData> fetchData2, List<TopicPartition> toForget, boolean isFollower) {
        SessionErrorContext sessionErrorContext;
        FetchContext fetchContext;
        if (reqMetadata.isFull()) {
            FetchContext fetchContext2;
            ObjectRef<String> removedFetchSessionStr = ObjectRef.create("");
            if (reqMetadata.sessionId() != 0 && this.cache().remove(reqMetadata.sessionId()).isDefined()) {
                removedFetchSessionStr.elem = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Removed fetch session ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(reqMetadata.sessionId())}));
            }
            ObjectRef<String> suffix = ObjectRef.create("");
            if (reqMetadata.epoch() == -1) {
                suffix.elem = " Will not try to create a new session.";
                fetchContext2 = new SessionlessFetchContext(fetchData2);
            } else {
                fetchContext2 = new FullFetchContext(this.time(), this.cache(), reqMetadata, fetchData2, isFollower);
            }
            FetchContext context = fetchContext2;
            this.debug((Function0<String>)((Object)new Serializable(this, fetchData2, removedFetchSessionStr, suffix){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FetchManager $outer;
                private final Map fetchData$1;
                private final ObjectRef removedFetchSessionStr$1;
                private final ObjectRef suffix$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a new full FetchContext with ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.partitionsToLogString(this.fetchData$1.keySet())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{(String)this.removedFetchSessionStr$1.elem, (String)this.suffix$1.elem}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fetchData$1 = fetchData$1;
                    this.removedFetchSessionStr$1 = removedFetchSessionStr$1;
                    this.suffix$1 = suffix$1;
                }
            }));
            fetchContext = context;
            return fetchContext;
        }
        FetchSessionCache fetchSessionCache = this.cache();
        synchronized (fetchSessionCache) {
            FetchContext fetchContext3;
            Option<FetchSession> option = this.cache().get(reqMetadata.sessionId());
            if (None$.MODULE$.equals(option)) {
                this.info((Function0<String>)((Object)new Serializable(this, reqMetadata){
                    public static final long serialVersionUID = 0L;
                    private final FetchMetadata reqMetadata$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a new error FetchContext for session id ", ": "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.reqMetadata$1.sessionId())}))).append((Object)"no such session ID found.").toString();
                    }
                    {
                        this.reqMetadata$1 = reqMetadata$1;
                    }
                }));
                fetchContext3 = new SessionErrorContext(Errors.FETCH_SESSION_ID_NOT_FOUND, reqMetadata);
            } else {
                SessionErrorContext sessionErrorContext2;
                FetchSession session;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                FetchSession fetchSession = session = (FetchSession)some.x();
                synchronized (fetchSession) {
                    FetchContext fetchContext4;
                    if (session.epoch() != reqMetadata.epoch()) {
                        this.debug((Function0<String>)((Object)new Serializable(this, reqMetadata, session){
                            public static final long serialVersionUID = 0L;
                            private final FetchMetadata reqMetadata$1;
                            private final FetchSession session$3;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a new error FetchContext for session id ", ": expected "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.session$3.id())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", ", but got epoch ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.session$3.epoch()), BoxesRunTime.boxToInteger(this.reqMetadata$1.epoch())}))).toString();
                            }
                            {
                                this.reqMetadata$1 = reqMetadata$1;
                                this.session$3 = session$3;
                            }
                        }));
                        fetchContext4 = new SessionErrorContext(Errors.INVALID_FETCH_SESSION_EPOCH, reqMetadata);
                    } else {
                        Tuple3<ArrayList<TopicPartition>, ArrayList<TopicPartition>, ArrayList<TopicPartition>> tuple3;
                        Tuple3<ArrayList<TopicPartition>, ArrayList<TopicPartition>, ArrayList<TopicPartition>> tuple32 = session.update(fetchData2, toForget, reqMetadata);
                        if (tuple32 == null) throw new MatchError(tuple32);
                        ArrayList<TopicPartition> added = tuple32._1();
                        ArrayList<TopicPartition> updated2 = tuple32._2();
                        ArrayList<TopicPartition> removed = tuple32._3();
                        Tuple3<ArrayList<TopicPartition>, ArrayList<TopicPartition>, ArrayList<TopicPartition>> tuple33 = tuple3 = new Tuple3<ArrayList<TopicPartition>, ArrayList<TopicPartition>, ArrayList<TopicPartition>>(added, updated2, removed);
                        ArrayList<TopicPartition> added2 = tuple33._1();
                        ArrayList<TopicPartition> updated3 = tuple33._2();
                        ArrayList<TopicPartition> removed2 = tuple33._3();
                        if (session.isEmpty()) {
                            this.debug((Function0<String>)((Object)new Serializable(this, session, removed2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ FetchManager $outer;
                                private final FetchSession session$3;
                                private final ArrayList removed$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a new sessionless FetchContext and closing session id ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.session$3.id())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", ": after removing ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.session$3.epoch()), this.$outer.partitionsToLogString(this.removed$2)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"there are no more partitions left."})).s(Nil$.MODULE$)).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.session$3 = session$3;
                                    this.removed$2 = removed$2;
                                }
                            }));
                            this.cache().remove(session);
                            fetchContext4 = new SessionlessFetchContext(fetchData2);
                        } else {
                            if (session.size() != session.cachedSize()) {
                                this.cache().touch(session, session.lastUsedMs());
                            }
                            session.epoch_$eq(FetchMetadata.nextEpoch(session.epoch()));
                            this.debug((Function0<String>)((Object)new Serializable(this, session, added2, updated3, removed2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ FetchManager $outer;
                                private final FetchSession session$3;
                                private final ArrayList added$2;
                                private final ArrayList updated$2;
                                private final ArrayList removed$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a new incremental FetchContext for session id ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.session$3.id())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", ": added ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.session$3.epoch()), this.$outer.partitionsToLogString(this.added$2)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updated ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.partitionsToLogString(this.updated$2)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removed ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.partitionsToLogString(this.removed$2)}))).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.session$3 = session$3;
                                    this.added$2 = added$2;
                                    this.updated$2 = updated$2;
                                    this.removed$2 = removed$2;
                                }
                            }));
                            fetchContext4 = new IncrementalFetchContext(this.time(), reqMetadata, session);
                        }
                    }
                    sessionErrorContext2 = fetchContext4;
                }
                fetchContext3 = sessionErrorContext2;
            }
            sessionErrorContext = fetchContext3;
        }
        fetchContext = sessionErrorContext;
        return fetchContext;
    }

    public String partitionsToLogString(Collection<TopicPartition> partitions2) {
        return FetchSession$.MODULE$.partitionsToLogString(partitions2, this.isTraceEnabled());
    }

    public FetchManager(Time time, FetchSessionCache cache) {
        this.time = time;
        this.cache = cache;
        Logging$class.$init$(this);
    }
}

