/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.Constants$;
import kafka.server.QuotaType;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.SensorAccess;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011qCU3qY&\u001c\u0017\r^5p]F+x\u000e^1NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011ABU3qY&\u001c\u0017-U;pi\u0006D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0007G>tg-[4\u0016\u0003m\u0001\"!\u0006\u000f\n\u0005u\u0011!!\b*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\t\u0011}\u0001!\u0011!Q\u0001\nm\tqaY8oM&<\u0007\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0003#\u0003\u001diW\r\u001e:jGN,\u0012a\t\t\u0003I5j\u0011!\n\u0006\u0003C\u0019R!a\n\u0015\u0002\r\r|W.\\8o\u0015\t)\u0011F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018&\u0005\u001diU\r\u001e:jGND\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaI\u0001\t[\u0016$(/[2tA!A!\u0007\u0001BC\u0002\u0013%1'A\bsKBd\u0017nY1uS>tG+\u001f9f+\u0005!\u0004CA\u000b6\u0013\t1$AA\u0005Rk>$\u0018\rV=qK\"A\u0001\b\u0001B\u0001B\u0003%A'\u0001\tsKBd\u0017nY1uS>tG+\u001f9fA!A!\b\u0001BC\u0002\u0013%1(\u0001\u0003uS6,W#\u0001\u001f\u0011\u0005uzT\"\u0001 \u000b\u0005E1\u0013B\u0001!?\u0005\u0011!\u0016.\\3\t\u0011\t\u0003!\u0011!Q\u0001\nq\nQ\u0001^5nK\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000ba\u0001P5oSRtD#\u0002$H\u0011&S\u0005CA\u000b\u0001\u0011\u0015I2\t1\u0001\u001c\u0011\u0015\t3\t1\u0001$\u0011\u0015\u00114\t1\u00015\u0011\u0015Q4\t1\u0001=\u0011\u001da\u0005A1A\u0005\n5\u000bA\u0001\\8dWV\ta\n\u0005\u0002P16\t\u0001K\u0003\u0002R%\u0006)An\\2lg*\u00111\u000bV\u0001\u000bG>t7-\u001e:sK:$(BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0015\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\"11\f\u0001Q\u0001\n9\u000bQ\u0001\\8dW\u0002Bq!\u0018\u0001C\u0002\u0013%a,A\nuQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7/F\u0001`!\u0011\u0001\u0017m\u00196\u000e\u0003IK!A\u0019*\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002eO:\u0011\u0011\"Z\u0005\u0003M*\ta\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011aM\u0003\t\u0004WN4hB\u00017r\u001d\ti\u0007/D\u0001o\u0015\tyg!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011!OC\u0001\ba\u0006\u001c7.Y4f\u0013\t!XOA\u0002TKFT!A\u001d\u0006\u0011\u0005%9\u0018B\u0001=\u000b\u0005\rIe\u000e\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B0\u0002)QD'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:!\u0011\u001da\b\u00011A\u0005\nu\fQ!];pi\u0006,\u0012A \t\u0003I}L1!!\u0001&\u0005\u0015\tVo\u001c;b\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9!A\u0005rk>$\u0018m\u0018\u0013fcR!\u0011\u0011BA\b!\rI\u00111B\u0005\u0004\u0003\u001bQ!\u0001B+oSRD\u0011\"!\u0005\u0002\u0004\u0005\u0005\t\u0019\u0001@\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0016\u0001\u0001\u000b\u0015\u0002@\u0002\rE,x\u000e^1!\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\"\u0001\u0007tK:\u001cxN]!dG\u0016\u001c8/\u0006\u0002\u0002\u001eA\u0019Q#a\b\n\u0007\u0005\u0005\"A\u0001\u0007TK:\u001cxN]!dG\u0016\u001c8\u000f\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u000f\u00035\u0019XM\\:pe\u0006\u001b7-Z:tA!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111F\u0001\u000fe\u0006$X-T3ue&\u001cg*Y7f+\t\ti\u0003\u0005\u0003\u00020\u0005ER\"\u0001\u0014\n\u0007\u0005MbE\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016D\u0001\"a\u000e\u0001A\u0003%\u0011QF\u0001\u0010e\u0006$X-T3ue&\u001cg*Y7fA!9\u00111\b\u0001\u0005\u0002\u0005u\u0012aC;qI\u0006$X-U;pi\u0006$B!!\u0003\u0002@!1A0!\u000fA\u0002yDq!a\u0011\u0001\t\u0003\n)%A\bjgF+x\u000e^1Fq\u000e,W\rZ3e)\t\t9\u0005E\u0002\n\u0003\u0013J1!a\u0013\u000b\u0005\u001d\u0011un\u001c7fC:Dq!a\u0014\u0001\t\u0003\n\t&A\u0006jgRC'o\u001c;uY\u0016$G\u0003BA$\u0003'B\u0001\"!\u0016\u0002N\u0001\u0007\u0011qK\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ty#!\u0017\n\u0007\u0005mcE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u00051!/Z2pe\u0012$B!!\u0003\u0002d!A\u0011QMA/\u0001\u0004\t9'A\u0003wC2,X\rE\u0002\n\u0003SJ1!a\u001b\u000b\u0005\u0011auN\\4\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005iQ.\u0019:l)\"\u0014x\u000e\u001e;mK\u0012$b!!\u0003\u0002t\u0005]\u0004bBA;\u0003[\u0002\raY\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003s\ni\u00071\u0001k\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0005\b\u0003_\u0002A\u0011AA?)\u0011\tI!a \t\u000f\u0005U\u00141\u0010a\u0001G\"9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0015A\u0004:f[>4X\r\u00165s_R$H.\u001a\u000b\u0005\u0003\u0013\t9\tC\u0004\u0002v\u0005\u0005\u0005\u0019A2\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\u0006QQ\u000f\u001d9fe\n{WO\u001c3\u0015\u0005\u0005\u001d\u0004bBAI\u0001\u0011%\u00111S\u0001\u0015O\u0016$\u0018+^8uC6+GO]5d\u0007>tg-[4\u0015\t\u0005U\u00151\u0014\t\u0004I\u0005]\u0015bAAMK\taQ*\u001a;sS\u000e\u001cuN\u001c4jO\"1A0a$A\u0002yDq!a(\u0001\t\u0013\t\t+\u0001\u0004tK:\u001cxN\u001d\u000b\u0003\u0003G\u00032\u0001JAS\u0013\r\t9+\n\u0002\u0007'\u0016t7o\u001c:")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics kafka$server$ReplicationQuotaManager$$metrics;
    private final QuotaType kafka$server$ReplicationQuotaManager$$replicationType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota kafka$server$ReplicationQuotaManager$$quota;
    private final SensorAccess sensorAccess;
    private final MetricName kafka$server$ReplicationQuotaManager$$rateMetricName;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ReplicationQuotaManager replicationQuotaManager = this;
        synchronized (replicationQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    public Metrics kafka$server$ReplicationQuotaManager$$metrics() {
        return this.kafka$server$ReplicationQuotaManager$$metrics;
    }

    public QuotaType kafka$server$ReplicationQuotaManager$$replicationType() {
        return this.kafka$server$ReplicationQuotaManager$$replicationType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    public Quota kafka$server$ReplicationQuotaManager$$quota() {
        return this.kafka$server$ReplicationQuotaManager$$quota;
    }

    public void kafka$server$ReplicationQuotaManager$$quota_$eq(Quota x$1) {
        this.kafka$server$ReplicationQuotaManager$$quota = x$1;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    public MetricName kafka$server$ReplicationQuotaManager$$rateMetricName() {
        return this.kafka$server$ReplicationQuotaManager$$rateMetricName;
    }

    public void updateQuota(Quota quota) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), new Serializable(this, quota){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;
            private final Quota quota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicationQuotaManager$$quota_$eq(this.quota$1);
                KafkaMetric metric = this.$outer.kafka$server$ReplicationQuotaManager$$metrics().metrics().get(this.$outer.kafka$server$ReplicationQuotaManager$$rateMetricName());
                if (metric != null) {
                    metric.config(this.$outer.kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(this.quota$1));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quota$1 = quota$1;
            }
        });
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.kafka$server$ReplicationQuotaManager$$sensor().checkQuotas();
            return false;
        }
        catch (QuotaViolationException quotaViolationException) {
            this.trace((Function0<String>)((Object)new Serializable(this, quotaViolationException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotaManager $outer;
                private final QuotaViolationException qve$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("%s: Quota violated for sensor (%s), metric: (%s), metric-value: (%f), bound: (%f)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$server$ReplicationQuotaManager$$replicationType(), this.$outer.kafka$server$ReplicationQuotaManager$$sensor().name(), this.qve$1.metricName(), BoxesRunTime.boxToDouble(this.qve$1.value()), BoxesRunTime.boxToDouble(this.qve$1.bound())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.qve$1 = qve$1;
                }
            }));
            return true;
        }
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        Seq<Object> partitions2 = this.throttledPartitions().get(topicPartition.topic());
        return partitions2 == null ? false : partitions2 == Constants$.MODULE$.AllReplicas() || partitions2.contains(BoxesRunTime.boxToInteger(topicPartition.partition()));
    }

    public void record(long value2) {
        try {
            this.kafka$server$ReplicationQuotaManager$$sensor().record(value2);
        }
        catch (QuotaViolationException quotaViolationException) {
            this.trace((Function0<String>)((Object)new Serializable(this, value2, quotaViolationException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicationQuotaManager $outer;
                private final long value$1;
                private final QuotaViolationException qve$2;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Record: Quota violated, but ignored, for sensor (", "), metric: (", "), value : (", "), bound: (", "), recordedValue (", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$server$ReplicationQuotaManager$$sensor().name(), this.qve$2.metricName(), BoxesRunTime.boxToDouble(this.qve$2.value()), BoxesRunTime.boxToDouble(this.qve$2.bound()), BoxesRunTime.boxToLong(this.value$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.value$1 = value$1;
                    this.qve$2 = qve$2;
                }
            }));
        }
    }

    public void markThrottled(String topic, Seq<Object> partitions2) {
        this.throttledPartitions().put(topic, partitions2);
    }

    public void markThrottled(String topic) {
        this.markThrottled(topic, Constants$.MODULE$.AllReplicas());
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public long upperBound() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$server$ReplicationQuotaManager$$quota() == null ? Long.MAX_VALUE : (long)this.$outer.kafka$server$ReplicationQuotaManager$$quota().bound();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public MetricConfig kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow(this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor kafka$server$ReplicationQuotaManager$$sensor() {
        return this.sensorAccess().getOrCreate(this.kafka$server$ReplicationQuotaManager$$replicationType().toString(), ReplicationQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function0<MetricName>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final MetricName apply() {
                return this.$outer.kafka$server$ReplicationQuotaManager$$rateMetricName();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Function0<Option<MetricConfig>>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicationQuotaManager $outer;

            public final Some<MetricConfig> apply() {
                return new Some<MetricConfig>(this.$outer.kafka$server$ReplicationQuotaManager$$getQuotaMetricConfig(this.$outer.kafka$server$ReplicationQuotaManager$$quota()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), (Function0<MeasurableStat>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRate apply() {
                return new SimpleRate();
            }
        }));
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType replicationType, Time time) {
        this.config = config;
        this.kafka$server$ReplicationQuotaManager$$metrics = metrics;
        this.kafka$server$ReplicationQuotaManager$$replicationType = replicationType;
        this.time = time;
        Logging$class.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.kafka$server$ReplicationQuotaManager$$quota = null;
        this.sensorAccess = new SensorAccess(this.lock(), metrics);
        this.kafka$server$ReplicationQuotaManager$$rateMetricName = metrics.metricName("byte-rate", replicationType.toString(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking byte-rate for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicationType})));
    }
}

