/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.api.OffsetRequest$;
import kafka.common.MessageFormatter;
import kafka.common.StreamEndException;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.NewShinyConsumer;
import kafka.consumer.OldConsumer;
import kafka.tools.ConsoleConsumer;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.WakeupException;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleConsumer$
implements Logging {
    public static final ConsoleConsumer$ MODULE$;
    private int messageCount;
    private final CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    private Logger logger$lzycompute() {
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int messageCount() {
        return this.messageCount;
    }

    public void messageCount_$eq(int x$1) {
        this.messageCount = x$1;
    }

    public CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch() {
        return this.kafka$tools$ConsoleConsumer$$shutdownLatch;
    }

    public void main(String[] args) {
        ConsoleConsumer.ConsumerConfig conf = new ConsoleConsumer.ConsumerConfig(args);
        try {
            this.run(conf);
            return;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Unknown error when running consumer: ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$2;

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            }));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        catch (AuthenticationException authenticationException) {
            this.error((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Authentication failed: terminating consumer process";
                }
            }), (Function0<Throwable>)((Object)new Serializable(authenticationException){
                public static final long serialVersionUID = 0L;
                private final AuthenticationException e$1;

                public final AuthenticationException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(ConsoleConsumer.ConsumerConfig conf) {
        BaseConsumer baseConsumer;
        if (conf.useOldConsumer()) {
            this.checkZk(conf);
            Properties props = this.getOldConsumerProps(conf);
            this.checkAndMaybeDeleteOldPath(conf, props);
            baseConsumer = new OldConsumer(conf.filterSpec(), props);
        } else {
            long timeoutMs = conf.timeoutMs() >= 0 ? (long)conf.timeoutMs() : Long.MAX_VALUE;
            baseConsumer = conf.partitionArg().isDefined() ? new NewShinyConsumer(Option$.MODULE$.apply(conf.topicArg()), conf.partitionArg(), Option$.MODULE$.apply(BoxesRunTime.boxToLong(conf.offsetArg())), None$.MODULE$, this.getNewConsumerProps(conf), timeoutMs) : new NewShinyConsumer(Option$.MODULE$.apply(conf.topicArg()), None$.MODULE$, None$.MODULE$, Option$.MODULE$.apply(conf.whitelistArg()), this.getNewConsumerProps(conf), timeoutMs);
        }
        BaseConsumer consumer2 = baseConsumer;
        this.addShutdownHook(consumer2, conf);
        try {
            this.process(Predef$.MODULE$.int2Integer(conf.maxMessages()), conf.formatter(), consumer2, System.out, conf.skipMessageOnError());
            consumer2.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            if (conf.useOldConsumer() && !conf.groupIdPassed()) {
                ZkUtils$.MODULE$.maybeDeletePath(conf.options().valueOf(conf.zkConnectOpt()), new StringBuilder().append((Object)"/consumers/").append(conf.consumerProps().get("group.id")).toString());
            }
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
            return;
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            if (conf.useOldConsumer() && !conf.groupIdPassed()) {
                ZkUtils$.MODULE$.maybeDeletePath(conf.options().valueOf(conf.zkConnectOpt()), new StringBuilder().append((Object)"/consumers/").append(conf.consumerProps().get("group.id")).toString());
            }
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
            throw throwable;
        }
    }

    public void checkZk(ConsoleConsumer.ConsumerConfig config) {
        if (this.checkZkPathExists(config.options().valueOf(config.zkConnectOpt()), "/brokers/ids")) {
            if (!config.options().has(config.deleteConsumerOffsetsOpt()) && config.options().has(config.resetBeginningOpt()) && this.checkZkPathExists(config.options().valueOf(config.zkConnectOpt()), new StringBuilder().append((Object)"/consumers/").append((Object)config.consumerProps().getProperty("group.id")).append((Object)"/offsets").toString())) {
                System.err.println(new StringBuilder().append((Object)"Found previous offset information for this group ").append((Object)config.consumerProps().getProperty("group.id")).append((Object)". Please use --delete-consumer-offsets to delete previous offsets metadata").toString());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            return;
        }
        System.err.println("No brokers found in ZK.");
        throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
    }

    public void addShutdownHook(BaseConsumer consumer2, ConsoleConsumer.ConsumerConfig conf) {
        Runtime.getRuntime().addShutdownHook(new Thread(consumer2, conf){
            private final BaseConsumer consumer$1;
            private final ConsoleConsumer.ConsumerConfig conf$1;

            public void run() {
                this.consumer$1.stop();
                ConsoleConsumer$.MODULE$.kafka$tools$ConsoleConsumer$$shutdownLatch().await();
                if (this.conf$1.enableSystestEventsLogging()) {
                    System.out.println("shutdown_complete");
                }
            }
            {
                this.consumer$1 = consumer$1;
                this.conf$1 = conf$1;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Integer maxMessages, MessageFormatter formatter, BaseConsumer consumer2, PrintStream output, boolean skipMessageOnError) {
        while (this.messageCount() < Predef$.MODULE$.Integer2int(maxMessages) || BoxesRunTime.equalsNumObject(maxMessages, BoxesRunTime.boxToInteger(-1))) {
            BaseConsumerRecord baseConsumerRecord;
            try {
                baseConsumerRecord = consumer2.receive();
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error processing message, terminating consumer process: ";
                    }
                }), (Function0<Throwable>)((Object)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$3;

                    public final Throwable apply() {
                        return this.e$3;
                    }
                    {
                        this.e$3 = e$3;
                    }
                }));
                return;
            }
            catch (WakeupException wakeupException) {
                this.trace((Function0<String>)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Caught WakeupException because consumer is shutdown, ignore and terminate.";
                    }
                }));
                return;
            }
            catch (StreamEndException streamEndException) {
                this.trace((Function0<String>)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Caught StreamEndException because consumer is shutdown, ignore and terminate.";
                    }
                }));
                return;
            }
            BaseConsumerRecord msg = baseConsumerRecord;
            this.messageCount_$eq(this.messageCount() + 1);
            try {
                formatter.writeTo(new ConsumerRecord<byte[], byte[]>(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), Predef$.MODULE$.long2Long(0L), 0, 0, msg.key(), msg.value(), msg.headers()), output);
            }
            catch (Throwable throwable) {
                if (!skipMessageOnError) throw throwable;
                this.error((Function0<String>)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Error processing message, skipping this message: ";
                    }
                }), (Function0<Throwable>)((Object)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$4;

                    public final Throwable apply() {
                        return this.e$4;
                    }
                    {
                        this.e$4 = e$4;
                    }
                }));
            }
            if (!this.checkErr(output, formatter)) continue;
            return;
        }
    }

    public void reportRecordCount() {
        System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed a total of ", " messages"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.messageCount())})));
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkErr(PrintStream output, MessageFormatter formatter) {
        void var3_3;
        boolean gotError = output.checkError();
        if (gotError) {
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getOldConsumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("zookeeper.connect", config.zkConnectionStr());
        Object object = config.timeoutMs() >= 0 ? props.put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToInteger(config.timeoutMs())).toString()) : BoxedUnit.UNIT;
        return var2_2;
    }

    public void checkAndMaybeDeleteOldPath(ConsoleConsumer.ConsumerConfig config, Properties props) {
        String consumerGroupBasePath = new StringBuilder().append((Object)"/consumers/").append((Object)props.getProperty("group.id")).toString();
        if (config.options().has(config.deleteConsumerOffsetsOpt())) {
            ZkUtils$.MODULE$.maybeDeletePath(config.options().valueOf(config.zkConnectOpt()), consumerGroupBasePath);
        } else {
            boolean resetToBeginning;
            String string2 = OffsetRequest$.MODULE$.SmallestTimeString();
            String string3 = props.getProperty("auto.offset.reset");
            boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : (resetToBeginning = false);
            if (resetToBeginning && this.checkZkPathExists(config.options().valueOf(config.zkConnectOpt()), new StringBuilder().append((Object)consumerGroupBasePath).append((Object)"/offsets").toString())) {
                System.err.println(new StringBuilder().append((Object)"Found previous offset information for this group ").append((Object)props.getProperty("group.id")).append((Object)". Please use --delete-consumer-offsets to delete previous offsets metadata").toString());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Properties getNewConsumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("bootstrap.servers", config.bootstrapServer());
        props.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        props.put("isolation.level", config.isolationLevel());
        return var2_2;
    }

    public void setAutoOffsetResetValue(ConsoleConsumer.ConsumerConfig config, Properties props) {
        Tuple2<String, String> tuple2;
        Tuple2<String, String> tuple22 = tuple2 = config.useOldConsumer() ? new Tuple2<String, String>(OffsetRequest$.MODULE$.SmallestTimeString(), OffsetRequest$.MODULE$.LargestTimeString()) : new Tuple2<String, String>("earliest", "latest");
        if (tuple2 != null) {
            Tuple2<String, String> tuple23;
            String earliestConfigValue = tuple2._1();
            String latestConfigValue = tuple2._2();
            Tuple2<String, String> tuple24 = tuple23 = new Tuple2<String, String>(earliestConfigValue, latestConfigValue);
            String earliestConfigValue2 = tuple24._1();
            String latestConfigValue2 = tuple24._2();
            if (props.containsKey("auto.offset.reset")) {
                String autoResetOption = props.getProperty("auto.offset.reset");
                if (config.options().has(config.resetBeginningOpt())) {
                    String string2 = earliestConfigValue2;
                    String string3 = autoResetOption;
                    if (string2 == null ? string3 != null : !string2.equals(string3)) {
                        System.err.println(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't simultaneously specify --from-beginning and 'auto.offset.reset=", "', "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{autoResetOption}))).append((Object)"please remove one option").toString());
                        throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
                    }
                }
            } else {
                String autoResetOption = config.options().has(config.resetBeginningOpt()) ? earliestConfigValue2 : latestConfigValue2;
                props.put("auto.offset.reset", autoResetOption);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public boolean checkZkPathExists(String zkUrl, String path) {
        boolean bl;
        try {
            ZkClient zk = ZkUtils$.MODULE$.createZkClient(zkUrl, 30000, 30000);
            bl = zk.exists(path);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.messageCount = 0;
        this.kafka$tools$ConsoleConsumer$$shutdownLatch = new CountDownLatch(1);
    }
}

