/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.JsonArray;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.runtime.Nothing$;
import scala.util.Either;

public abstract class JsonValue$class {
    public static Object to(JsonValue $this, DecodeJson decodeJson) {
        return decodeJson.decode($this.node());
    }

    public static Either toEither(JsonValue $this, DecodeJson decodeJson) {
        return decodeJson.decodeEither($this.node());
    }

    public static JsonObject asJsonObject(JsonValue $this) {
        return (JsonObject)((Object)$this.asJsonObjectOption().getOrElse(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonValue $outer;

            public final Nothing$ apply() {
                throw new JsonMappingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected JSON object, received ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.node()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public static Option asJsonObjectOption(JsonValue $this) {
        Option option;
        JsonValue jsonValue = $this;
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            option = new Some<JsonObject>(jsonObject);
        } else {
            Option option2;
            JsonNode jsonNode = $this.node();
            if (jsonNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                option2 = new Some<JsonObject>(new JsonObject(objectNode));
            } else {
                option2 = None$.MODULE$;
            }
            option = option2;
        }
        return option;
    }

    public static JsonArray asJsonArray(JsonValue $this) {
        return (JsonArray)((Object)$this.asJsonArrayOption().getOrElse(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonValue $outer;

            public final Nothing$ apply() {
                throw new JsonMappingException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected JSON array, received ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.node()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public static Option asJsonArrayOption(JsonValue $this) {
        Option option;
        JsonValue jsonValue = $this;
        if (jsonValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            option = new Some<JsonArray>(jsonArray);
        } else {
            Option option2;
            JsonNode jsonNode = $this.node();
            if (jsonNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                option2 = new Some<JsonArray>(new JsonArray(arrayNode));
            } else {
                option2 = None$.MODULE$;
            }
            option = option2;
        }
        return option;
    }

    public static int hashCode(JsonValue $this) {
        return $this.node().hashCode();
    }

    public static boolean equals(JsonValue $this, Object a) {
        boolean bl;
        Object object = a;
        if (object instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)object;
            JsonNode jsonNode = $this.node();
            JsonNode jsonNode2 = jsonValue.node();
            bl = !(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public static String toString(JsonValue $this) {
        return $this.node().toString();
    }

    public static void $init$(JsonValue $this) {
    }
}

