/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskList;
import scala.Predef$;
import scala.math.Ordered;
import scala.math.Ordered$class;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\r4Q!\u0001\u0002\u0001\u0005!\u0011a\u0002V5nKJ$\u0016m]6F]R\u0014\u0018P\u0003\u0002\u0004\t\u0005)A/[7fe*\u0011QAB\u0001\u0006kRLGn\u001d\u0006\u0002\u000f\u0005)1.\u00194lCN\u0019\u0001!C\b\u0011\u0005)iQ\"A\u0006\u000b\u00031\tQa]2bY\u0006L!AD\u0006\u0003\r\u0005s\u0017PU3g!\r\u00012#F\u0007\u0002#)\u0011!cC\u0001\u0005[\u0006$\b.\u0003\u0002\u0015#\t9qJ\u001d3fe\u0016$\u0007C\u0001\f\u0001\u001b\u0005\u0011\u0001\u0002\u0003\r\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u0013QLW.\u001a:UCN\\7\u0001A\u000b\u00027A\u0011a\u0003H\u0005\u0003;\t\u0011\u0011\u0002V5nKJ$\u0016m]6\t\u0011}\u0001!\u0011!Q\u0001\nm\t!\u0002^5nKJ$\u0016m]6!\u0011!\t\u0003A!b\u0001\n\u0003\u0011\u0013\u0001D3ya&\u0014\u0018\r^5p]6\u001bX#A\u0012\u0011\u0005)!\u0013BA\u0013\f\u0005\u0011auN\\4\t\u0011\u001d\u0002!\u0011!Q\u0001\n\r\nQ\"\u001a=qSJ\fG/[8o\u001bN\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0002\u0016W1BQ\u0001\u0007\u0015A\u0002mAQ!\t\u0015A\u0002\rBqA\f\u0001A\u0002\u0013\u0005q&\u0001\u0003mSN$X#\u0001\u0019\u0011\u0005Y\t\u0014B\u0001\u001a\u0003\u00055!\u0016.\\3s)\u0006\u001c8\u000eT5ti\"9A\u0007\u0001a\u0001\n\u0003)\u0014\u0001\u00037jgR|F%Z9\u0015\u0005YJ\u0004C\u0001\u00068\u0013\tA4B\u0001\u0003V]&$\bb\u0002\u001e4\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0004B\u0002\u001f\u0001A\u0003&\u0001'A\u0003mSN$\b\u0005\u000b\u0002<}A\u0011!bP\u0005\u0003\u0001.\u0011\u0001B^8mCRLG.\u001a\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0003\u0011qW\r\u001f;\u0016\u0003UAq!\u0012\u0001A\u0002\u0013\u0005a)\u0001\u0005oKb$x\fJ3r)\t1t\tC\u0004;\t\u0006\u0005\t\u0019A\u000b\t\r%\u0003\u0001\u0015)\u0003\u0016\u0003\u0015qW\r\u001f;!\u0011\u001dY\u0005\u00011A\u0005\u0002\r\u000bA\u0001\u001d:fm\"9Q\n\u0001a\u0001\n\u0003q\u0015\u0001\u00039sKZ|F%Z9\u0015\u0005Yz\u0005b\u0002\u001eM\u0003\u0003\u0005\r!\u0006\u0005\u0007#\u0002\u0001\u000b\u0015B\u000b\u0002\u000bA\u0014XM\u001e\u0011\t\u000bM\u0003A\u0011\u0001+\u0002\u0013\r\fgnY3mY\u0016$W#A+\u0011\u0005)1\u0016BA,\f\u0005\u001d\u0011un\u001c7fC:DQ!\u0017\u0001\u0005\u0002i\u000baA]3n_Z,G#\u0001\u001c\t\u000bq\u0003A\u0011I/\u0002\u000f\r|W\u000e]1sKR\u0011a,\u0019\t\u0003\u0015}K!\u0001Y\u0006\u0003\u0007%sG\u000fC\u0003c7\u0002\u0007Q#\u0001\u0003uQ\u0006$\b")
public class TimerTaskEntry
implements Ordered<TimerTaskEntry> {
    private final TimerTask timerTask;
    private final long expirationMs;
    private volatile TimerTaskList list;
    private TimerTaskEntry next;
    private TimerTaskEntry prev;

    @Override
    public boolean $less(Object that) {
        return Ordered$class.$less(this, that);
    }

    @Override
    public boolean $greater(Object that) {
        return Ordered$class.$greater(this, that);
    }

    @Override
    public boolean $less$eq(Object that) {
        return Ordered$class.$less$eq(this, that);
    }

    @Override
    public boolean $greater$eq(Object that) {
        return Ordered$class.$greater$eq(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered$class.compareTo(this, that);
    }

    public TimerTask timerTask() {
        return this.timerTask;
    }

    public long expirationMs() {
        return this.expirationMs;
    }

    public TimerTaskList list() {
        return this.list;
    }

    public void list_$eq(TimerTaskList x$1) {
        this.list = x$1;
    }

    public TimerTaskEntry next() {
        return this.next;
    }

    public void next_$eq(TimerTaskEntry x$1) {
        this.next = x$1;
    }

    public TimerTaskEntry prev() {
        return this.prev;
    }

    public void prev_$eq(TimerTaskEntry x$1) {
        this.prev = x$1;
    }

    public boolean cancelled() {
        TimerTaskEntry timerTaskEntry = this.timerTask().getTimerTaskEntry();
        TimerTaskEntry timerTaskEntry2 = this;
        return timerTaskEntry != null ? !timerTaskEntry.equals(timerTaskEntry2) : timerTaskEntry2 != null;
    }

    public void remove() {
        TimerTaskList currentList = this.list();
        while (currentList != null) {
            currentList.remove(this);
            currentList = this.list();
        }
        return;
    }

    @Override
    public int compare(TimerTaskEntry that) {
        return new RichLong(Predef$.MODULE$.longWrapper(this.expirationMs())).compare(BoxesRunTime.boxToLong(that.expirationMs()));
    }

    public TimerTaskEntry(TimerTask timerTask, long expirationMs) {
        this.timerTask = timerTask;
        this.expirationMs = expirationMs;
        Ordered$class.$init$(this);
        this.list = null;
        this.next = null;
        this.prev = null;
        if (timerTask != null) {
            timerTask.setTimerTaskEntry(this);
        }
    }
}

