/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import scala.Array$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4Q!\u0001\u0002\u0001\u0005!\u00111\u0002V5nS:<w\u000b[3fY*\u00111\u0001B\u0001\u0006i&lWM\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT\u0011aB\u0001\u0006W\u000647.Y\n\u0003\u0001%\u0001\"AC\u0007\u000e\u0003-Q\u0011\u0001D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d-\u0011a!\u00118z%\u00164\u0007\u0002\u0003\t\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\rQL7m['t\u0007\u0001\u0001\"AC\n\n\u0005QY!\u0001\u0002'p]\u001eD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006IaF\u0001\no\",W\r\\*ju\u0016\u0004\"A\u0003\r\n\u0005eY!aA%oi\"A1\u0004\u0001B\u0001B\u0003%!#A\u0004ti\u0006\u0014H/T:\t\u0011u\u0001!\u0011!Q\u0001\ny\t1\u0002^1tW\u000e{WO\u001c;feB\u0011q\u0004K\u0007\u0002A)\u0011\u0011EI\u0001\u0007CR|W.[2\u000b\u0005\r\"\u0013AC2p]\u000e,(O]3oi*\u0011QEJ\u0001\u0005kRLGNC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\u0002#!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003\u0015\tX/Z;f!\ric\u0006M\u0007\u0002E%\u0011qF\t\u0002\u000b\t\u0016d\u0017-_)vKV,\u0007CA\u00193\u001b\u0005\u0011\u0011BA\u001a\u0003\u00055!\u0016.\\3s)\u0006\u001c8\u000eT5ti\")Q\u0007\u0001C\u0001m\u00051A(\u001b8jiz\"ba\u000e\u001d:umb\u0004CA\u0019\u0001\u0011\u0015\u0001B\u00071\u0001\u0013\u0011\u00151B\u00071\u0001\u0018\u0011\u0015YB\u00071\u0001\u0013\u0011\u0015iB\u00071\u0001\u001f\u0011\u0015YC\u00071\u0001-\u0011\u0019q\u0004\u0001)A\u0005%\u0005A\u0011N\u001c;feZ\fG\u000e\u0003\u0004A\u0001\u0001\u0006I!Q\u0001\bEV\u001c7.\u001a;t!\rQ!\tM\u0005\u0003\u0007.\u0011Q!\u0011:sCfDa!\u0012\u0001!B\u0013\u0011\u0012aC2veJ,g\u000e\u001e+j[\u0016Daa\u0012\u0001!B\u00139\u0014!D8wKJ4Gn\\<XQ\u0016,G\u000e\u000b\u0002G\u0013B\u0011!BS\u0005\u0003\u0017.\u0011\u0001B^8mCRLG.\u001a\u0005\u0007\u001b\u0002\u0001K\u0011\u0002(\u0002!\u0005$Gm\u0014<fe\u001adwn^,iK\u0016dG#A(\u0011\u0005)\u0001\u0016BA)\f\u0005\u0011)f.\u001b;\t\u000bM\u0003A\u0011\u0001+\u0002\u0007\u0005$G\r\u0006\u0002V1B\u0011!BV\u0005\u0003/.\u0011qAQ8pY\u0016\fg\u000eC\u0003Z%\u0002\u0007!,\u0001\buS6,'\u000fV1tW\u0016sGO]=\u0011\u0005EZ\u0016B\u0001/\u0003\u00059!\u0016.\\3s)\u0006\u001c8.\u00128uefDQA\u0018\u0001\u0005\u0002}\u000bA\"\u00193wC:\u001cWm\u00117pG.$\"a\u00141\t\u000b\u0005l\u0006\u0019\u0001\n\u0002\rQLW.Z'tQ\t\u00011\r\u0005\u0002eK6\tA!\u0003\u0002g\t\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class TimingWheel {
    private final long tickMs;
    private final int wheelSize;
    public final AtomicInteger kafka$utils$timer$TimingWheel$$taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private final long interval;
    private final TimerTaskList[] buckets;
    private long currentTime;
    private volatile TimingWheel overflowWheel;

    private synchronized void addOverflowWheel() {
        if (this.overflowWheel == null) {
            this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.kafka$utils$timer$TimingWheel$$taskCounter, this.queue);
        }
    }

    public boolean add(TimerTaskEntry timerTaskEntry) {
        boolean bl;
        long expiration = timerTaskEntry.expirationMs();
        if (timerTaskEntry.cancelled()) {
            bl = false;
        } else if (expiration < this.currentTime + this.tickMs) {
            bl = false;
        } else if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            TimerTaskList bucket = this.buckets[(int)(virtualId % (long)this.wheelSize)];
            bucket.add(timerTaskEntry);
            java.io.Serializable serializable = bucket.setExpiration(virtualId * this.tickMs) ? BoxesRunTime.boxToBoolean(this.queue.offer(bucket)) : BoxedUnit.UNIT;
            bl = true;
        } else {
            if (this.overflowWheel == null) {
                this.addOverflowWheel();
            }
            bl = this.overflowWheel.add(timerTaskEntry);
        }
        return bl;
    }

    public void advanceClock(long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
            if (this.overflowWheel != null) {
                this.overflowWheel.advanceClock(this.currentTime);
            }
        }
    }

    public TimingWheel(long tickMs, int wheelSize, long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.kafka$utils$timer$TimingWheel$$taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize;
        this.buckets = (TimerTaskList[])Array$.MODULE$.tabulate(wheelSize, new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimingWheel $outer;

            public final TimerTaskList apply(int x$1) {
                return new TimerTaskList(this.$outer.kafka$utils$timer$TimingWheel$$taskCounter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(TimerTaskList.class));
        this.currentTime = startMs - startMs % tickMs;
        this.overflowWheel = null;
    }
}

