/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.AdminZkClient$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001\u001d\u0011Q\"\u00113nS:T6n\u00117jK:$(BA\u0002\u0005\u0003\tQ8NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003!Q8n\u00117jK:$\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u00055Y\u0015MZ6b5.\u001cE.[3oi\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!\b\u0010\u0011\u0005]\u0001\u0001\"B\u000b\u001b\u0001\u00041\u0002\"\u0002\u0011\u0001\t\u0003\t\u0013aC2sK\u0006$X\rV8qS\u000e$bAI\u0013/gUz\u0004CA\u0005$\u0013\t!#B\u0001\u0003V]&$\b\"\u0002\u0014 \u0001\u00049\u0013!\u0002;pa&\u001c\u0007C\u0001\u0015,\u001d\tI\u0011&\u0003\u0002+\u0015\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\rM#(/\u001b8h\u0015\tQ#\u0002C\u00030?\u0001\u0007\u0001'\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\"!C\u0019\n\u0005IR!aA%oi\")Ag\ba\u0001a\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u000fYz\u0002\u0013!a\u0001o\u0005YAo\u001c9jG\u000e{gNZ5h!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003vi&d'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0001u\u0004%AA\u0002\u0005\u000bQB]1dW\u0006;\u0018M]3N_\u0012,\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0005\u0003\u0015\tG-\\5o\u0013\t15IA\u0007SC\u000e\\\u0017i^1sK6{G-\u001a\u0005\u0006\u0011\u0002!\t!S\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000fF\u0002K'R\u00032a\u0013(Q\u001b\u0005a%BA'\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f2\u00131aU3r!\t\u0011\u0015+\u0003\u0002S\u0007\nq!I]8lKJlU\r^1eCR\f\u0007b\u0002!H!\u0003\u0005\r!\u0011\u0005\b+\u001e\u0003\n\u00111\u0001W\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0004\u0013]K\u0016B\u0001-\u000b\u0005\u0019y\u0005\u000f^5p]B\u00191J\u0014\u0019\t\u000bm\u0003A\u0011\u0001/\u0002]\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000fU1uQ&s'l\u0013\u000b\u0006Eus6-\u001a\u0005\u0006Mi\u0003\ra\n\u0005\u0006?j\u0003\r\u0001Y\u0001\u001ba\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\u0005\u0017\u0006\u0004\u0014,\u0003\u0002c\u0019\n\u0019Q*\u00199\t\u000f\u0011T\u0006\u0013!a\u0001o\u000511m\u001c8gS\u001eDqA\u001a.\u0011\u0002\u0003\u0007q-\u0001\u0004va\u0012\fG/\u001a\t\u0003\u0013!L!!\u001b\u0006\u0003\u000f\t{w\u000e\\3b]\")1\u000e\u0001C\u0001Y\u0006Yb/\u00197jI\u0006$Xm\u0011:fCR,wJ]+qI\u0006$X\rV8qS\u000e$RAI7o_BDQA\n6A\u0002\u001dBQa\u00186A\u0002\u0001DQ\u0001\u001a6A\u0002]BQA\u001a6A\u0002\u001dDQA\u001d\u0001\u0005\nM\fQd\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\u0005EQ,x\u000fC\u0003'c\u0002\u0007q\u0005C\u0003wc\u0002\u0007\u0001-A\tsKBd\u0017nY1BgNLwM\\7f]RDQAZ9A\u0002\u001dDQ!\u001f\u0001\u0005\u0002i\f1\u0002Z3mKR,Gk\u001c9jGR\u0011!e\u001f\u0005\u0006Ma\u0004\ra\n\u0005\u0006{\u0002!\tA`\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\u0019\u0001|\u0018\u0011AA\u0003\u0003\u0013\ti!!\u0005\t\u000b\u0019b\b\u0019A\u0014\t\r\u0005\rA\u00101\u0001a\u0003I)\u00070[:uS:<\u0017i]:jO:lWM\u001c;\t\r\u0005\u001dA\u00101\u0001K\u0003)\tG\u000e\u001c\"s_.,'o\u001d\u0005\t\u0003\u0017a\b\u0013!a\u0001a\u0005ia.^7QCJ$\u0018\u000e^5p]ND\u0001B\u001e?\u0011\u0002\u0003\u0007\u0011q\u0002\t\u0004\u0013]\u0003\u0007\u0002CA\nyB\u0005\t\u0019A4\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\u0005Ib/\u00197jI\u0006$XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u001d\u0011\u00131DA\u000f\u0003CAaA^A\u000b\u0001\u0004\u0001\u0007bBA\u0010\u0003+\u0001\r\u0001M\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u0005\u0002$\u0005U\u0001\u0019AA\u0013\u0003I\tg/Y5mC\ndWM\u0011:pW\u0016\u0014\u0018\nZ:\u0011\t!\n9\u0003M\u0005\u0004\u0003Si#aA*fi\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012!D2iC:<WmQ8oM&<7\u000fF\u0004#\u0003c\t)$!\u000f\t\u000f\u0005M\u00121\u0006a\u0001O\u0005QQM\u001c;jif$\u0016\u0010]3\t\u000f\u0005]\u00121\u0006a\u0001O\u0005QQM\u001c;jift\u0015-\\3\t\u000f\u0005m\u00121\u0006a\u0001o\u000591m\u001c8gS\u001e\u001c\bbBA \u0001\u0011\u0005\u0011\u0011I\u0001\u0015G\"\fgnZ3DY&,g\u000e^%e\u0007>tg-[4\u0015\u000b\t\n\u0019%a\u0012\t\u000f\u0005\u0015\u0013Q\ba\u0001O\u0005\t2/\u00198ji&TX\rZ\"mS\u0016tG/\u00133\t\u000f\u0005m\u0012Q\ba\u0001o!9\u00111\n\u0001\u0005\u0002\u00055\u0013AH2iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015\u0011\u0013qJA*\u0011\u001d\t\t&!\u0013A\u0002\u001d\n1c]1oSRL'0\u001a3F]RLG/\u001f(b[\u0016Dq!a\u000f\u0002J\u0001\u0007q\u0007C\u0004\u0002X\u0001!\t!!\u0017\u0002'Y\fG.\u001b3bi\u0016$v\u000e]5d\u0007>tg-[4\u0015\u000b\t\nY&!\u0018\t\r\u0019\n)\u00061\u0001(\u0011\u001d\tY$!\u0016A\u0002]Bq!!\u0019\u0001\t\u0003\t\u0019'A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$RAIA3\u0003OBaAJA0\u0001\u00049\u0003bBA\u001e\u0003?\u0002\ra\u000e\u0005\b\u0003W\u0002A\u0011AA7\u0003I\u0019\u0007.\u00198hK\n\u0013xn[3s\u0007>tg-[4\u0015\u000b\t\ny'a\u001d\t\u000f\u0005E\u0014\u0011\u000ea\u00013\u00069!M]8lKJ\u001c\bbBA\u001e\u0003S\u0002\ra\u000e\u0005\b\u0003W\u0002A\u0011AA<)\u0015\u0011\u0013\u0011PA@\u0011!\tY(!\u001eA\u0002\u0005u\u0014A\u00022s_.,'\u000fE\u0002\n/BBq!a\u000f\u0002v\u0001\u0007q\u0007C\u0004\u0002\u0004\u0002!\t!!\"\u0002)Y\fG.\u001b3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)\r\u0011\u0013q\u0011\u0005\b\u0003w\t\t\t1\u00018\u0011\u001d\tY\t\u0001C\u0005\u0003\u001b\u000b!c\u00195b]\u001e,WI\u001c;jif\u001cuN\u001c4jOR9!%a$\u0002\u0014\u0006]\u0005bBAI\u0003\u0013\u0003\raJ\u0001\u000fe>|G/\u00128uSRLH+\u001f9f\u0011\u001d\t)*!#A\u0002\u001d\nqCZ;mYN\u000bg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\u000f\u0005m\u0012\u0011\u0012a\u0001o!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0015!\u00054fi\u000eDWI\u001c;jif\u001cuN\u001c4jOR)q'a(\u0002\"\"9\u0011\u0011SAM\u0001\u00049\u0003bBA)\u00033\u0003\ra\n\u0005\b\u0003K\u0003A\u0011AAT\u0003I9W\r^!mYR{\u0007/[2D_:4\u0017nZ:\u0015\u0005\u0005%\u0006\u0003B&bO]Bq!!,\u0001\t\u0003\ty+A\u000bgKR\u001c\u0007.\u00117m\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\t\u0005%\u0016\u0011\u0017\u0005\b\u0003g\tY\u000b1\u0001(\u0011\u001d\t)\f\u0001C\u0001\u0003o\u000b!DZ3uG\"\fE\u000e\\\"iS2$WI\u001c;jif\u001cuN\u001c4jON$b!!+\u0002:\u0006m\u0006bBAI\u0003g\u0003\ra\n\u0005\b\u0003{\u000b\u0019\f1\u0001(\u0003=\u0019\u0007.\u001b7e\u000b:$\u0018\u000e^=UsB,\u0007\"CAa\u0001E\u0005I\u0011AAb\u0003q9W\r\u001e\"s_.,'/T3uC\u0012\fG/Y:%I\u00164\u0017-\u001e7uIE*\"!!2+\u0007\u0005\u000b9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\r\t\u0019NC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAl\u0003\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tY\u000eAI\u0001\n\u0003\ti.\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}'f\u0001,\u0002H\"I\u00111\u001d\u0001\u0012\u0002\u0013\u0005\u0011Q]\u00019GJ,\u0017\r^3PeV\u0003H-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\b+\u0019;i\u0013:T6\n\n3fM\u0006,H\u000e\u001e\u00134+\t\t9OK\u00028\u0003\u000fD\u0011\"a;\u0001#\u0003%\t!!<\u0002q\r\u0014X-\u0019;f\u001fJ,\u0006\u000fZ1uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000fU1uQ&s'l\u0013\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u001e\u0016\u0004O\u0006\u001d\u0007\"CAz\u0001E\u0005I\u0011AAs\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIQB\u0011\"a>\u0001#\u0003%\t!a1\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%k!I\u00111 \u0001\u0012\u0002\u0013\u0005\u0011Q`\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"!a@+\u0007A\n9\rC\u0005\u0003\u0004\u0001\t\n\u0011\"\u0001\u0003\u0006\u00059\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H%N\u000b\u0003\u0005\u000fQC!a\u0004\u0002H\"I!1\u0002\u0001\u0012\u0002\u0013\u0005\u0011Q^\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIY\u0002")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AdminZkClient adminZkClient = this;
        synchronized (adminZkClient) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void createTopic(String topic, int partitions2, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions2, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq<Broker> brokers = brokerList.map(new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply(Seq<Object> brokerIds) {
                return (Seq)this.allBrokers$2.filter(new Serializable(this, brokerIds){
                    public static final long serialVersionUID = 0L;
                    private final Seq brokerIds$1;

                    public final boolean apply(Broker b) {
                        return this.brokerIds$1.contains(BoxesRunTime.boxToInteger(b.id()));
                    }
                    {
                        this.brokerIds$1 = brokerIds$1;
                    }
                });
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        }).getOrElse(new Serializable(this, allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply() {
                return this.allBrokers$2;
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        });
        Seq brokersWithRack = (Seq)brokers.filter((Function1<Broker, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Broker x$1) {
                return x$1.rack().nonEmpty();
            }
        }));
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq<BrokerMetadata> seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? brokers.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? brokers.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : brokers.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), broker.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq<BrokerMetadata> brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$2) {
                return x$2.id();
            }
        }, Ordering$Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update2) {
        this.validateCreateOrUpdateTopic(topic, partitionReplicaAssignment, config, update2);
        if (!update2) {
            this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        }
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, update2);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$3() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return false;
    }

    public void validateCreateOrUpdateTopic(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update2) {
        Topic.validate(topic);
        if (!update2) {
            if (this.zkClient.topicExists(topic)) {
                throw new TopicExistsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
            }
            if (Topic.hasCollisionChars(topic)) {
                Seq<String> allTopics = this.zkClient.getAllTopicsInCluster();
                if (allTopics.contains(topic)) {
                    throw new TopicExistsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
                }
                Seq collidingTopics = (Seq)allTopics.filter((Function1<String, Object>)((Object)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$2;

                    public final boolean apply(String x$3) {
                        return Topic.hasCollision(this.topic$2, x$3);
                    }
                    {
                        this.topic$2 = topic$2;
                    }
                }));
                if (collidingTopics.nonEmpty()) {
                    throw new InvalidTopicException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' collides with existing topics: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, collidingTopics.mkString(", ")})));
                }
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$4) {
                return x$4.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach(new Serializable(this, partitionReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final Map partitionReplicaAssignment$1;

            public final void apply(Seq<Object> reps) {
                if (reps.size() != reps.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)"Duplicate replica assignment found: ").append(this.partitionReplicaAssignment$1).toString());
                }
            }
            {
                this.partitionReplicaAssignment$1 = partitionReplicaAssignment$1;
            }
        });
        if (!update2) {
            LogConfig$.MODULE$.validate(config);
        }
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update2) {
        try {
            scala.collection.immutable.Map<TopicPartition, Seq<Object>> assignment = ((TraversableOnce)replicaAssignment.map((Function1<Object, Seq<Object>>)((Object)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final String topic$3;

                public final Tuple2<TopicPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> x0$1) {
                    Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int partitionId = tuple2._1$mcI$sp();
                        Seq<Object> replicas = tuple2._2();
                        Tuple2<TopicPartition, Seq<Object>> tuple22 = new Tuple2<TopicPartition, Seq<Object>>(new TopicPartition(this.topic$3, partitionId), replicas);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.topic$3 = topic$3;
                }
            }), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (update2) {
                this.info((Function0<String>)((Object)new Serializable(this, assignment){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map assignment$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic update ").append(this.assignment$1).toString();
                    }
                    {
                        this.assignment$1 = assignment$1;
                    }
                }));
                this.zkClient.setTopicAssignment(topic, assignment);
            } else {
                this.info((Function0<String>)((Object)new Serializable(this, assignment){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map assignment$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic creation ").append(this.assignment$1).toString();
                    }
                    {
                        this.assignment$1 = assignment$1;
                    }
                }));
                this.zkClient.createTopicAssignment(topic, assignment);
            }
            this.debug((Function0<String>)((Object)new Serializable(this, topic, assignment){
                public static final long serialVersionUID = 0L;
                private final String topic$3;
                private final scala.collection.immutable.Map assignment$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format(Predef$.MODULE$.genericWrapArray(new Object[]{TopicZNode$.MODULE$.path(this.topic$3), this.assignment$1}));
                }
                {
                    this.topic$3 = topic$3;
                    this.assignment$1 = assignment$1;
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteTopic(String topic) {
        if (!this.zkClient.topicExists(topic)) throw new UnknownTopicOrPartitionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic `", "` to delete does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        try {
            this.zkClient.createDeleteTopicPath(topic);
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.getMessage());
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, Seq<Object>> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Seq existingAssignmentPartition0 = (Seq)((Object)existingAssignment.getOrElse(BoxesRunTime.boxToInteger(0), new Serializable(this, topic, existingAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Map existingAssignment$1;

            public final Nothing$ apply() {
                throw new AdminOperationException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected existing replica assignment for topic '", "', partition id 0 is missing. "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignment: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.existingAssignment$1}))).toString());
            }
            {
                this.topic$1 = topic$1;
                this.existingAssignment$1 = existingAssignment$1;
            }
        }));
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions for a topic can only be increased. "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " currently has ", " partitions, "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(existingAssignment.size())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " would not be an increase."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(numPartitions)}))).toString());
        }
        replicaAssignment.foreach(new Serializable(this, allBrokers, existingAssignmentPartition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final Seq allBrokers$1;
            private final Seq existingAssignmentPartition0$1;

            public final void apply(Map<Object, Seq<Object>> proposedReplicaAssignment) {
                this.$outer.kafka$zk$AdminZkClient$$validateReplicaAssignment(proposedReplicaAssignment, this.existingAssignmentPartition0$1.size(), ((TraversableOnce)this.allBrokers$1.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(BrokerMetadata x$5) {
                        return x$5.id();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allBrokers$1 = allBrokers$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
            }
        });
        Map<Object, Seq<Object>> proposedAssignmentForNewPartitions = replicaAssignment.getOrElse(new Serializable(this, existingAssignment, allBrokers, existingAssignmentPartition0, partitionsToAdd){
            public static final long serialVersionUID = 0L;
            private final Map existingAssignment$1;
            private final Seq allBrokers$1;
            public final Seq existingAssignmentPartition0$1;
            private final int partitionsToAdd$1;

            public final Map<Object, Seq<Object>> apply() {
                int startIndex = package$.MODULE$.max(0, this.allBrokers$1.indexWhere(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final boolean apply(BrokerMetadata x$6) {
                        return x$6.id() >= BoxesRunTime.unboxToInt(this.$outer.existingAssignmentPartition0$1.head());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                return AdminUtils$.MODULE$.assignReplicasToBrokers(this.allBrokers$1, this.partitionsToAdd$1, this.existingAssignmentPartition0$1.size(), startIndex, this.existingAssignment$1.size());
            }
            {
                this.existingAssignment$1 = existingAssignment$1;
                this.allBrokers$1 = allBrokers$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
                this.partitionsToAdd$1 = partitionsToAdd$1;
            }
        });
        Map<Object, Seq<Object>> proposedAssignment = existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        if (!validateOnly) {
            this.info((Function0<String>)((Object)new Serializable(this, topic, partitionsToAdd, proposedAssignmentForNewPartitions){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partitionsToAdd$1;
                private final Map proposedAssignmentForNewPartitions$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", " partitions for '", "' with the following replica assignment: "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.partitionsToAdd$1), this.topic$1}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.proposedAssignmentForNewPartitions$1}))).toString();
                }
                {
                    this.topic$1 = topic$1;
                    this.partitionsToAdd$1 = partitionsToAdd$1;
                    this.proposedAssignmentForNewPartitions$1 = proposedAssignmentForNewPartitions$1;
                }
            }));
            String x$8 = topic;
            Map<Object, Seq<Object>> x$9 = proposedAssignment;
            boolean x$10 = true;
            Properties x$11 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$3();
            this.createOrUpdateTopicPartitionAssignmentPathInZK(x$8, x$9, x$11, x$10);
        }
        return proposedAssignment;
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public void kafka$zk$AdminZkClient$$validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach(new Serializable(this, availableBrokerIds){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerIds$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Seq<Object>> x0$2) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    Seq<Object> replicas = tuple2._2();
                    if (replicas.isEmpty()) {
                        throw new InvalidReplicaAssignmentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot have replication factor of 0 for partition id ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                    }
                    if (replicas.size() != replicas.toSet().size()) {
                        throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate brokers not allowed in replica assignment: "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for partition id ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicas.mkString(", "), BoxesRunTime.boxToInteger(partitionId)}))).toString());
                    }
                    if (replicas.toSet().subsetOf(this.availableBrokerIds$1)) {
                        Tuple2<Object, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partitionId)), BoxesRunTime.boxToInteger(replicas.size()));
                        return tuple22;
                    }
                    throw new BrokerNotAvailableException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some brokers specified for partition id ", " are not available. "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified brokers: ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicas.mkString(", ")}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available brokers: ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.availableBrokerIds$1.mkString(", ")}))).toString());
                }
                throw new MatchError(tuple2);
            }
            {
                this.availableBrokerIds$1 = availableBrokerIds$1;
            }
        });
        Map badRepFactors = replicaAssignment.collect((PartialFunction<Object, Seq<Object>>)((Object)new Serializable(this, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var6_8;
                A1 A1 = x1;
                if (A1 != null) {
                    int partition2 = A1._1$mcI$sp();
                    Seq<Object> replicas = A1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        Tuple2<Integer, Integer> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partition2)), BoxesRunTime.boxToInteger(replicas.size()));
                        return var6_8;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var6_8;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                Seq<Object> replicas;
                Tuple2<Object, Seq<Object>> tuple2 = x1;
                boolean bl = tuple2 != null && (replicas = tuple2._2()).size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }), Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Ordering$Int$.MODULE$);
            Seq partitions2 = sortedBadRepFactors.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$4) {
                    Tuple2<Object, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq repFactors = sortedBadRepFactors.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$5) {
                    Tuple2<Object, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        int rf;
                        int n = rf = tuple2._2$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent replication factor between partitions, "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition 0 has ", " while partitions [", "] have "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(expectedReplicationFactor), partitions2.mkString(", ")}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factors [", "], respectively."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{repFactors.mkString(", ")}))).toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        block6: {
            block3: {
                String string2;
                block5: {
                    block4: {
                        block2: {
                            string2 = entityType;
                            String string3 = ConfigType$.MODULE$.Topic();
                            String string4 = string2;
                            if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                            this.changeTopicConfig(entityName, configs);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        String string5 = ConfigType$.MODULE$.Client();
                        String string6 = string2;
                        if (string5 != null ? !string5.equals(string6) : string6 != null) break block4;
                        this.changeClientIdConfig(entityName, configs);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    String string7 = ConfigType$.MODULE$.User();
                    String string8 = string2;
                    if (string7 != null ? !string7.equals(string8) : string8 != null) break block5;
                    this.changeUserOrUserClientIdConfig(entityName, configs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string9 = ConfigType$.MODULE$.Broker();
                String string10 = string2;
                if (string9 != null ? !string9.equals(string10) : string10 != null) break block6;
                this.changeBrokerConfig((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{this.parseBroker$1(entityName)})), configs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a known entityType. Should be one of ", ", ", ", ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{entityType, ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.Broker()})));
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string2 = sanitizedEntityName;
        String string3 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map2 = !(string2 == null ? string3 != null : !string2.equals(string3)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate(topic);
        if (this.zkClient.topicExists(topic)) {
            LogConfig$.MODULE$.validate(configs);
            return;
        }
        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach(new Serializable(this, configs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final Properties configs$1;

            public final void apply(int broker) {
                this.apply$mcVI$sp(broker);
            }

            public void apply$mcVI$sp(int broker) {
                this.$outer.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger(broker)).toString(), this.configs$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.configs$1 = configs$1;
            }
        });
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        String entityName = broker.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$7) {
                return ((Object)BoxesRunTime.boxToInteger(x$7)).toString();
            }
        }).getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigEntityName$.MODULE$.Default();
            }
        });
        this.kafka$zk$AdminZkClient$$changeEntityConfig(ConfigType$.MODULE$.Broker(), broker.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$1) {
                return String.valueOf(x$1);
            }
        }).getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigEntityName$.MODULE$.Default();
            }
        }), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void kafka$zk$AdminZkClient$$changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder().append((Object)rootEntityType).append(BoxesRunTime.boxToCharacter('/')).append((Object)fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster().map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2<String, Properties>(topic, this.$outer.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map(new Serializable(this, entityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String entityType$1;

            public final Tuple2<String, Properties> apply(String entity) {
                return new Tuple2<String, Properties>(entity, this.$outer.fetchEntityConfig(this.entityType$1, entity));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entityType$1 = entityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.kafka$zk$AdminZkClient$$entityPaths$1(None$.MODULE$, rootEntityType).flatMap(new Serializable(this, rootEntityType, childEntityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String rootEntityType$1;
            private final String childEntityType$1;

            public final Seq<String> apply(String entity) {
                return this.$outer.kafka$zk$AdminZkClient$$entityPaths$1(new Some<String>(new StringBuilder().append((Object)entity).append(BoxesRunTime.boxToCharacter('/')).append((Object)this.childEntityType$1).toString()), this.rootEntityType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rootEntityType$1 = rootEntityType$1;
                this.childEntityType$1 = childEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map(new Serializable(this, rootEntityType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminZkClient $outer;
            private final String rootEntityType$1;

            public final Tuple2<String, Properties> apply(String entityPath) {
                return new Tuple2<String, Properties>(entityPath, this.$outer.fetchEntityConfig(this.rootEntityType$1, entityPath));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rootEntityType$1 = rootEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private final int parseBroker$1(String broker) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(broker)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing broker ", ". The broker's Entity Name must be a single integer value"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{broker})));
        }
    }

    public final Seq kafka$zk$AdminZkClient$$entityPaths$1(Option rootPath, String rootEntityType$1) {
        Option option;
        block4: {
            Option option2;
            block7: {
                Seq<String> seq;
                block6: {
                    Seq<String> entityNames2;
                    block5: {
                        String string2;
                        block3: {
                            block2: {
                                option = rootPath;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String path = (String)some.x();
                                string2 = new StringBuilder().append((Object)rootEntityType$1).append(BoxesRunTime.boxToCharacter('/')).append((Object)path).toString();
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            string2 = rootEntityType$1;
                        }
                        String root = string2;
                        entityNames2 = this.zkClient.getAllEntitiesWithConfig(root);
                        option2 = rootPath;
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String path = (String)some.x();
                        seq = entityNames2.map(new Serializable(this, path){
                            public static final long serialVersionUID = 0L;
                            private final String path$1;

                            public final String apply(String entityName) {
                                return new StringBuilder().append((Object)this.path$1).append(BoxesRunTime.boxToCharacter('/')).append((Object)entityName).toString();
                            }
                            {
                                this.path$1 = path$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    seq = entityNames2;
                }
                return seq;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging$class.$init$(this);
    }
}

