/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static final BrokerIdZNode$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String kafka$zk$BrokerIdZNode$$RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;

    static {
        new BrokerIdZNode$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    public String kafka$zk$BrokerIdZNode$$RackKey() {
        return this.kafka$zk$BrokerIdZNode$$RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    public String path(int id) {
        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BrokerIdsZNode$.MODULE$.path(), BoxesRunTime.boxToInteger(id)}));
    }

    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack) {
        Map jsonMap = (Map)scala.collection.mutable.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.VersionKey()), BoxesRunTime.boxToInteger(version)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.HostKey()), host), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.PortKey()), BoxesRunTime.boxToInteger(port)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.EndpointsKey()), JavaConverters$.MODULE$.bufferAsJavaListConverter(((TraversableOnce)advertisedEndpoints.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EndPoint x$1) {
                return x$1.connectionString();
            }
        }, Seq$.MODULE$.canBuildFrom())).toBuffer()).asJava()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.JmxPortKey()), BoxesRunTime.boxToInteger(jmxPort)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TimestampKey()), ((Object)BoxesRunTime.boxToLong(Time.SYSTEM.milliseconds())).toString())}));
        rack.foreach(new Serializable(version, jsonMap){
            public static final long serialVersionUID = 0L;
            private final int version$1;
            private final Map jsonMap$1;

            public final Object apply(String rack) {
                return this.version$1 >= 3 ? this.jsonMap$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BrokerIdZNode$.MODULE$.kafka$zk$BrokerIdZNode$$RackKey()), rack)) : BoxedUnit.UNIT;
            }
            {
                this.version$1 = version$1;
                this.jsonMap$1 = jsonMap$1;
            }
        });
        Object object = version >= 4 ? jsonMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ListenerSecurityProtocolMapKey()), JavaConverters$.MODULE$.mapAsJavaMapConverter(((TraversableOnce)advertisedEndpoints.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(EndPoint endPoint) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endPoint.listenerName().value()), endPoint.securityProtocol().name);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())) : BoxedUnit.UNIT;
        return Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        EndPoint plaintextEndpoint = broker.endPoints().find((Function1<EndPoint, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(EndPoint x$2) {
                SecurityProtocol securityProtocol2 = x$2.securityProtocol();
                SecurityProtocol securityProtocol3 = SecurityProtocol.PLAINTEXT;
                return !(securityProtocol2 != null ? !((Object)((Object)securityProtocol2)).equals((Object)((Object)securityProtocol3)) : securityProtocol3 != null);
            }
        })).getOrElse(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final EndPoint apply() {
                return new EndPoint(null, -1, null, null);
            }
        });
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack());
    }

    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Either<JsonProcessingException, JsonValue> either2 = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either2 instanceof Right) {
            Seq seq;
            Right right = (Right)either2;
            JsonValue js = (JsonValue)right.b();
            JsonObject brokerInfo = js.asJsonObject();
            int version = BoxesRunTime.unboxToInt(brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            int jmxPort = BoxesRunTime.unboxToInt(brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder().append((Object)"Unsupported version of broker registration: ").append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{new String(jsonBytes, StandardCharsets.UTF_8)}))).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt(brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol(securityProtocol2), securityProtocol2);
                seq = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endPoint}));
            } else {
                Option<scala.collection.immutable.Map<ListenerName, SecurityProtocol>> securityProtocolMap = brokerInfo.get(this.ListenerSecurityProtocolMapKey()).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.immutable.Map<ListenerName, SecurityProtocol> apply(JsonValue x$3) {
                        return ((TraversableLike)x$3.to(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()))).map(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<ListenerName, SecurityProtocol> apply(Tuple2<String, String> x0$1) {
                                Tuple2<String, String> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    String listenerName = tuple2._1();
                                    String securityProtocol2 = tuple2._2();
                                    Tuple2<ListenerName, SecurityProtocol> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new ListenerName(listenerName)), SecurityProtocol.forName(securityProtocol2));
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Map$.MODULE$.canBuildFrom());
                    }
                });
                Seq listeners2 = brokerInfo.apply(this.EndpointsKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                seq = listeners2.map(new Serializable(securityProtocolMap){
                    public static final long serialVersionUID = 0L;
                    private final Option securityProtocolMap$1;

                    public final EndPoint apply(String x$4) {
                        return EndPoint$.MODULE$.createEndPoint(x$4, this.securityProtocolMap$1);
                    }
                    {
                        this.securityProtocolMap$1 = securityProtocolMap$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            Seq endpoints2 = seq;
            Option<String> rack = brokerInfo.get(this.kafka$zk$BrokerIdZNode$$RackKey()).flatMap(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(JsonValue x$5) {
                    return x$5.to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeString$.MODULE$));
                }
            });
            BrokerInfo brokerInfo2 = new BrokerInfo(new Broker(id, endpoints2, rack), version, jmxPort);
            return brokerInfo2;
        }
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            JsonProcessingException e = (JsonProcessingException)((Object)left.a());
            throw new KafkaException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse ZooKeeper registration for broker ", ": "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{new String(jsonBytes, StandardCharsets.UTF_8)}))).toString(), e);
        }
        throw new MatchError(either2);
    }

    private BrokerIdZNode$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.kafka$zk$BrokerIdZNode$$RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
    }
}

