/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.util.internal.JacksonUtils;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.TextNode;

public abstract class JsonProperties {
    public static final Null NULL_VALUE = new Null();
    Map<String, JsonNode> props = new LinkedHashMap<String, JsonNode>(1);
    private Set<String> reserved;

    JsonProperties(Set<String> reserved) {
        this.reserved = reserved;
    }

    public String getProp(String name) {
        JsonNode value2 = this.getJsonProp(name);
        return value2 != null && value2.isTextual() ? value2.getTextValue() : null;
    }

    @Deprecated
    public synchronized JsonNode getJsonProp(String name) {
        return this.props.get(name);
    }

    public synchronized Object getObjectProp(String name) {
        return JacksonUtils.toObject(this.props.get(name));
    }

    public void addProp(String name, String value2) {
        this.addProp(name, TextNode.valueOf(value2));
    }

    @Deprecated
    public synchronized void addProp(String name, JsonNode value2) {
        if (this.reserved.contains(name)) {
            throw new AvroRuntimeException("Can't set reserved property: " + name);
        }
        if (value2 == null) {
            throw new AvroRuntimeException("Can't set a property to null: " + name);
        }
        JsonNode old = this.props.get(name);
        if (old == null) {
            this.props.put(name, value2);
        } else if (!old.equals(value2)) {
            throw new AvroRuntimeException("Can't overwrite property: " + name);
        }
    }

    public synchronized void addProp(String name, Object value2) {
        this.addProp(name, JacksonUtils.toJsonNode(value2));
    }

    @Deprecated
    public Map<String, String> getProps() {
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        for (Map.Entry<String, JsonNode> e : this.props.entrySet()) {
            if (!e.getValue().isTextual()) continue;
            result2.put(e.getKey(), e.getValue().getTextValue());
        }
        return result2;
    }

    Map<String, JsonNode> jsonProps(Map<String, String> stringProps) {
        LinkedHashMap<String, JsonNode> result2 = new LinkedHashMap<String, JsonNode>();
        for (Map.Entry<String, String> e : stringProps.entrySet()) {
            result2.put(e.getKey(), TextNode.valueOf(e.getValue()));
        }
        return result2;
    }

    @Deprecated
    public Map<String, JsonNode> getJsonProps() {
        return Collections.unmodifiableMap(this.props);
    }

    public Map<String, Object> getObjectProps() {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, JsonNode> e : this.props.entrySet()) {
            result2.put(e.getKey(), JacksonUtils.toObject(e.getValue()));
        }
        return result2;
    }

    void writeProps(JsonGenerator gen) throws IOException {
        for (Map.Entry<String, JsonNode> e : this.props.entrySet()) {
            gen.writeObjectField(e.getKey(), e.getValue());
        }
    }

    public static class Null {
        private Null() {
        }
    }
}

