/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.util.TokenBuffer;

public class JacksonUtils {
    static final String BYTES_CHARSET = "ISO-8859-1";

    private JacksonUtils() {
    }

    public static JsonNode toJsonNode(Object datum) {
        if (datum == null) {
            return null;
        }
        try {
            TokenBuffer generator = new TokenBuffer(new ObjectMapper());
            JacksonUtils.toJson(datum, generator);
            return new ObjectMapper().readTree(generator.asParser());
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    static void toJson(Object datum, JsonGenerator generator) throws IOException {
        if (datum == JsonProperties.NULL_VALUE) {
            generator.writeNull();
        } else if (datum instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry2 : ((Map)datum).entrySet()) {
                generator.writeFieldName(entry2.getKey().toString());
                JacksonUtils.toJson(entry2.getValue(), generator);
            }
            generator.writeEndObject();
        } else if (datum instanceof Collection) {
            generator.writeStartArray();
            for (Object element : (Collection)datum) {
                JacksonUtils.toJson(element, generator);
            }
            generator.writeEndArray();
        } else if (datum instanceof byte[]) {
            generator.writeString(new String((byte[])datum, BYTES_CHARSET));
        } else if (datum instanceof CharSequence || datum instanceof Enum) {
            generator.writeString(datum.toString());
        } else if (datum instanceof Double) {
            generator.writeNumber((Double)datum);
        } else if (datum instanceof Float) {
            generator.writeNumber(((Float)datum).floatValue());
        } else if (datum instanceof Long) {
            generator.writeNumber((Long)datum);
        } else if (datum instanceof Integer) {
            generator.writeNumber((Integer)datum);
        } else if (datum instanceof Boolean) {
            generator.writeBoolean((Boolean)datum);
        } else {
            throw new AvroRuntimeException("Unknown datum class: " + datum.getClass());
        }
    }

    public static Object toObject(JsonNode jsonNode) {
        return JacksonUtils.toObject(jsonNode, null);
    }

    public static Object toObject(JsonNode jsonNode, Schema schema) {
        if (schema != null && schema.getType().equals((Object)Schema.Type.UNION)) {
            return JacksonUtils.toObject(jsonNode, schema.getTypes().get(0));
        }
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isNull()) {
            return JsonProperties.NULL_VALUE;
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isInt()) {
            if (schema == null || schema.getType().equals((Object)Schema.Type.INT)) {
                return jsonNode.asInt();
            }
            if (schema.getType().equals((Object)Schema.Type.LONG)) {
                return jsonNode.asLong();
            }
        } else {
            if (jsonNode.isLong()) {
                return jsonNode.asLong();
            }
            if (jsonNode.isDouble()) {
                if (schema == null || schema.getType().equals((Object)Schema.Type.DOUBLE)) {
                    return jsonNode.asDouble();
                }
                if (schema.getType().equals((Object)Schema.Type.FLOAT)) {
                    return Float.valueOf((float)jsonNode.asDouble());
                }
            } else if (jsonNode.isTextual()) {
                if (schema == null || schema.getType().equals((Object)Schema.Type.STRING) || schema.getType().equals((Object)Schema.Type.ENUM)) {
                    return jsonNode.asText();
                }
                if (schema.getType().equals((Object)Schema.Type.BYTES) || schema.getType().equals((Object)Schema.Type.FIXED)) {
                    try {
                        return jsonNode.getTextValue().getBytes(BYTES_CHARSET);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AvroRuntimeException(e);
                    }
                }
            } else {
                if (jsonNode.isArray()) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    for (JsonNode node2 : jsonNode) {
                        l.add(JacksonUtils.toObject(node2, schema == null ? null : schema.getElementType()));
                    }
                    return l;
                }
                if (jsonNode.isObject()) {
                    LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                    Iterator<String> it = jsonNode.getFieldNames();
                    while (it.hasNext()) {
                        String key = it.next();
                        Schema s2 = null;
                        if (schema == null) {
                            s2 = null;
                        } else if (schema.getType().equals((Object)Schema.Type.MAP)) {
                            s2 = schema.getValueType();
                        } else if (schema.getType().equals((Object)Schema.Type.RECORD)) {
                            s2 = schema.getField(key).schema();
                        }
                        Object value2 = JacksonUtils.toObject(jsonNode.get(key), s2);
                        m.put(key, value2);
                    }
                    return m;
                }
            }
        }
        return null;
    }
}

