/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int COPY_BUF_SIZE = 8024;
    private static final int SKIP_BUF_SIZE = 4096;
    private static final byte[] SKIP_BUF = new byte[4096];

    private IOUtils() {
    }

    public static long copy(InputStream input2, OutputStream output) throws IOException {
        return IOUtils.copy(input2, output, 8024);
    }

    public static long copy(InputStream input2, OutputStream output, int buffersize) throws IOException {
        byte[] buffer = new byte[buffersize];
        int n = 0;
        long count2 = 0L;
        while (-1 != (n = input2.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static long skip(InputStream input2, long numToSkip) throws IOException {
        int read2;
        long skipped;
        long available = numToSkip;
        while (numToSkip > 0L && (skipped = input2.skip(numToSkip)) != 0L) {
            numToSkip -= skipped;
        }
        while (numToSkip > 0L && (read2 = IOUtils.readFully(input2, SKIP_BUF, 0, (int)Math.min(numToSkip, 4096L))) >= 1) {
            numToSkip -= (long)read2;
        }
        return available - numToSkip;
    }

    public static int readFully(InputStream input2, byte[] b) throws IOException {
        return IOUtils.readFully(input2, b, 0, b.length);
    }

    public static int readFully(InputStream input2, byte[] b, int offset2, int len) throws IOException {
        int count2;
        if (len < 0 || offset2 < 0 || len + offset2 > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int x = 0;
        for (count2 = 0; count2 != len && (x = input2.read(b, offset2 + count2, len - count2)) != -1; count2 += x) {
        }
        return count2;
    }

    public static byte[] toByteArray(InputStream input2) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy(input2, output);
        return output.toByteArray();
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

