/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.common.TopicPartition;

public class NoOffsetForPartitionException
extends InvalidOffsetException {
    private static final long serialVersionUID = 1L;
    private final Set<TopicPartition> partitions;

    public NoOffsetForPartitionException(TopicPartition partition2) {
        super("Undefined offset with no reset policy for partition: " + partition2);
        this.partitions = Collections.singleton(partition2);
    }

    public NoOffsetForPartitionException(Collection<TopicPartition> partitions2) {
        super("Undefined offset with no reset policy for partitions: " + partitions2);
        this.partitions = Collections.unmodifiableSet(new HashSet<TopicPartition>(partitions2));
    }

    @Deprecated
    public TopicPartition partition() {
        return this.partitions.isEmpty() ? null : this.partitions.iterator().next();
    }

    @Override
    public Set<TopicPartition> partitions() {
        return this.partitions;
    }
}

