/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.utils.Time;

public class BufferPool {
    static final String WAIT_TIME_SENSOR_NAME = "bufferpool-wait-time";
    private final long totalMemory;
    private final int poolableSize;
    private final ReentrantLock lock;
    private final Deque<ByteBuffer> free;
    private final Deque<Condition> waiters;
    private long nonPooledAvailableMemory;
    private final Metrics metrics;
    private final Time time;
    private final Sensor waitTime;

    public BufferPool(long memory, int poolableSize, Metrics metrics, Time time, String metricGrpName) {
        this.poolableSize = poolableSize;
        this.lock = new ReentrantLock();
        this.free = new ArrayDeque<ByteBuffer>();
        this.waiters = new ArrayDeque<Condition>();
        this.totalMemory = memory;
        this.nonPooledAvailableMemory = memory;
        this.metrics = metrics;
        this.time = time;
        this.waitTime = this.metrics.sensor(WAIT_TIME_SENSOR_NAME);
        MetricName rateMetricName = metrics.metricName("bufferpool-wait-ratio", metricGrpName, "The fraction of time an appender waits for space allocation.");
        MetricName totalMetricName = metrics.metricName("bufferpool-wait-time-total", metricGrpName, "The total time an appender waits for space allocation.");
        this.waitTime.add(new Meter(TimeUnit.NANOSECONDS, rateMetricName, totalMetricName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocate(int size2, long maxTimeToBlockMs) throws InterruptedException {
        ByteBuffer buffer;
        block25: {
            if ((long)size2 > this.totalMemory) {
                throw new IllegalArgumentException("Attempt to allocate " + size2 + " bytes, but there is a hard limit of " + this.totalMemory + " on memory allocations.");
            }
            buffer = null;
            this.lock.lock();
            try {
                if (size2 == this.poolableSize && !this.free.isEmpty()) {
                    ByteBuffer byteBuffer = this.free.pollFirst();
                    return byteBuffer;
                }
                int freeListSize = this.freeSize() * this.poolableSize;
                if (this.nonPooledAvailableMemory + (long)freeListSize >= (long)size2) {
                    this.freeUp(size2);
                    this.nonPooledAvailableMemory -= (long)size2;
                    break block25;
                }
                int accumulated = 0;
                Condition moreMemory = this.lock.newCondition();
                try {
                    long remainingTimeToBlockNs = TimeUnit.MILLISECONDS.toNanos(maxTimeToBlockMs);
                    this.waiters.addLast(moreMemory);
                    while (accumulated < size2) {
                        long timeNs;
                        boolean waitingTimeElapsed;
                        long startWaitNs = this.time.nanoseconds();
                        try {
                            waitingTimeElapsed = !moreMemory.await(remainingTimeToBlockNs, TimeUnit.NANOSECONDS);
                        }
                        finally {
                            long endWaitNs = this.time.nanoseconds();
                            timeNs = Math.max(0L, endWaitNs - startWaitNs);
                            this.waitTime.record(timeNs, this.time.milliseconds());
                        }
                        if (waitingTimeElapsed) {
                            throw new TimeoutException("Failed to allocate memory within the configured max blocking time " + maxTimeToBlockMs + " ms.");
                        }
                        remainingTimeToBlockNs -= timeNs;
                        if (accumulated == 0 && size2 == this.poolableSize && !this.free.isEmpty()) {
                            buffer = this.free.pollFirst();
                            accumulated = size2;
                            continue;
                        }
                        this.freeUp(size2 - accumulated);
                        int got = (int)Math.min((long)(size2 - accumulated), this.nonPooledAvailableMemory);
                        this.nonPooledAvailableMemory -= (long)got;
                        accumulated += got;
                    }
                    accumulated = 0;
                }
                finally {
                    this.nonPooledAvailableMemory += (long)accumulated;
                    this.waiters.remove(moreMemory);
                }
            }
            finally {
                try {
                    if (!(this.nonPooledAvailableMemory == 0L && this.free.isEmpty() || this.waiters.isEmpty())) {
                        this.waiters.peekFirst().signal();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if (buffer == null) {
            return this.safeAllocateByteBuffer(size2);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer safeAllocateByteBuffer(int size2) {
        boolean error = true;
        try {
            ByteBuffer buffer = this.allocateByteBuffer(size2);
            error = false;
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            if (error) {
                this.lock.lock();
                try {
                    this.nonPooledAvailableMemory += (long)size2;
                    if (!this.waiters.isEmpty()) {
                        this.waiters.peekFirst().signal();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    protected ByteBuffer allocateByteBuffer(int size2) {
        return ByteBuffer.allocate(size2);
    }

    private void freeUp(int size2) {
        while (!this.free.isEmpty() && this.nonPooledAvailableMemory < (long)size2) {
            this.nonPooledAvailableMemory += (long)this.free.pollLast().capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(ByteBuffer buffer, int size2) {
        this.lock.lock();
        try {
            if (size2 == this.poolableSize && size2 == buffer.capacity()) {
                buffer.clear();
                this.free.add(buffer);
            } else {
                this.nonPooledAvailableMemory += (long)size2;
            }
            Condition moreMem = this.waiters.peekFirst();
            if (moreMem != null) {
                moreMem.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deallocate(ByteBuffer buffer) {
        this.deallocate(buffer, buffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long availableMemory() {
        this.lock.lock();
        try {
            long l = this.nonPooledAvailableMemory + (long)this.freeSize() * (long)this.poolableSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int freeSize() {
        return this.free.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unallocatedMemory() {
        this.lock.lock();
        try {
            long l = this.nonPooledAvailableMemory;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queued() {
        this.lock.lock();
        try {
            int n = this.waiters.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int poolableSize() {
        return this.poolableSize;
    }

    public long totalMemory() {
        return this.totalMemory;
    }

    Deque<Condition> waiters() {
        return this.waiters;
    }
}

