/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;

public final class FutureRecordMetadata
implements Future<RecordMetadata> {
    private final ProduceRequestResult result;
    private final long relativeOffset;
    private final long createTimestamp;
    private final Long checksum;
    private final int serializedKeySize;
    private final int serializedValueSize;
    private volatile FutureRecordMetadata nextRecordMetadata = null;

    public FutureRecordMetadata(ProduceRequestResult result2, long relativeOffset, long createTimestamp, Long checksum, int serializedKeySize, int serializedValueSize) {
        this.result = result2;
        this.relativeOffset = relativeOffset;
        this.createTimestamp = createTimestamp;
        this.checksum = checksum;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
    }

    @Override
    public boolean cancel(boolean interrupt) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public RecordMetadata get() throws InterruptedException, ExecutionException {
        this.result.await();
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.get();
        }
        return this.valueOrError();
    }

    @Override
    public RecordMetadata get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long now = System.currentTimeMillis();
        long deadline = Long.MAX_VALUE - timeout < now ? Long.MAX_VALUE : now + timeout;
        boolean occurred = this.result.await(timeout, unit);
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.get(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
        if (!occurred) {
            throw new TimeoutException("Timeout after waiting for " + TimeUnit.MILLISECONDS.convert(timeout, unit) + " ms.");
        }
        return this.valueOrError();
    }

    void chain(FutureRecordMetadata futureRecordMetadata) {
        if (this.nextRecordMetadata == null) {
            this.nextRecordMetadata = futureRecordMetadata;
        } else {
            this.nextRecordMetadata.chain(futureRecordMetadata);
        }
    }

    RecordMetadata valueOrError() throws ExecutionException {
        if (this.result.error() != null) {
            throw new ExecutionException(this.result.error());
        }
        return this.value();
    }

    Long checksumOrNull() {
        return this.checksum;
    }

    RecordMetadata value() {
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.value();
        }
        return new RecordMetadata(this.result.topicPartition(), this.result.baseOffset(), this.relativeOffset, this.timestamp(), this.checksum, this.serializedKeySize, this.serializedValueSize);
    }

    private long timestamp() {
        return this.result.hasLogAppendTime() ? this.result.logAppendTime() : this.createTimestamp;
    }

    @Override
    public boolean isDone() {
        if (this.nextRecordMetadata != null) {
            return this.nextRecordMetadata.isDone();
        }
        return this.result.completed();
    }
}

