/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import java.util.Objects;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.resource.Resource;

@InterfaceStability.Evolving
public class AclBinding {
    private final Resource resource;
    private final AccessControlEntry entry;

    public AclBinding(Resource resource, AccessControlEntry entry2) {
        Objects.requireNonNull(resource);
        this.resource = resource;
        Objects.requireNonNull(entry2);
        this.entry = entry2;
    }

    public boolean isUnknown() {
        return this.resource.isUnknown() || this.entry.isUnknown();
    }

    public Resource resource() {
        return this.resource;
    }

    public final AccessControlEntry entry() {
        return this.entry;
    }

    public AclBindingFilter toFilter() {
        return new AclBindingFilter(this.resource.toFilter(), this.entry.toFilter());
    }

    public String toString() {
        return "(resource=" + this.resource + ", entry=" + this.entry + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof AclBinding)) {
            return false;
        }
        AclBinding other = (AclBinding)o;
        return this.resource.equals(other.resource) && this.entry.equals(other.entry);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.entry);
    }
}

