/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.memory;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMemoryPool
implements MemoryPool {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final long sizeBytes;
    protected final boolean strict;
    protected final AtomicLong availableMemory;
    protected final int maxSingleAllocationSize;
    protected final AtomicLong startOfNoMemPeriod = new AtomicLong();
    protected volatile Sensor oomTimeSensor;

    public SimpleMemoryPool(long sizeInBytes2, int maxSingleAllocationBytes, boolean strict, Sensor oomPeriodSensor) {
        if (sizeInBytes2 <= 0L || maxSingleAllocationBytes <= 0 || (long)maxSingleAllocationBytes > sizeInBytes2) {
            throw new IllegalArgumentException("must provide a positive size and max single allocation size smaller than size.provided " + sizeInBytes2 + " and " + maxSingleAllocationBytes + " respectively");
        }
        this.sizeBytes = sizeInBytes2;
        this.strict = strict;
        this.availableMemory = new AtomicLong(sizeInBytes2);
        this.maxSingleAllocationSize = maxSingleAllocationBytes;
        this.oomTimeSensor = oomPeriodSensor;
    }

    @Override
    public ByteBuffer tryAllocate(int sizeBytes) {
        long available;
        long threshold;
        if (sizeBytes < 1) {
            throw new IllegalArgumentException("requested size " + sizeBytes + "<=0");
        }
        if (sizeBytes > this.maxSingleAllocationSize) {
            throw new IllegalArgumentException("requested size " + sizeBytes + " is larger than maxSingleAllocationSize " + this.maxSingleAllocationSize);
        }
        boolean success = false;
        long l = threshold = this.strict ? (long)sizeBytes : 1L;
        while ((available = this.availableMemory.get()) >= threshold && !(success = this.availableMemory.compareAndSet(available, available - (long)sizeBytes))) {
        }
        if (!success) {
            if (this.oomTimeSensor != null) {
                this.startOfNoMemPeriod.compareAndSet(0L, System.nanoTime());
            }
            this.log.trace("refused to allocate buffer of size {}", (Object)sizeBytes);
            return null;
        }
        this.maybeRecordEndOfDrySpell();
        ByteBuffer allocated = ByteBuffer.allocate(sizeBytes);
        this.bufferToBeReturned(allocated);
        return allocated;
    }

    @Override
    public void release(ByteBuffer previouslyAllocated) {
        if (previouslyAllocated == null) {
            throw new IllegalArgumentException("provided null buffer");
        }
        this.bufferToBeReleased(previouslyAllocated);
        this.availableMemory.addAndGet(previouslyAllocated.capacity());
        this.maybeRecordEndOfDrySpell();
    }

    @Override
    public long size() {
        return this.sizeBytes;
    }

    @Override
    public long availableMemory() {
        return this.availableMemory.get();
    }

    @Override
    public boolean isOutOfMemory() {
        return this.availableMemory.get() <= 0L;
    }

    protected void bufferToBeReturned(ByteBuffer justAllocated) {
        this.log.trace("allocated buffer of size {} ", (Object)justAllocated.capacity());
    }

    protected void bufferToBeReleased(ByteBuffer justReleased) {
        this.log.trace("released buffer of size {}", (Object)justReleased.capacity());
    }

    public String toString() {
        long allocated = this.sizeBytes - this.availableMemory.get();
        return "SimpleMemoryPool{" + Utils.formatBytes(allocated) + "/" + Utils.formatBytes(this.sizeBytes) + " used}";
    }

    protected void maybeRecordEndOfDrySpell() {
        long startOfDrySpell;
        if (this.oomTimeSensor != null && (startOfDrySpell = this.startOfNoMemPeriod.getAndSet(0L)) != 0L) {
            this.oomTimeSensor.record((double)(System.nanoTime() - startOfDrySpell) / 1000000.0);
        }
    }
}

