/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.PlaintextTransportLayer;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.token.delegation.DelegationTokenCache;
import org.apache.kafka.common.utils.Java;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslChannelBuilder
implements ChannelBuilder,
ListenerReconfigurable {
    private static final Logger log = LoggerFactory.getLogger(SaslChannelBuilder.class);
    private final SecurityProtocol securityProtocol;
    private final ListenerName listenerName;
    private final boolean isInterBrokerListener;
    private final String clientSaslMechanism;
    private final Mode mode;
    private final Map<String, JaasContext> jaasContexts;
    private final boolean handshakeRequestEnable;
    private final CredentialCache credentialCache;
    private final DelegationTokenCache tokenCache;
    private final Map<String, LoginManager> loginManagers;
    private final Map<String, Subject> subjects;
    private SslFactory sslFactory;
    private Map<String, ?> configs;
    private KerberosShortNamer kerberosShortNamer;

    public SaslChannelBuilder(Mode mode, Map<String, JaasContext> jaasContexts, SecurityProtocol securityProtocol2, ListenerName listenerName, boolean isInterBrokerListener, String clientSaslMechanism, boolean handshakeRequestEnable, CredentialCache credentialCache, DelegationTokenCache tokenCache) {
        this.mode = mode;
        this.jaasContexts = jaasContexts;
        this.loginManagers = new HashMap<String, LoginManager>(jaasContexts.size());
        this.subjects = new HashMap<String, Subject>(jaasContexts.size());
        this.securityProtocol = securityProtocol2;
        this.listenerName = listenerName;
        this.isInterBrokerListener = isInterBrokerListener;
        this.handshakeRequestEnable = handshakeRequestEnable;
        this.clientSaslMechanism = clientSaslMechanism;
        this.credentialCache = credentialCache;
        this.tokenCache = tokenCache;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            boolean hasKerberos = this.jaasContexts.containsKey("GSSAPI");
            if (hasKerberos) {
                String defaultRealm;
                try {
                    defaultRealm = SaslChannelBuilder.defaultKerberosRealm();
                }
                catch (Exception ke) {
                    defaultRealm = "";
                }
                List principalToLocalRules = (List)configs.get("sasl.kerberos.principal.to.local.rules");
                if (principalToLocalRules != null) {
                    this.kerberosShortNamer = KerberosShortNamer.fromUnparsedRules(defaultRealm, principalToLocalRules);
                }
            }
            for (Map.Entry<String, JaasContext> entry2 : this.jaasContexts.entrySet()) {
                String mechanism = entry2.getKey();
                LoginManager loginManager = LoginManager.acquireLoginManager(entry2.getValue(), mechanism, hasKerberos, configs);
                this.loginManagers.put(mechanism, loginManager);
                this.subjects.put(mechanism, loginManager.subject());
            }
            if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
                this.sslFactory = new SslFactory(this.mode, "none", this.isInterBrokerListener);
                this.sslFactory.configure(configs);
            }
        }
        catch (Exception e) {
            this.close();
            throw new KafkaException(e);
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return this.securityProtocol == SecurityProtocol.SASL_SSL ? SslConfigs.RECONFIGURABLE_CONFIGS : Collections.emptySet();
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            this.sslFactory.validateReconfiguration(configs);
        }
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            this.sslFactory.reconfigure(configs);
        }
    }

    @Override
    public ListenerName listenerName() {
        return this.listenerName;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool) throws KafkaException {
        try {
            Authenticator authenticator;
            SocketChannel socketChannel = (SocketChannel)key.channel();
            Socket socket = socketChannel.socket();
            TransportLayer transportLayer = this.buildTransportLayer(id, key, socketChannel);
            if (this.mode == Mode.SERVER) {
                authenticator = this.buildServerAuthenticator(this.configs, id, transportLayer, this.subjects);
            } else {
                LoginManager loginManager = this.loginManagers.get(this.clientSaslMechanism);
                authenticator = this.buildClientAuthenticator(this.configs, id, socket.getInetAddress().getHostName(), loginManager.serviceName(), transportLayer, loginManager.subject());
            }
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE);
        }
        catch (Exception e) {
            log.info("Failed to create channel due to ", e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        for (LoginManager loginManager : this.loginManagers.values()) {
            loginManager.release();
        }
        this.loginManagers.clear();
    }

    private TransportLayer buildTransportLayer(String id, SelectionKey key, SocketChannel socketChannel) throws IOException {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            return SslTransportLayer.create(id, key, this.sslFactory.createSslEngine(socketChannel.socket().getInetAddress().getHostName(), socketChannel.socket().getPort()));
        }
        return new PlaintextTransportLayer(key);
    }

    protected SaslServerAuthenticator buildServerAuthenticator(Map<String, ?> configs, String id, TransportLayer transportLayer, Map<String, Subject> subjects) throws IOException {
        return new SaslServerAuthenticator(configs, id, this.jaasContexts, subjects, this.kerberosShortNamer, this.credentialCache, this.listenerName, this.securityProtocol, transportLayer, this.tokenCache);
    }

    protected SaslClientAuthenticator buildClientAuthenticator(Map<String, ?> configs, String id, String serverHost, String servicePrincipal, TransportLayer transportLayer, Subject subject) throws IOException {
        return new SaslClientAuthenticator(configs, id, subject, servicePrincipal, serverHost, this.clientSaslMechanism, this.handshakeRequestEnable, transportLayer);
    }

    Map<String, LoginManager> loginManagers() {
        return this.loginManagers;
    }

    private static String defaultKerberosRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> classRef = Java.isIbmJdk() ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method getInstanceMethod = classRef.getMethod("getInstance", new Class[0]);
        Object kerbConf = getInstanceMethod.invoke(classRef, new Object[0]);
        Method getDefaultRealmMethod = classRef.getDeclaredMethod("getDefaultRealm", new Class[0]);
        return (String)getDefaultRealmMethod.invoke(kerbConf, new Object[0]);
    }
}

