/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.ConvertedRecords;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordBatchIterator;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.RecordsProcessingStats;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class FileRecords
extends AbstractRecords
implements Closeable {
    private final boolean isSlice;
    private final int start;
    private final int end;
    private final Iterable<FileLogInputStream.FileChannelRecordBatch> batches;
    private final AtomicInteger size;
    private final FileChannel channel;
    private volatile File file;

    public FileRecords(File file, FileChannel channel, int start2, int end, boolean isSlice) throws IOException {
        this.file = file;
        this.channel = channel;
        this.start = start2;
        this.end = end;
        this.isSlice = isSlice;
        this.size = new AtomicInteger();
        if (isSlice) {
            this.size.set(end - start2);
        } else {
            int limit = Math.min((int)channel.size(), end);
            this.size.set(limit - start2);
            channel.position(limit);
        }
        this.batches = this.batchesFrom(start2);
    }

    @Override
    public int sizeInBytes() {
        return this.size.get();
    }

    public File file() {
        return this.file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public ByteBuffer readInto(ByteBuffer buffer, int position) throws IOException {
        Utils.readFully(this.channel, buffer, position + this.start);
        buffer.flip();
        return buffer;
    }

    public FileRecords read(int position, int size2) throws IOException {
        if (position < 0) {
            throw new IllegalArgumentException("Invalid position: " + position);
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("Invalid size: " + size2);
        }
        int end = this.start + position + size2;
        if (end < 0 || end >= this.start + this.sizeInBytes()) {
            end = this.start + this.sizeInBytes();
        }
        return new FileRecords(this.file, this.channel, this.start + position, end, true);
    }

    public int append(MemoryRecords records) throws IOException {
        int written = records.writeFullyTo(this.channel);
        this.size.getAndAdd(written);
        return written;
    }

    public void flush() throws IOException {
        this.channel.force(true);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.trim();
        this.channel.close();
    }

    public void closeHandlers() throws IOException {
        this.channel.close();
    }

    public boolean deleteIfExists() throws IOException {
        Utils.closeQuietly(this.channel, "FileChannel");
        return Files.deleteIfExists(this.file.toPath());
    }

    public void trim() throws IOException {
        this.truncateTo(this.sizeInBytes());
    }

    public void setFile(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTo(File f) throws IOException {
        try {
            Utils.atomicMoveWithFallback(this.file.toPath(), f.toPath());
        }
        finally {
            this.file = f;
        }
    }

    public int truncateTo(int targetSize) throws IOException {
        int originalSize = this.sizeInBytes();
        if (targetSize > originalSize || targetSize < 0) {
            throw new KafkaException("Attempt to truncate log segment to " + targetSize + " bytes failed, " + " size of this log segment is " + originalSize + " bytes.");
        }
        if (targetSize < (int)this.channel.size()) {
            this.channel.truncate(targetSize);
            this.size.set(targetSize);
        }
        return originalSize - targetSize;
    }

    @Override
    public ConvertedRecords<? extends Records> downConvert(byte toMagic, long firstOffset, Time time) {
        ConvertedRecords<MemoryRecords> convertedRecords = this.downConvert(this.batches, toMagic, firstOffset, time);
        if (convertedRecords.recordsProcessingStats().numRecordsConverted() == 0) {
            return new ConvertedRecords<FileRecords>(this, RecordsProcessingStats.EMPTY);
        }
        return convertedRecords;
    }

    @Override
    public long writeTo(GatheringByteChannel destChannel, long offset2, int length) throws IOException {
        long bytesTransferred;
        int oldSize;
        long newSize = Math.min(this.channel.size(), (long)this.end) - (long)this.start;
        if (newSize < (long)(oldSize = this.sizeInBytes())) {
            throw new KafkaException(String.format("Size of FileRecords %s has been truncated during write: old size %d, new size %d", this.file.getAbsolutePath(), oldSize, newSize));
        }
        long position = (long)this.start + offset2;
        int count2 = Math.min(length, oldSize);
        if (destChannel instanceof TransportLayer) {
            TransportLayer tl = (TransportLayer)destChannel;
            bytesTransferred = tl.transferFrom(this.channel, position, count2);
        } else {
            bytesTransferred = this.channel.transferTo(position, count2, destChannel);
        }
        return bytesTransferred;
    }

    public LogOffsetPosition searchForOffsetWithSize(long targetOffset, int startingPosition) {
        for (FileLogInputStream.FileChannelRecordBatch batch : this.batchesFrom(startingPosition)) {
            long offset2 = batch.lastOffset();
            if (offset2 < targetOffset) continue;
            return new LogOffsetPosition(offset2, batch.position(), batch.sizeInBytes());
        }
        return null;
    }

    public TimestampAndOffset searchForTimestamp(long targetTimestamp, int startingPosition, long startingOffset) {
        for (RecordBatch recordBatch : this.batchesFrom(startingPosition)) {
            if (recordBatch.maxTimestamp() < targetTimestamp) continue;
            for (Record record2 : recordBatch) {
                long timestamp2 = record2.timestamp();
                if (timestamp2 < targetTimestamp || record2.offset() < startingOffset) continue;
                return new TimestampAndOffset(timestamp2, record2.offset());
            }
        }
        return null;
    }

    public TimestampAndOffset largestTimestampAfter(int startingPosition) {
        long maxTimestamp = -1L;
        long offsetOfMaxTimestamp = -1L;
        for (RecordBatch recordBatch : this.batchesFrom(startingPosition)) {
            long timestamp2 = recordBatch.maxTimestamp();
            if (timestamp2 <= maxTimestamp) continue;
            maxTimestamp = timestamp2;
            offsetOfMaxTimestamp = recordBatch.lastOffset();
        }
        return new TimestampAndOffset(maxTimestamp, offsetOfMaxTimestamp);
    }

    public Iterable<FileLogInputStream.FileChannelRecordBatch> batches() {
        return this.batches;
    }

    private Iterable<FileLogInputStream.FileChannelRecordBatch> batchesFrom(final int start2) {
        return new Iterable<FileLogInputStream.FileChannelRecordBatch>(){

            @Override
            public Iterator<FileLogInputStream.FileChannelRecordBatch> iterator() {
                return FileRecords.this.batchIterator(start2);
            }
        };
    }

    private Iterator<FileLogInputStream.FileChannelRecordBatch> batchIterator(int start2) {
        int end = this.isSlice ? this.end : this.sizeInBytes();
        FileLogInputStream inputStream = new FileLogInputStream(this.channel, start2, end);
        return new RecordBatchIterator<FileLogInputStream.FileChannelRecordBatch>(inputStream);
    }

    public static FileRecords open(File file, boolean mutable, boolean fileAlreadyExists, int initFileSize, boolean preallocate) throws IOException {
        FileChannel channel = FileRecords.openChannel(file, mutable, fileAlreadyExists, initFileSize, preallocate);
        int end = !fileAlreadyExists && preallocate ? 0 : Integer.MAX_VALUE;
        return new FileRecords(file, channel, 0, end, false);
    }

    public static FileRecords open(File file, boolean fileAlreadyExists, int initFileSize, boolean preallocate) throws IOException {
        return FileRecords.open(file, true, fileAlreadyExists, initFileSize, preallocate);
    }

    public static FileRecords open(File file, boolean mutable) throws IOException {
        return FileRecords.open(file, mutable, false, 0, false);
    }

    public static FileRecords open(File file) throws IOException {
        return FileRecords.open(file, true);
    }

    private static FileChannel openChannel(File file, boolean mutable, boolean fileAlreadyExists, int initFileSize, boolean preallocate) throws IOException {
        if (mutable) {
            if (fileAlreadyExists) {
                return new RandomAccessFile(file, "rw").getChannel();
            }
            if (preallocate) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.setLength(initFileSize);
                return randomAccessFile.getChannel();
            }
            return new RandomAccessFile(file, "rw").getChannel();
        }
        return new FileInputStream(file).getChannel();
    }

    public static class TimestampAndOffset {
        public final long timestamp;
        public final long offset;

        public TimestampAndOffset(long timestamp2, long offset2) {
            this.timestamp = timestamp2;
            this.offset = offset2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampAndOffset that = (TimestampAndOffset)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            return this.offset == that.offset;
        }

        public int hashCode() {
            int result2 = (int)(this.timestamp ^ this.timestamp >>> 32);
            result2 = 31 * result2 + (int)(this.offset ^ this.offset >>> 32);
            return result2;
        }

        public String toString() {
            return "TimestampAndOffset(timestamp=" + this.timestamp + ", offset=" + this.offset + ')';
        }
    }

    public static class LogOffsetPosition {
        public final long offset;
        public final int position;
        public final int size;

        public LogOffsetPosition(long offset2, int position, int size2) {
            this.offset = offset2;
            this.position = position;
            this.size = size2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogOffsetPosition that = (LogOffsetPosition)o;
            return this.offset == that.offset && this.position == that.position && this.size == that.size;
        }

        public int hashCode() {
            int result2 = (int)(this.offset ^ this.offset >>> 32);
            result2 = 31 * result2 + this.position;
            result2 = 31 * result2 + this.size;
            return result2;
        }

        public String toString() {
            return "LogOffsetPosition(offset=" + this.offset + ", position=" + this.position + ", size=" + this.size + ')';
        }
    }
}

