/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.Resource;

public class DescribeAclsResponse
extends AbstractResponse {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String ACLS_KEY_NAME = "acls";
    private static final Schema DESCRIBE_ACLS_RESOURCE = new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME, new Field("acls", new ArrayOf(new Schema(CommonFields.PRINCIPAL, CommonFields.HOST, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE))));
    private static final Schema DESCRIBE_ACLS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("resources", new ArrayOf(DESCRIBE_ACLS_RESOURCE), "The resources and their associated ACLs."));
    private final int throttleTimeMs;
    private final ApiError error;
    private final Collection<AclBinding> acls;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_ACLS_RESPONSE_V0};
    }

    public DescribeAclsResponse(int throttleTimeMs, ApiError error, Collection<AclBinding> acls) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.acls = acls;
    }

    public DescribeAclsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.error = new ApiError(struct);
        this.acls = new ArrayList<AclBinding>();
        for (Object resourceStructObj : struct.getArray(RESOURCES_KEY_NAME)) {
            Struct resourceStruct = (Struct)resourceStructObj;
            Resource resource = RequestUtils.resourceFromStructFields(resourceStruct);
            for (Object aclDataStructObj : resourceStruct.getArray(ACLS_KEY_NAME)) {
                Struct aclDataStruct = (Struct)aclDataStructObj;
                AccessControlEntry entry2 = RequestUtils.aceFromStructFields(aclDataStruct);
                this.acls.add(new AclBinding(resource, entry2));
            }
        }
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_ACLS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        this.error.write(struct);
        HashMap<Resource, ArrayList<AccessControlEntry>> resourceToData = new HashMap<Resource, ArrayList<AccessControlEntry>>();
        for (AclBinding acl : this.acls) {
            ArrayList<AccessControlEntry> entry2 = (ArrayList<AccessControlEntry>)resourceToData.get(acl.resource());
            if (entry2 == null) {
                entry2 = new ArrayList<AccessControlEntry>();
                resourceToData.put(acl.resource(), entry2);
            }
            entry2.add(acl.entry());
        }
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>();
        for (Map.Entry tuple : resourceToData.entrySet()) {
            Resource resource = (Resource)tuple.getKey();
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            RequestUtils.resourceSetStructFields(resource, resourceStruct);
            ArrayList<Struct> dataStructs = new ArrayList<Struct>();
            for (AccessControlEntry entry3 : (List)tuple.getValue()) {
                Struct dataStruct = resourceStruct.instance(ACLS_KEY_NAME);
                RequestUtils.aceSetStructFields(entry3, dataStruct);
                dataStructs.add(dataStruct);
            }
            resourceStruct.set(ACLS_KEY_NAME, (Object)dataStructs.toArray());
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public ApiError error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error.error());
    }

    public Collection<AclBinding> acls() {
        return this.acls;
    }

    public static DescribeAclsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeAclsResponse(ApiKeys.DESCRIBE_ACLS.responseSchema(version).read(buffer));
    }
}

