/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.utils.Utils;

public class FetchRequest
extends AbstractRequest {
    public static final int CONSUMER_REPLICA_ID = -1;
    private static final String REPLICA_ID_KEY_NAME = "replica_id";
    private static final String MAX_WAIT_KEY_NAME = "max_wait_time";
    private static final String MIN_BYTES_KEY_NAME = "min_bytes";
    private static final String ISOLATION_LEVEL_KEY_NAME = "isolation_level";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String FORGOTTEN_TOPICS_DATA = "forgetten_topics_data";
    private static final String MAX_BYTES_KEY_NAME = "max_bytes";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String FETCH_OFFSET_KEY_NAME = "fetch_offset";
    private static final String LOG_START_OFFSET_KEY_NAME = "log_start_offset";
    private static final Schema FETCH_REQUEST_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, new Field("fetch_offset", Type.INT64, "Message offset."), new Field("max_bytes", Type.INT32, "Maximum bytes to fetch."));
    private static final Schema FETCH_REQUEST_PARTITION_V5 = new Schema(CommonFields.PARTITION_ID, new Field("fetch_offset", Type.INT64, "Message offset."), new Field("log_start_offset", Type.INT64, "Earliest available offset of the follower replica. The field is only used when request is sent by follower. "), new Field("max_bytes", Type.INT32, "Maximum bytes to fetch."));
    private static final Schema FETCH_REQUEST_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(FETCH_REQUEST_PARTITION_V0), "Partitions to fetch."));
    private static final Schema FETCH_REQUEST_TOPIC_V5 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(FETCH_REQUEST_PARTITION_V5), "Partitions to fetch."));
    private static final Schema FETCH_REQUEST_V0;
    private static final Schema FETCH_REQUEST_V1;
    private static final Schema FETCH_REQUEST_V2;
    private static final Schema FETCH_REQUEST_V3;
    private static final Schema FETCH_REQUEST_V4;
    private static final Schema FETCH_REQUEST_V5;
    private static final Schema FETCH_REQUEST_V6;
    public static final Field.Int32 SESSION_ID;
    public static final Field.Int32 EPOCH;
    private static final Schema FORGOTTEN_TOPIC_DATA;
    private static final Schema FETCH_REQUEST_V7;
    public static final int DEFAULT_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    private final int replicaId;
    private final int maxWait;
    private final int minBytes;
    private final int maxBytes;
    private final IsolationLevel isolationLevel;
    private final Map<TopicPartition, PartitionData> fetchData;
    private final List<TopicPartition> toForget;
    private final FetchMetadata metadata;

    public static Schema[] schemaVersions() {
        return new Schema[]{FETCH_REQUEST_V0, FETCH_REQUEST_V1, FETCH_REQUEST_V2, FETCH_REQUEST_V3, FETCH_REQUEST_V4, FETCH_REQUEST_V5, FETCH_REQUEST_V6, FETCH_REQUEST_V7};
    }

    private FetchRequest(short version, int replicaId, int maxWait, int minBytes, int maxBytes, Map<TopicPartition, PartitionData> fetchData2, IsolationLevel isolationLevel, List<TopicPartition> toForget, FetchMetadata metadata) {
        super(version);
        this.replicaId = replicaId;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.fetchData = fetchData2;
        this.isolationLevel = isolationLevel;
        this.toForget = toForget;
        this.metadata = metadata;
    }

    public FetchRequest(Struct struct, short version) {
        super(version);
        this.replicaId = struct.getInt(REPLICA_ID_KEY_NAME);
        this.maxWait = struct.getInt(MAX_WAIT_KEY_NAME);
        this.minBytes = struct.getInt(MIN_BYTES_KEY_NAME);
        this.maxBytes = struct.hasField(MAX_BYTES_KEY_NAME) ? struct.getInt(MAX_BYTES_KEY_NAME) : Integer.MAX_VALUE;
        this.isolationLevel = struct.hasField(ISOLATION_LEVEL_KEY_NAME) ? IsolationLevel.forId(struct.getByte(ISOLATION_LEVEL_KEY_NAME)) : IsolationLevel.READ_UNCOMMITTED;
        this.toForget = new ArrayList<TopicPartition>(0);
        if (struct.hasField(FORGOTTEN_TOPICS_DATA)) {
            for (Object forgottenTopicObj : struct.getArray(FORGOTTEN_TOPICS_DATA)) {
                Struct forgottenTopic = (Struct)forgottenTopicObj;
                String topicName = forgottenTopic.get(CommonFields.TOPIC_NAME);
                for (Object partObj : forgottenTopic.getArray(PARTITIONS_KEY_NAME)) {
                    Integer part = (Integer)partObj;
                    this.toForget.add(new TopicPartition(topicName, part));
                }
            }
        }
        this.metadata = new FetchMetadata(struct.getOrElse(SESSION_ID, 0), struct.getOrElse(EPOCH, -1));
        this.fetchData = new LinkedHashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.get(CommonFields.PARTITION_ID);
                long offset2 = partitionResponse.getLong(FETCH_OFFSET_KEY_NAME);
                int maxBytes = partitionResponse.getInt(MAX_BYTES_KEY_NAME);
                long logStartOffset2 = partitionResponse.hasField(LOG_START_OFFSET_KEY_NAME) ? partitionResponse.getLong(LOG_START_OFFSET_KEY_NAME) : -1L;
                PartitionData partitionData = new PartitionData(offset2, logStartOffset2, maxBytes);
                this.fetchData.put(new TopicPartition(topic, partition2), partitionData);
            }
        }
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, PartitionData> entry2 : this.fetchData.entrySet()) {
            FetchResponse.PartitionData partitionResponse = new FetchResponse.PartitionData(error, -1L, -1L, -1L, null, MemoryRecords.EMPTY);
            responseData.put(entry2.getKey(), partitionResponse);
        }
        return new FetchResponse(error, responseData, throttleTimeMs, this.metadata.sessionId());
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public Map<TopicPartition, PartitionData> fetchData() {
        return this.fetchData;
    }

    public List<TopicPartition> toForget() {
        return this.toForget;
    }

    public boolean isFromFollower() {
        return this.replicaId >= 0;
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel;
    }

    public FetchMetadata metadata() {
        return this.metadata;
    }

    public static FetchRequest parse(ByteBuffer buffer, short version) {
        return new FetchRequest(ApiKeys.FETCH.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.FETCH.requestSchema(this.version()));
        List topicsData = TopicAndPartitionData.batchByTopic(this.fetchData.entrySet().iterator());
        struct.set(REPLICA_ID_KEY_NAME, (Object)this.replicaId);
        struct.set(MAX_WAIT_KEY_NAME, (Object)this.maxWait);
        struct.set(MIN_BYTES_KEY_NAME, (Object)this.minBytes);
        if (struct.hasField(MAX_BYTES_KEY_NAME)) {
            struct.set(MAX_BYTES_KEY_NAME, (Object)this.maxBytes);
        }
        if (struct.hasField(ISOLATION_LEVEL_KEY_NAME)) {
            struct.set(ISOLATION_LEVEL_KEY_NAME, (Object)this.isolationLevel.id());
        }
        struct.setIfExists(SESSION_ID, (Object)this.metadata.sessionId());
        struct.setIfExists(EPOCH, (Object)this.metadata.epoch());
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (TopicAndPartitionData topicEntry : topicsData) {
            Struct topicData = struct.instance(TOPICS_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicEntry.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(FETCH_OFFSET_KEY_NAME, (Object)fetchPartitionData.fetchOffset);
                if (partitionData.hasField(LOG_START_OFFSET_KEY_NAME)) {
                    partitionData.set(LOG_START_OFFSET_KEY_NAME, (Object)fetchPartitionData.logStartOffset);
                }
                partitionData.set(MAX_BYTES_KEY_NAME, (Object)fetchPartitionData.maxBytes);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        if (struct.hasField(FORGOTTEN_TOPICS_DATA)) {
            HashMap<String, ArrayList<Integer>> topicsToPartitions = new HashMap<String, ArrayList<Integer>>();
            for (TopicPartition part : this.toForget) {
                ArrayList<Integer> partitions2 = (ArrayList<Integer>)topicsToPartitions.get(part.topic());
                if (partitions2 == null) {
                    partitions2 = new ArrayList<Integer>();
                    topicsToPartitions.put(part.topic(), partitions2);
                }
                partitions2.add(part.partition());
            }
            ArrayList<Struct> toForgetStructs = new ArrayList<Struct>();
            for (Map.Entry entry2 : topicsToPartitions.entrySet()) {
                Struct toForgetStruct = struct.instance(FORGOTTEN_TOPICS_DATA);
                toForgetStruct.set(CommonFields.TOPIC_NAME, (String)entry2.getKey());
                toForgetStruct.set(PARTITIONS_KEY_NAME, (Object)((List)entry2.getValue()).toArray());
                toForgetStructs.add(toForgetStruct);
            }
            struct.set(FORGOTTEN_TOPICS_DATA, (Object)toForgetStructs.toArray());
        }
        return struct;
    }

    static {
        FETCH_REQUEST_V2 = FETCH_REQUEST_V1 = (FETCH_REQUEST_V0 = new Schema(new Field(REPLICA_ID_KEY_NAME, Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field(MAX_WAIT_KEY_NAME, Type.INT32, "Maximum time in ms to wait for the response."), new Field(MIN_BYTES_KEY_NAME, Type.INT32, "Minimum bytes to accumulate in the response."), new Field(TOPICS_KEY_NAME, new ArrayOf(FETCH_REQUEST_TOPIC_V0), "Topics to fetch.")));
        FETCH_REQUEST_V3 = new Schema(new Field(REPLICA_ID_KEY_NAME, Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field(MAX_WAIT_KEY_NAME, Type.INT32, "Maximum time in ms to wait for the response."), new Field(MIN_BYTES_KEY_NAME, Type.INT32, "Minimum bytes to accumulate in the response."), new Field(MAX_BYTES_KEY_NAME, Type.INT32, "Maximum bytes to accumulate in the response. Note that this is not an absolute maximum, if the first message in the first non-empty partition of the fetch is larger than this value, the message will still be returned to ensure that progress can be made."), new Field(TOPICS_KEY_NAME, new ArrayOf(FETCH_REQUEST_TOPIC_V0), "Topics to fetch in the order provided."));
        FETCH_REQUEST_V4 = new Schema(new Field(REPLICA_ID_KEY_NAME, Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field(MAX_WAIT_KEY_NAME, Type.INT32, "Maximum time in ms to wait for the response."), new Field(MIN_BYTES_KEY_NAME, Type.INT32, "Minimum bytes to accumulate in the response."), new Field(MAX_BYTES_KEY_NAME, Type.INT32, "Maximum bytes to accumulate in the response. Note that this is not an absolute maximum, if the first message in the first non-empty partition of the fetch is larger than this value, the message will still be returned to ensure that progress can be made."), new Field(ISOLATION_LEVEL_KEY_NAME, Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field(TOPICS_KEY_NAME, new ArrayOf(FETCH_REQUEST_TOPIC_V0), "Topics to fetch in the order provided."));
        FETCH_REQUEST_V6 = FETCH_REQUEST_V5 = new Schema(new Field(REPLICA_ID_KEY_NAME, Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field(MAX_WAIT_KEY_NAME, Type.INT32, "Maximum time in ms to wait for the response."), new Field(MIN_BYTES_KEY_NAME, Type.INT32, "Minimum bytes to accumulate in the response."), new Field(MAX_BYTES_KEY_NAME, Type.INT32, "Maximum bytes to accumulate in the response. Note that this is not an absolute maximum, if the first message in the first non-empty partition of the fetch is larger than this value, the message will still be returned to ensure that progress can be made."), new Field(ISOLATION_LEVEL_KEY_NAME, Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field(TOPICS_KEY_NAME, new ArrayOf(FETCH_REQUEST_TOPIC_V5), "Topics to fetch in the order provided."));
        SESSION_ID = new Field.Int32("session_id", "The fetch session ID");
        EPOCH = new Field.Int32("epoch", "The fetch epoch");
        FORGOTTEN_TOPIC_DATA = new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(Type.INT32), "Partitions to remove from the fetch session."));
        FETCH_REQUEST_V7 = new Schema(new Field(REPLICA_ID_KEY_NAME, Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field(MAX_WAIT_KEY_NAME, Type.INT32, "Maximum time in ms to wait for the response."), new Field(MIN_BYTES_KEY_NAME, Type.INT32, "Minimum bytes to accumulate in the response."), new Field(MAX_BYTES_KEY_NAME, Type.INT32, "Maximum bytes to accumulate in the response. Note that this is not an absolute maximum, if the first message in the first non-empty partition of the fetch is larger than this value, the message will still be returned to ensure that progress can be made."), new Field(ISOLATION_LEVEL_KEY_NAME, Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), SESSION_ID, EPOCH, new Field(TOPICS_KEY_NAME, new ArrayOf(FETCH_REQUEST_TOPIC_V5), "Topics to fetch in the order provided."), new Field(FORGOTTEN_TOPICS_DATA, new ArrayOf(FORGOTTEN_TOPIC_DATA), "Topics to remove from the fetch session."));
    }

    public static class Builder
    extends AbstractRequest.Builder<FetchRequest> {
        private final int maxWait;
        private final int minBytes;
        private final int replicaId;
        private final Map<TopicPartition, PartitionData> fetchData;
        private IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        private int maxBytes = Integer.MAX_VALUE;
        private FetchMetadata metadata = FetchMetadata.LEGACY;
        private List<TopicPartition> toForget = Collections.emptyList();

        public static Builder forConsumer(int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData2) {
            return new Builder(ApiKeys.FETCH.oldestVersion(), ApiKeys.FETCH.latestVersion(), -1, maxWait, minBytes, fetchData2);
        }

        public static Builder forReplica(short allowedVersion, int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData2) {
            return new Builder(allowedVersion, allowedVersion, replicaId, maxWait, minBytes, fetchData2);
        }

        public Builder(short minVersion, short maxVersion, int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData2) {
            super(ApiKeys.FETCH, minVersion, maxVersion);
            this.replicaId = replicaId;
            this.maxWait = maxWait;
            this.minBytes = minBytes;
            this.fetchData = fetchData2;
        }

        public Builder isolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
            return this;
        }

        public Builder metadata(FetchMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Map<TopicPartition, PartitionData> fetchData() {
            return this.fetchData;
        }

        public Builder setMaxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public List<TopicPartition> toForget() {
            return this.toForget;
        }

        public Builder toForget(List<TopicPartition> toForget) {
            this.toForget = toForget;
            return this;
        }

        @Override
        public FetchRequest build(short version) {
            if (version < 3) {
                this.maxBytes = Integer.MAX_VALUE;
            }
            return new FetchRequest(version, this.replicaId, this.maxWait, this.minBytes, this.maxBytes, this.fetchData, this.isolationLevel, this.toForget, this.metadata);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=FetchRequest").append(", replicaId=").append(this.replicaId).append(", maxWait=").append(this.maxWait).append(", minBytes=").append(this.minBytes).append(", maxBytes=").append(this.maxBytes).append(", fetchData=").append(this.fetchData).append(", isolationLevel=").append((Object)this.isolationLevel).append(", toForget=").append(Utils.join(this.toForget, ", ")).append(", metadata=").append(this.metadata).append(")");
            return bld.toString();
        }
    }

    static final class TopicAndPartitionData<T> {
        public final String topic;
        public final LinkedHashMap<Integer, T> partitions;

        public TopicAndPartitionData(String topic) {
            this.topic = topic;
            this.partitions = new LinkedHashMap();
        }

        public static <T> List<TopicAndPartitionData<T>> batchByTopic(Iterator<Map.Entry<TopicPartition, T>> iter2) {
            ArrayList<TopicAndPartitionData<T>> topics = new ArrayList<TopicAndPartitionData<T>>();
            while (iter2.hasNext()) {
                Map.Entry<TopicPartition, T> topicEntry = iter2.next();
                String topic = topicEntry.getKey().topic();
                int partition2 = topicEntry.getKey().partition();
                T partitionData = topicEntry.getValue();
                if (topics.isEmpty() || !((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).topic.equals(topic)) {
                    topics.add(new TopicAndPartitionData<T>(topic));
                }
                ((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).partitions.put(partition2, partitionData);
            }
            return topics;
        }
    }

    public static final class PartitionData {
        public final long fetchOffset;
        public final long logStartOffset;
        public final int maxBytes;

        public PartitionData(long fetchOffset, long logStartOffset2, int maxBytes) {
            this.fetchOffset = fetchOffset;
            this.logStartOffset = logStartOffset2;
            this.maxBytes = maxBytes;
        }

        public String toString() {
            return "(offset=" + this.fetchOffset + ", logStartOffset=" + this.logStartOffset + ", maxBytes=" + this.maxBytes + ")";
        }

        public int hashCode() {
            return Objects.hash(this.fetchOffset, this.logStartOffset, this.maxBytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return Objects.equals(this.fetchOffset, that.fetchOffset) && Objects.equals(this.logStartOffset, that.logStartOffset) && Objects.equals(this.maxBytes, that.maxBytes);
        }
    }
}

