/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.apache.kafka.common.utils.Java;

public final class Base64 {
    private static final Factory FACTORY = Java.IS_JAVA8_COMPATIBLE ? new Java8Factory() : new Java7Factory();

    private Base64() {
    }

    public static Encoder encoder() {
        return FACTORY.encoder();
    }

    public static Encoder urlEncoderNoPadding() {
        return FACTORY.urlEncoderNoPadding();
    }

    public static Decoder decoder() {
        return FACTORY.decoder();
    }

    public static Decoder urlDecoder() {
        return FACTORY.urlDecoder();
    }

    private static class Java7Factory
    implements Factory {
        private static final MethodHandle PRINT;
        private static final MethodHandle PARSE;
        public static final Encoder URL_ENCODER_NO_PADDING;
        public static final Encoder ENCODER;
        public static final Decoder DECODER;
        public static final Decoder URL_DECODER;

        private Java7Factory() {
        }

        private static String encodeToString(byte[] bytes2) {
            try {
                return PRINT.invokeExact(bytes2);
            }
            catch (Throwable throwable) {
                throw (RuntimeException)throwable;
            }
        }

        @Override
        public Encoder urlEncoderNoPadding() {
            return URL_ENCODER_NO_PADDING;
        }

        @Override
        public Encoder encoder() {
            return ENCODER;
        }

        @Override
        public Decoder urlDecoder() {
            return URL_DECODER;
        }

        @Override
        public Decoder decoder() {
            return DECODER;
        }

        static {
            try {
                Class<?> cls = Class.forName("javax.xml.bind.DatatypeConverter");
                MethodHandles.Lookup lookup2 = MethodHandles.publicLookup();
                PRINT = lookup2.findStatic(cls, "printBase64Binary", MethodType.methodType(String.class, byte[].class));
                PARSE = lookup2.findStatic(cls, "parseBase64Binary", MethodType.methodType(byte[].class, String.class));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            URL_ENCODER_NO_PADDING = new Encoder(){

                @Override
                public String encodeToString(byte[] bytes2) {
                    if (bytes2.length == 0) {
                        return "";
                    }
                    String base64EncodedUUID = Java7Factory.encodeToString(bytes2);
                    String urlSafeBase64EncodedUUID = base64EncodedUUID.replace("+", "-").replace("/", "_");
                    int index = urlSafeBase64EncodedUUID.indexOf(61, urlSafeBase64EncodedUUID.length() - 2);
                    return index > 0 ? urlSafeBase64EncodedUUID.substring(0, index) : urlSafeBase64EncodedUUID;
                }
            };
            ENCODER = new Encoder(){

                @Override
                public String encodeToString(byte[] bytes2) {
                    return Java7Factory.encodeToString(bytes2);
                }
            };
            DECODER = new Decoder(){

                @Override
                public byte[] decode(String string2) {
                    try {
                        return PARSE.invokeExact(string2);
                    }
                    catch (Throwable throwable) {
                        throw (RuntimeException)throwable;
                    }
                }
            };
            URL_DECODER = new Decoder(){

                @Override
                public byte[] decode(String string2) {
                    try {
                        String unpadded = string2.replace("-", "+").replace("_", "/");
                        int padLength = 4 - (unpadded.length() & 3);
                        return PARSE.invokeExact(padLength > 2 ? unpadded : unpadded + "==".substring(0, padLength));
                    }
                    catch (Throwable throwable) {
                        throw (RuntimeException)throwable;
                    }
                }
            };
        }
    }

    private static class Java8Factory
    implements Factory {
        private static final MethodHandle URL_ENCODE_NO_PADDING;
        private static final MethodHandle ENCODE;
        private static final MethodHandle URL_DECODE;
        private static final MethodHandle DECODE;
        private static final Encoder URL_ENCODER_NO_PADDING;
        private static final Encoder ENCODER;
        private static final Decoder URL_DECODER;
        private static final Decoder DECODER;

        private Java8Factory() {
        }

        @Override
        public Encoder urlEncoderNoPadding() {
            return URL_ENCODER_NO_PADDING;
        }

        @Override
        public Encoder encoder() {
            return ENCODER;
        }

        @Override
        public Decoder decoder() {
            return DECODER;
        }

        @Override
        public Decoder urlDecoder() {
            return URL_DECODER;
        }

        static {
            try {
                Object juUrlEncoderNoPassing;
                Object juEncoder;
                Class<?> base64Class = Class.forName("java.util.Base64");
                MethodHandles.Lookup lookup2 = MethodHandles.publicLookup();
                Class<?> juEncoderClass = Class.forName("java.util.Base64$Encoder");
                MethodHandle getEncoder = lookup2.findStatic(base64Class, "getEncoder", MethodType.methodType(juEncoderClass));
                try {
                    juEncoder = getEncoder.invoke();
                }
                catch (Throwable throwable) {
                    throw (RuntimeException)throwable;
                }
                MethodHandle encode2 = lookup2.findVirtual(juEncoderClass, "encodeToString", MethodType.methodType(String.class, byte[].class));
                ENCODE = encode2.bindTo(juEncoder);
                MethodHandle getUrlEncoder = lookup2.findStatic(base64Class, "getUrlEncoder", MethodType.methodType(juEncoderClass));
                try {
                    juUrlEncoderNoPassing = lookup2.findVirtual(juEncoderClass, "withoutPadding", MethodType.methodType(juEncoderClass)).invoke(getUrlEncoder.invoke());
                }
                catch (Throwable throwable) {
                    throw (RuntimeException)throwable;
                }
                URL_ENCODE_NO_PADDING = encode2.bindTo(juUrlEncoderNoPassing);
                Class<?> juDecoderClass = Class.forName("java.util.Base64$Decoder");
                MethodHandle getDecoder = lookup2.findStatic(base64Class, "getDecoder", MethodType.methodType(juDecoderClass));
                MethodHandle decode2 = lookup2.findVirtual(juDecoderClass, "decode", MethodType.methodType(byte[].class, String.class));
                try {
                    DECODE = decode2.bindTo(getDecoder.invoke());
                }
                catch (Throwable throwable) {
                    throw (RuntimeException)throwable;
                }
                MethodHandle getUrlDecoder = lookup2.findStatic(base64Class, "getUrlDecoder", MethodType.methodType(juDecoderClass));
                MethodHandle urlDecode = lookup2.findVirtual(juDecoderClass, "decode", MethodType.methodType(byte[].class, String.class));
                try {
                    URL_DECODE = urlDecode.bindTo(getUrlDecoder.invoke());
                }
                catch (Throwable throwable) {
                    throw (RuntimeException)throwable;
                }
                URL_ENCODER_NO_PADDING = new Encoder(){

                    @Override
                    public String encodeToString(byte[] bytes2) {
                        try {
                            return URL_ENCODE_NO_PADDING.invokeExact(bytes2);
                        }
                        catch (Throwable throwable) {
                            throw (RuntimeException)throwable;
                        }
                    }
                };
                ENCODER = new Encoder(){

                    @Override
                    public String encodeToString(byte[] bytes2) {
                        try {
                            return ENCODE.invokeExact(bytes2);
                        }
                        catch (Throwable throwable) {
                            throw (RuntimeException)throwable;
                        }
                    }
                };
                URL_DECODER = new Decoder(){

                    @Override
                    public byte[] decode(String string2) {
                        try {
                            return URL_DECODE.invokeExact(string2);
                        }
                        catch (Throwable throwable) {
                            throw (RuntimeException)throwable;
                        }
                    }
                };
                DECODER = new Decoder(){

                    @Override
                    public byte[] decode(String string2) {
                        try {
                            return DECODE.invokeExact(string2);
                        }
                        catch (Throwable throwable) {
                            throw (RuntimeException)throwable;
                        }
                    }
                };
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface Factory {
        public Encoder urlEncoderNoPadding();

        public Encoder encoder();

        public Decoder urlDecoder();

        public Decoder decoder();
    }

    public static interface Decoder {
        public byte[] decode(String var1);
    }

    public static interface Encoder {
        public String encodeToString(byte[] var1);
    }
}

