/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Map<String, Map<Integer, T>> groupDataByTopic(Map<TopicPartition, ? extends T> data) {
        HashMap<String, Map<Integer, T>> dataByTopic = new HashMap<String, Map<Integer, T>>();
        for (Map.Entry<TopicPartition, T> entry2 : data.entrySet()) {
            String topic = entry2.getKey().topic();
            int partition2 = entry2.getKey().partition();
            HashMap<Integer, T> topicData = (HashMap<Integer, T>)dataByTopic.get(topic);
            if (topicData == null) {
                topicData = new HashMap<Integer, T>();
                dataByTopic.put(topic, topicData);
            }
            topicData.put(partition2, entry2.getValue());
        }
        return dataByTopic;
    }

    public static Map<String, List<Integer>> groupDataByTopic(List<TopicPartition> partitions2) {
        HashMap<String, List<Integer>> partitionsByTopic = new HashMap<String, List<Integer>>();
        for (TopicPartition tp : partitions2) {
            String topic = tp.topic();
            ArrayList<Integer> topicData = (ArrayList<Integer>)partitionsByTopic.get(topic);
            if (topicData == null) {
                topicData = new ArrayList<Integer>();
                partitionsByTopic.put(topic, topicData);
            }
            topicData.add(tp.partition());
        }
        return partitionsByTopic;
    }
}

