/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class KafkaDataConsumer$
implements Logging {
    public static final KafkaDataConsumer$ MODULE$;
    private LinkedHashMap<KafkaDataConsumer.CacheKey, InternalKafkaConsumer> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new KafkaDataConsumer$();
    }

    private LinkedHashMap cache$lzycompute() {
        KafkaDataConsumer$ kafkaDataConsumer$ = this;
        synchronized (kafkaDataConsumer$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt("spark.sql.kafkaConsumerCache.capacity", 64);
                this.cache = new LinkedHashMap<KafkaDataConsumer.CacheKey, InternalKafkaConsumer>(capacity){
                    public final int capacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<KafkaDataConsumer.CacheKey, InternalKafkaConsumer> entry2) {
                        if (entry2.getValue().inUse()) return false;
                        if (this.size() <= this.capacity$1) return false;
                        KafkaDataConsumer$.MODULE$.logWarning((Function0<String>)((Object)new Serializable(this, entry2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Map.Entry entry$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaConsumer cache hitting max capacity of ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.capacity$1)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.entry$1.getKey()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        }));
                        try {
                            entry2.getValue().close();
                            return true;
                        }
                        catch (SparkException sparkException) {
                            KafkaDataConsumer$.MODULE$.logError((Function0<String>)((Object)new Serializable(this, entry2){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing earliest Kafka consumer for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }), sparkException);
                        }
                        return true;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }
                };
                this.bitmap$0 = true;
            }
            return this.cache;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private LinkedHashMap<KafkaDataConsumer.CacheKey, InternalKafkaConsumer> cache() {
        return this.bitmap$0 ? this.cache : this.cache$lzycompute();
    }

    public synchronized KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> kafkaParams, boolean useCache) {
        Serializable serializable;
        ObjectRef<Object> newInternalConsumer$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        KafkaDataConsumer.CacheKey key = new KafkaDataConsumer.CacheKey(topicPartition, kafkaParams);
        InternalKafkaConsumer existingInternalConsumer = this.cache().get(key);
        if (TaskContext$.MODULE$.get() != null && TaskContext$.MODULE$.get().attemptNumber() >= 1) {
            if (existingInternalConsumer != null) {
                if (existingInternalConsumer.inUse()) {
                    existingInternalConsumer.markedForClose_$eq(true);
                } else {
                    existingInternalConsumer.close();
                }
            }
            this.cache().remove(key);
            serializable = new KafkaDataConsumer.NonCachedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
        } else if (useCache) {
            if (existingInternalConsumer == null) {
                this.cache().put(key, this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
                this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0).inUse_$eq(true);
                serializable = new KafkaDataConsumer.CachedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
            } else if (existingInternalConsumer.inUse()) {
                serializable = new KafkaDataConsumer.NonCachedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
            } else {
                existingInternalConsumer.inUse_$eq(true);
                serializable = new KafkaDataConsumer.CachedKafkaDataConsumer(existingInternalConsumer);
            }
        } else {
            serializable = new KafkaDataConsumer.NonCachedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
        }
        return serializable;
    }

    public void org$apache$spark$sql$kafka010$KafkaDataConsumer$$release(InternalKafkaConsumer intConsumer) {
        KafkaDataConsumer$ kafkaDataConsumer$ = this;
        synchronized (kafkaDataConsumer$) {
            BoxedUnit boxedUnit;
            KafkaDataConsumer.CacheKey key = new KafkaDataConsumer.CacheKey(intConsumer.topicPartition(), intConsumer.kafkaParams());
            InternalKafkaConsumer cachedIntConsumer = this.cache().get(key);
            if (intConsumer == cachedIntConsumer) {
                if (intConsumer.markedForClose()) {
                    intConsumer.close();
                    boxedUnit = this.cache().remove(key);
                } else {
                    intConsumer.inUse_$eq(false);
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                intConsumer.close();
                this.logInfo((Function0<String>)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Released a supposedly cached consumer that was not found in the cache"})).s(Nil$.MODULE$);
                    }
                }));
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final InternalKafkaConsumer newInternalConsumer$lzycompute$1(TopicPartition topicPartition$1, Map kafkaParams$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        KafkaDataConsumer$ kafkaDataConsumer$ = this;
        synchronized (kafkaDataConsumer$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                newInternalConsumer$lzy$1.elem = new InternalKafkaConsumer(topicPartition$1, kafkaParams$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (InternalKafkaConsumer)newInternalConsumer$lzy$1.elem;
        }
    }

    private final InternalKafkaConsumer newInternalConsumer$1(TopicPartition topicPartition$1, Map kafkaParams$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.newInternalConsumer$lzycompute$1(topicPartition$1, kafkaParams$1, newInternalConsumer$lzy$1, bitmap$0$1) : (InternalKafkaConsumer)newInternalConsumer$lzy$1.elem;
    }

    private KafkaDataConsumer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

