/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import org.apache.kafka.common.TopicPartition;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0001\u00051\u0011!dS1gW\u0006|eMZ:fiJ\u000bgnZ3DC2\u001cW\u000f\\1u_JT!a\u0001\u0003\u0002\u0011-\fgm[11cAR!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005iQ.\u001b8QCJ$\u0018\u000e^5p]N\u001c\u0001!F\u0001\u0018!\rq\u0001DG\u0005\u00033=\u0011aa\u00149uS>t\u0007C\u0001\b\u001c\u0013\tarBA\u0002J]RD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000f[&t\u0007+\u0019:uSRLwN\\:!\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\u0011!\u0005\n\t\u0003G\u0001i\u0011A\u0001\u0005\u0006)}\u0001\ra\u0006\u0005\u0006M\u0001!\taJ\u0001\nO\u0016$(+\u00198hKN$B\u0001K\u001c@\u0003B\u0019\u0011&\r\u001b\u000f\u0005)zcBA\u0016/\u001b\u0005a#BA\u0017\u0016\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u00021\u001f\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001a4\u0005\r\u0019V-\u001d\u0006\u0003a=\u0001\"aI\u001b\n\u0005Y\u0012!\u0001E&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0011\u0015AT\u00051\u0001:\u0003-1'o\\7PM\u001a\u001cX\r^:\u0011\u0005ibdBA\u0012<\u0013\t\u0001$!\u0003\u0002>}\t\u0011\u0002+\u0019:uSRLwN\\(gMN,G/T1q\u0015\t\u0001$\u0001C\u0003AK\u0001\u0007\u0011(\u0001\u0007v]RLGn\u00144gg\u0016$8\u000fC\u0004CKA\u0005\t\u0019A\"\u0002#\u0015DXmY;u_JdunY1uS>t7\u000fE\u0002*c\u0011\u0003\"!\u0012%\u000f\u000591\u0015BA$\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d{\u0001\"\u0002'\u0001\t\u0013i\u0015aC4fi2{7-\u0019;j_:$2AT(Z!\rq\u0001\u0004\u0012\u0005\u0006!.\u0003\r!U\u0001\u0003iB\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\r\r|W.\\8o\u0015\t1\u0006\"A\u0003lC\u001a\\\u0017-\u0003\u0002Y'\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"\u0002\"L\u0001\u0004\u0019\u0005bB.\u0001#\u0003%\t\u0001X\u0001\u0014O\u0016$(+\u00198hKN$C-\u001a4bk2$HeM\u000b\u0002;*\u00121IX\u0016\u0002?B\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001Z\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002gC\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\r!\u0014\u0001\u0012\u0001\u0002j\u0003iY\u0015MZ6b\u001f\u001a47/\u001a;SC:<WmQ1mGVd\u0017\r^8s!\t\u0019#N\u0002\u0004\u0002\u0005!\u0005!a[\n\u0003U6AQ\u0001\t6\u0005\u00025$\u0012!\u001b\u0005\u0006_*$\t\u0001]\u0001\u0006CB\u0004H.\u001f\u000b\u0003EEDQA\u001d8A\u0002M\fqa\u001c9uS>t7\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006\u0011aO\r\u0006\u0003q\u0012\tqa]8ve\u000e,7/\u0003\u0002{k\n\tB)\u0019;b'>,(oY3PaRLwN\\:")
public class KafkaOffsetRangeCalculator {
    private final Option<Object> minPartitions;

    public static KafkaOffsetRangeCalculator apply(DataSourceOptions dataSourceOptions) {
        return KafkaOffsetRangeCalculator$.MODULE$.apply(dataSourceOptions);
    }

    public Option<Object> minPartitions() {
        return this.minPartitions;
    }

    public Seq<KafkaOffsetRange> getRanges(Map<TopicPartition, Object> fromOffsets, Map<TopicPartition, Object> untilOffsets, Seq<String> executorLocations) {
        Seq<KafkaOffsetRange> seq;
        Set partitionsToRead = (Set)untilOffsets.keySet().intersect(fromOffsets.keySet());
        Seq offsetRanges = (Seq)((TraversableLike)partitionsToRead.toSeq().map(new Serializable(this, fromOffsets, untilOffsets){
            public static final long serialVersionUID = 0L;
            private final Map fromOffsets$1;
            private final Map untilOffsets$1;

            public final KafkaOffsetRange apply(TopicPartition tp) {
                return new KafkaOffsetRange(tp, BoxesRunTime.unboxToLong(this.fromOffsets$1.apply(tp)), BoxesRunTime.unboxToLong(this.untilOffsets$1.apply(tp)), None$.MODULE$);
            }
            {
                this.fromOffsets$1 = fromOffsets$1;
                this.untilOffsets$1 = untilOffsets$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaOffsetRange x$1) {
                return x$1.size() > 0L;
            }
        });
        if (this.minPartitions().isEmpty() || offsetRanges.size() > BoxesRunTime.unboxToInt(this.minPartitions().get())) {
            seq = offsetRanges.map(new Serializable(this, executorLocations){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaOffsetRangeCalculator $outer;
                private final Seq executorLocations$1;

                public final KafkaOffsetRange apply(KafkaOffsetRange range2) {
                    Option<String> x$4 = this.$outer.org$apache$spark$sql$kafka010$KafkaOffsetRangeCalculator$$getLocation(range2.topicPartition(), this.executorLocations$1);
                    TopicPartition x$5 = range2.copy$default$1();
                    long x$6 = range2.copy$default$2();
                    long x$7 = range2.copy$default$3();
                    return range2.copy(x$5, x$6, x$7, x$4);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.executorLocations$1 = executorLocations$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            long totalSize = BoxesRunTime.unboxToLong(((TraversableOnce)offsetRanges.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(KafkaOffsetRange x$2) {
                    return x$2.size();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum(Numeric$LongIsIntegral$.MODULE$));
            double idealRangeSize = (double)totalSize / (double)BoxesRunTime.unboxToInt(this.minPartitions().get());
            seq = offsetRanges.flatMap(new Serializable(this, idealRangeSize){
                public static final long serialVersionUID = 0L;
                private final double idealRangeSize$1;

                public final IndexedSeq<KafkaOffsetRange> apply(KafkaOffsetRange range2) {
                    int numSplitsInRange = (int)package$.MODULE$.round((double)range2.size() / this.idealRangeSize$1);
                    return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSplitsInRange).map(new Serializable(this, numSplitsInRange, range2){
                        public static final long serialVersionUID = 0L;
                        private final int numSplitsInRange$1;
                        private final KafkaOffsetRange range$1;

                        public final KafkaOffsetRange apply(int i) {
                            double splitStart = (double)this.range$1.fromOffset() + (double)this.range$1.size() * ((double)i / (double)this.numSplitsInRange$1);
                            double splitEnd = (double)this.range$1.fromOffset() + (double)this.range$1.size() * (((double)i + 1.0) / (double)this.numSplitsInRange$1);
                            return new KafkaOffsetRange(this.range$1.topicPartition(), (long)splitStart, (long)splitEnd, None$.MODULE$);
                        }
                        {
                            this.numSplitsInRange$1 = numSplitsInRange$1;
                            this.range$1 = range$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                }
                {
                    this.idealRangeSize$1 = idealRangeSize$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public Seq<String> getRanges$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option<String> org$apache$spark$sql$kafka010$KafkaOffsetRangeCalculator$$getLocation(TopicPartition tp, Seq<String> executorLocations) {
        int numExecutors = executorLocations.length();
        return numExecutors > 0 ? new Some(executorLocations.apply(this.floorMod$1(tp.hashCode(), numExecutors))) : None$.MODULE$;
    }

    private final int floorMod$1(long a, int b) {
        return ((int)(a % (long)b) + b) % b;
    }

    public KafkaOffsetRangeCalculator(Option<Object> minPartitions) {
        this.minPartitions = minPartitions;
        Predef$.MODULE$.require(minPartitions.isEmpty() || BoxesRunTime.unboxToInt(minPartitions.get()) > 0);
    }
}

