/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.Index;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceCountedACLCache {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceCountedACLCache.class);
    final Map<Long, List<ACL>> longKeyMap = new HashMap<Long, List<ACL>>();
    final Map<List<ACL>, Long> aclKeyMap = new HashMap<List<ACL>, Long>();
    final Map<Long, AtomicLongWithEquals> referenceCounter = new HashMap<Long, AtomicLongWithEquals>();
    private static final long OPEN_UNSAFE_ACL_ID = -1L;
    long aclIndex = 0L;

    public synchronized Long convertAcls(List<ACL> acls) {
        if (acls == null) {
            return -1L;
        }
        Long ret = this.aclKeyMap.get(acls);
        if (ret == null) {
            ret = this.incrementIndex();
            this.longKeyMap.put(ret, acls);
            this.aclKeyMap.put(acls, ret);
        }
        this.addUsage(ret);
        return ret;
    }

    public synchronized List<ACL> convertLong(Long longVal) {
        if (longVal == null) {
            return null;
        }
        if (longVal == -1L) {
            return ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        List<ACL> acls = this.longKeyMap.get(longVal);
        if (acls == null) {
            LOG.error("ERROR: ACL not available for long " + longVal);
            throw new RuntimeException("Failed to fetch acls for " + longVal);
        }
        return acls;
    }

    private long incrementIndex() {
        return ++this.aclIndex;
    }

    public synchronized void deserialize(InputArchive ia) throws IOException {
        this.clear();
        for (int i = ia.readInt("map"); i > 0; --i) {
            Long val = ia.readLong("long");
            if (this.aclIndex < val) {
                this.aclIndex = val;
            }
            ArrayList<ACL> aclList = new ArrayList<ACL>();
            Index j = ia.startVector("acls");
            while (!j.done()) {
                ACL acl = new ACL();
                acl.deserialize(ia, "acl");
                aclList.add(acl);
                j.incr();
            }
            this.longKeyMap.put(val, aclList);
            this.aclKeyMap.put(aclList, val);
            this.referenceCounter.put(val, new AtomicLongWithEquals(0L));
        }
    }

    public synchronized void serialize(OutputArchive oa) throws IOException {
        oa.writeInt(this.longKeyMap.size(), "map");
        Set<Map.Entry<Long, List<ACL>>> set2 = this.longKeyMap.entrySet();
        for (Map.Entry<Long, List<ACL>> val : set2) {
            oa.writeLong(val.getKey(), "long");
            List<ACL> aclList = val.getValue();
            oa.startVector(aclList, "acls");
            for (ACL acl : aclList) {
                acl.serialize(oa, "acl");
            }
            oa.endVector(aclList, "acls");
        }
    }

    public int size() {
        return this.aclKeyMap.size();
    }

    private void clear() {
        this.aclKeyMap.clear();
        this.longKeyMap.clear();
        this.referenceCounter.clear();
    }

    public synchronized void addUsage(Long acl) {
        if (acl == -1L) {
            return;
        }
        if (!this.longKeyMap.containsKey(acl)) {
            LOG.info("Ignoring acl " + acl + " as it does not exist in the cache");
            return;
        }
        AtomicLong count2 = this.referenceCounter.get(acl);
        if (count2 == null) {
            this.referenceCounter.put(acl, new AtomicLongWithEquals(1L));
        } else {
            count2.incrementAndGet();
        }
    }

    public synchronized void removeUsage(Long acl) {
        if (acl == -1L) {
            return;
        }
        if (!this.longKeyMap.containsKey(acl)) {
            LOG.info("Ignoring acl " + acl + " as it does not exist in the cache");
            return;
        }
        long newCount = this.referenceCounter.get(acl).decrementAndGet();
        if (newCount <= 0L) {
            this.referenceCounter.remove(acl);
            this.aclKeyMap.remove(this.longKeyMap.get(acl));
            this.longKeyMap.remove(acl);
        }
    }

    public synchronized void purgeUnused() {
        Iterator<Map.Entry<Long, AtomicLongWithEquals>> refCountIter = this.referenceCounter.entrySet().iterator();
        while (refCountIter.hasNext()) {
            Map.Entry<Long, AtomicLongWithEquals> entry2 = refCountIter.next();
            if (entry2.getValue().get() > 0L) continue;
            Long acl = entry2.getKey();
            this.aclKeyMap.remove(this.longKeyMap.get(acl));
            this.longKeyMap.remove(acl);
            refCountIter.remove();
        }
    }

    private static class AtomicLongWithEquals
    extends AtomicLong {
        private static final long serialVersionUID = 3355155896813725462L;

        public AtomicLongWithEquals(long i) {
            super(i);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.equals((AtomicLongWithEquals)o);
        }

        public boolean equals(AtomicLongWithEquals that) {
            return this.get() == that.get();
        }

        public int hashCode() {
            return 31 * Long.valueOf(this.get()).hashCode();
        }
    }
}

