/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.history;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.history.HistoricalDatabaseTable;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class HistoryPolicy
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected DatabaseMapping mapping;
    protected List<DatabaseTable> historicalTables;
    protected List<DatabaseField> startFields;
    protected List<DatabaseField> endFields;
    protected boolean shouldHandleWrites = true;
    protected boolean usesLocalTime = true;

    public Expression additionalHistoryExpression(Expression context, Expression base) {
        return this.additionalHistoryExpression(context, base, null);
    }

    public Expression additionalHistoryExpression(Expression context, Expression base, Integer tableIndex) {
        int iLast;
        int iFirst;
        AsOfClause clause = base.getAsOfClause();
        Object value2 = clause.getValue();
        Expression join = null;
        Expression subJoin = null;
        Expression start2 = null;
        Expression end = null;
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Expression) {
            if (value2 instanceof ConstantExpression && ((ConstantExpression)value2).getValue() instanceof String) {
                value2 = ((ConstantExpression)value2).getValue();
            }
        } else {
            ConversionManager converter = ConversionManager.getDefaultManager();
            value2 = converter.convertObject(value2, ClassConstants.TIMESTAMP);
        }
        if (this.getMapping() != null) {
            if (tableIndex != null && tableIndex > 0) {
                return null;
            }
            TableExpression tableExp = null;
            DatabaseTable historicalTable = this.getHistoricalTables().get(0);
            tableExp = (TableExpression)((ObjectExpression)base).existingDerivedTable(historicalTable);
            start2 = tableExp.getField(this.getStart());
            end = tableExp.getField(this.getEnd());
            join = start2.lessThanEqual(value2).and(end.isNull().or(end.greaterThan(value2)));
            tableExp.setTable(historicalTable);
            return join;
        }
        if (tableIndex == null) {
            iFirst = 0;
            iLast = this.getHistoricalTables().size() - 1;
        } else {
            iLast = iFirst = tableIndex.intValue();
        }
        int i = iFirst;
        while (i <= iLast) {
            start2 = base.getField(this.getStart(i));
            end = base.getField(this.getEnd(i));
            subJoin = start2.lessThanEqual(value2).and(end.isNull().or(end.greaterThan(value2)));
            join = join == null ? subJoin : join.and(subJoin);
            ++i;
        }
        return join;
    }

    public Object clone() {
        HistoryPolicy clone2 = null;
        try {
            clone2 = (HistoryPolicy)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        if (this.startFields != null) {
            clone2.setStartFields(new ArrayList<DatabaseField>(this.startFields.size()));
            for (DatabaseField field2 : this.startFields) {
                clone2.getStartFields().add(field2.clone());
            }
        }
        if (this.endFields != null) {
            clone2.setEndFields(new ArrayList<DatabaseField>(this.endFields.size()));
            for (DatabaseField field2 : this.endFields) {
                clone2.getEndFields().add(field2.clone());
            }
        }
        if (this.historicalTables != null) {
            clone2.setHistoricalTables(new ArrayList<DatabaseTable>(this.historicalTables));
        }
        return clone2;
    }

    public Object getCurrentTime(AbstractSession session) {
        if (this.shouldUseLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.shouldUseDatabaseTime()) {
            AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (readSession.isUnitOfWork()) {
                readSession = ((UnitOfWorkImpl)readSession).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return readSession.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, readSession.getName());
        }
        return null;
    }

    public long getMinimumTimeIncrement(AbstractSession session) {
        AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
        while (readSession.isUnitOfWork()) {
            readSession = ((UnitOfWorkImpl)readSession).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
        }
        return readSession.getPlatform().minimumTimeIncrement();
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final List<DatabaseTable> getHistoricalTables() {
        if (this.historicalTables == null) {
            this.historicalTables = NonSynchronizedVector.newInstance(1);
        }
        return this.historicalTables;
    }

    public List<String> getHistoryTableNames() {
        ArrayList<String> names = new ArrayList<String>(this.getHistoricalTables().size());
        for (DatabaseTable table : this.getHistoricalTables()) {
            names.add(table.getQualifiedName());
        }
        return names;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected DatabaseField getStart() {
        if (this.startFields != null) {
            return this.startFields.get(0);
        }
        return null;
    }

    protected DatabaseField getStart(int i) {
        return this.startFields.get(i);
    }

    public String getStartFieldName() {
        if (this.getStart() != null) {
            return this.getStart().getName();
        }
        return null;
    }

    public List<DatabaseField> getStartFields() {
        return this.startFields;
    }

    protected DatabaseField getEnd() {
        if (this.endFields != null) {
            return this.endFields.get(0);
        }
        return null;
    }

    protected DatabaseField getEnd(int i) {
        return this.endFields.get(i);
    }

    public String getEndFieldName() {
        if (this.getEnd() != null) {
            return this.getEnd().getName();
        }
        return null;
    }

    public List<DatabaseField> getEndFields() {
        return this.endFields;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void initialize(AbstractSession session) {
        if (this.getMapping() != null) {
            this.setDescriptor(this.getMapping().getDescriptor());
            if (this.getMapping().isDirectCollectionMapping()) {
                DatabaseTable refTable = ((DirectCollectionMapping)this.getMapping()).getReferenceTable();
                DatabaseTable histTable = this.getHistoricalTables().get(0);
                histTable.setName(refTable.getName());
                histTable.setTableQualifier(refTable.getTableQualifier());
                this.getStart().setTable(histTable);
                this.getEnd().setTable(histTable);
            } else if (this.getMapping().isManyToManyMapping()) {
                DatabaseTable relationTable = ((ManyToManyMapping)this.getMapping()).getRelationTable();
                DatabaseTable histTable = this.getHistoricalTables().get(0);
                histTable.setName(relationTable.getName());
                histTable.setTableQualifier(relationTable.getTableQualifier());
                this.getStart().setTable(histTable);
                this.getEnd().setTable(histTable);
            }
            this.verifyTableQualifiers(session.getPlatform());
            return;
        }
        int offset2 = this.getDescriptor().getTables().size() - this.getHistoricalTables().size();
        if (!this.getHistoricalTables().isEmpty() && this.getHistoricalTables().get(0).getName().equals("")) {
            int i = 0;
            while (i < this.getHistoricalTables().size()) {
                DatabaseField endField;
                DatabaseField startField;
                DatabaseTable table = this.getHistoricalTables().get(i);
                if (table.getName().equals("")) {
                    DatabaseTable mirrored = this.getDescriptor().getTables().get(i + offset2);
                    table.setName(mirrored.getName());
                    table.setTableQualifier(mirrored.getTableQualifier());
                }
                if (this.getStartFields().size() < i + 1) {
                    startField = this.getStart(0).clone();
                    startField.setTable(table);
                    this.getStartFields().add(startField);
                } else {
                    startField = this.getStart(i);
                    startField.setTable(table);
                }
                if (this.getEndFields().size() < i + 1) {
                    endField = this.getEnd(0).clone();
                    endField.setTable(table);
                    this.getEndFields().add(endField);
                } else {
                    endField = this.getEnd(i);
                    endField.setTable(table);
                }
                ++i;
            }
        } else {
            List<DatabaseTable> unsortedTables = this.getHistoricalTables();
            ArrayList<DatabaseTable> sortedTables = new ArrayList<DatabaseTable>(unsortedTables.size());
            ArrayList<DatabaseField> sortedStartFields = new ArrayList<DatabaseField>(unsortedTables.size());
            ArrayList<DatabaseField> sortedEndFields = new ArrayList<DatabaseField>(unsortedTables.size());
            boolean universalStartField = this.getStartFields().size() == 1 && !this.getStartFields().get(0).hasTableName();
            boolean universalEndField = this.getEndFields().size() == 1 && !this.getEndFields().get(0).hasTableName();
            DatabaseTable descriptorTable = null;
            DatabaseTable historicalTable = null;
            DatabaseField historyField = null;
            Vector<DatabaseTable> descriptorTables = this.getDescriptor().getTables();
            int i = offset2;
            while (i < descriptorTables.size()) {
                descriptorTable = (DatabaseTable)descriptorTables.get(i);
                int index = unsortedTables.indexOf(descriptorTable);
                historicalTable = unsortedTables.get(index);
                historicalTable.setTableQualifier(descriptorTable.getTableQualifier());
                sortedTables.add(historicalTable);
                if (universalStartField) {
                    historyField = this.getStart(0).clone();
                    historyField.setTable(historicalTable);
                    sortedStartFields.add(historyField);
                } else {
                    for (DatabaseField field2 : this.getStartFields()) {
                        if (!field2.getTable().equals(historicalTable)) continue;
                        sortedStartFields.add(field2);
                        break;
                    }
                }
                if (universalEndField) {
                    historyField = this.getEnd(0).clone();
                    historyField.setTable(historicalTable);
                    sortedEndFields.add(historyField);
                } else {
                    for (DatabaseField field2 : this.getEndFields()) {
                        if (!field2.getTable().equals(historicalTable)) continue;
                        sortedEndFields.add(field2);
                        break;
                    }
                }
                ++i;
            }
            this.setHistoricalTables(sortedTables);
            this.setStartFields(sortedStartFields);
            this.setEndFields(sortedEndFields);
        }
        this.verifyTableQualifiers(session.getPlatform());
        if (this.getDescriptor().hasInheritance()) {
            ClassDescriptor parentDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
            while (parentDescriptor != null && parentDescriptor.getHistoryPolicy() == null) {
                parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
            }
            if (parentDescriptor != null) {
                this.setHistoricalTables(Helper.concatenateUniqueLists(parentDescriptor.getHistoryPolicy().getHistoricalTables(), this.getHistoricalTables()));
                this.setStartFields(Helper.concatenateUniqueLists(parentDescriptor.getHistoryPolicy().getStartFields(), this.getStartFields()));
                this.setEndFields(Helper.concatenateUniqueLists(parentDescriptor.getHistoryPolicy().getEndFields(), this.getEndFields()));
            }
        }
    }

    public void addHistoryTableName(String name) {
        HistoricalDatabaseTable table = new HistoricalDatabaseTable("");
        table.setHistoricalName(name);
        this.getHistoricalTables().add(table);
    }

    public void addHistoryTableName(String sourceTableName, String historyTableName) {
        if (sourceTableName == null || sourceTableName.equals("")) {
            this.addHistoryTableName(historyTableName);
        }
        HistoricalDatabaseTable table = new HistoricalDatabaseTable(sourceTableName);
        table.setHistoricalName(historyTableName);
        int index = this.getHistoricalTables().indexOf(table);
        if (index == -1) {
            this.getHistoricalTables().add(table);
        } else {
            this.getHistoricalTables().set(index, table);
        }
    }

    public void setHistoricalTables(List<DatabaseTable> historicalTables) {
        this.historicalTables = historicalTables;
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    protected void setStartFields(List<DatabaseField> startFields) {
        this.startFields = startFields;
    }

    public void addStartFieldName(String startFieldName) {
        DatabaseField startField = new DatabaseField(startFieldName);
        startField.setType(ClassConstants.TIMESTAMP);
        if (this.startFields == null) {
            this.startFields = NonSynchronizedVector.newInstance();
            this.startFields.add(startField);
            return;
        }
        for (DatabaseField existing : this.startFields) {
            if (!startField.getTableName().equals(existing.getTableName())) continue;
            existing.setName(startField.getName());
            return;
        }
        this.startFields.add(startField);
    }

    public void setStartFieldType(Class type) {
        for (DatabaseField existing : this.startFields) {
            existing.setType(type);
        }
    }

    protected void setEndFields(List<DatabaseField> endFields) {
        this.endFields = endFields;
    }

    public void addEndFieldName(String endFieldName) {
        DatabaseField endField = new DatabaseField(endFieldName);
        endField.setType(ClassConstants.TIMESTAMP);
        if (this.endFields == null) {
            this.endFields = new ArrayList<DatabaseField>();
            this.endFields.add(endField);
            return;
        }
        for (DatabaseField existing : this.endFields) {
            if (!endField.getTableName().equals(existing.getTableName())) continue;
            existing.setName(endField.getName());
            return;
        }
        this.endFields.add(endField);
    }

    public void setEndFieldType(String fieldName, Class type) {
        for (DatabaseField existing : this.endFields) {
            existing.setType(type);
        }
    }

    public void setShouldHandleWrites(boolean value2) {
        this.shouldHandleWrites = value2;
    }

    public boolean shouldHandleWrites() {
        return this.shouldHandleWrites;
    }

    public void setShouldUseDatabaseTime(boolean value2) {
        this.usesLocalTime = !value2;
    }

    public boolean shouldUseLocalTime() {
        return this.usesLocalTime;
    }

    public boolean shouldUseDatabaseTime() {
        return !this.usesLocalTime;
    }

    public void useLocalTime() {
        this.usesLocalTime = true;
    }

    public void useDatabaseTime() {
        this.usesLocalTime = false;
    }

    protected void verifyTableQualifiers(DatasourcePlatform platform) {
        String tableQualifier = platform.getTableQualifier();
        if (tableQualifier.length() == 0) {
            return;
        }
        for (DatabaseTable table : this.getHistoricalTables()) {
            DatabaseTable scratchTable = new DatabaseTable(table.getQualifiedName());
            if (scratchTable.getTableQualifier().length() != 0) continue;
            scratchTable.setTableQualifier(tableQualifier);
            ((HistoricalDatabaseTable)table).setHistoricalName(scratchTable.getQualifiedNameDelimited(platform));
        }
    }

    protected boolean checkWastedVersioning(AbstractRecord modifyRow, DatabaseTable table) {
        Enumeration fieldsEnum = modifyRow.keys();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField field2 = (DatabaseField)fieldsEnum.nextElement();
            if (!field2.getTable().equals(table) && field2.hasTableName()) continue;
            return true;
        }
        return false;
    }

    public void postDelete(ModifyQuery deleteQuery) {
        this.logicalDelete(deleteQuery, false);
    }

    public void postUpdate(ObjectLevelModifyQuery writeQuery) {
        this.postUpdate(writeQuery, false);
    }

    public void postUpdate(ObjectLevelModifyQuery writeQuery, boolean isShallow) {
        this.logicalDelete(writeQuery, true, isShallow);
        this.logicalInsert(writeQuery, true);
    }

    public void postInsert(ObjectLevelModifyQuery writeQuery) {
        this.logicalInsert(writeQuery, false);
    }

    public void logicalInsert(ObjectLevelModifyQuery writeQuery, boolean isUpdate) {
        ClassDescriptor descriptor = this.getDescriptor();
        AbstractRecord modifyRow = null;
        AbstractRecord originalModifyRow = writeQuery.getModifyRow();
        Object currentTime = null;
        if (isUpdate) {
            modifyRow = descriptor.getObjectBuilder().buildRow(writeQuery.getObject(), writeQuery.getSession(), DatabaseMapping.WriteType.UPDATE);
            modifyRow.putAll((Map)originalModifyRow);
        } else {
            modifyRow = originalModifyRow;
            currentTime = this.getCurrentTime(writeQuery.getSession());
        }
        StatementQueryMechanism insertMechanism = new StatementQueryMechanism(writeQuery);
        int i = 0;
        while (i < this.getHistoricalTables().size()) {
            DatabaseTable table = this.getHistoricalTables().get(i);
            if (!isUpdate || this.checkWastedVersioning(originalModifyRow, table)) {
                if (!isUpdate) {
                    modifyRow.add(this.getStart(i), currentTime);
                }
                SQLInsertStatement insertStatement = new SQLInsertStatement();
                insertStatement.setTable(table);
                insertMechanism.getSQLStatements().add(insertStatement);
            }
            ++i;
        }
        if (insertMechanism.hasMultipleStatements()) {
            writeQuery.setTranslationRow(modifyRow);
            writeQuery.setModifyRow(modifyRow);
            insertMechanism.insertObject();
        }
    }

    public void mappingLogicalInsert(DataModifyQuery originalQuery, AbstractRecord arguments, AbstractSession session) {
        DataModifyQuery historyQuery = new DataModifyQuery();
        SQLInsertStatement historyStatement = new SQLInsertStatement();
        DatabaseTable histTable = this.getHistoricalTables().get(0);
        historyStatement.setTable(histTable);
        AbstractRecord modifyRow = originalQuery.getModifyRow().clone();
        AbstractRecord translationRow = arguments.clone();
        if (!modifyRow.containsKey(this.getStart())) {
            Object time = this.getCurrentTime(session);
            modifyRow.add(this.getStart(), time);
            translationRow.add(this.getStart(), time);
        }
        historyQuery.setSQLStatement(historyStatement);
        historyQuery.setModifyRow(modifyRow);
        historyStatement.setModifyRow(modifyRow);
        session.executeQuery((DatabaseQuery)historyQuery, translationRow);
    }

    public void logicalDelete(ModifyQuery writeQuery, boolean isUpdate) {
        this.logicalDelete(writeQuery, isUpdate, false);
    }

    public void logicalDelete(ModifyQuery writeQuery, boolean isUpdate, boolean isShallow) {
        ClassDescriptor descriptor = writeQuery.getDescriptor();
        AbstractRecord originalModifyRow = writeQuery.getModifyRow();
        DatabaseRecord modifyRow = new DatabaseRecord();
        StatementQueryMechanism updateMechanism = new StatementQueryMechanism(writeQuery);
        Object currentTime = this.getCurrentTime(writeQuery.getSession());
        int i = 0;
        while (i < this.getHistoricalTables().size()) {
            DatabaseTable table = this.getHistoricalTables().get(i);
            if (!isUpdate || this.checkWastedVersioning(originalModifyRow, table)) {
                SQLUpdateStatement updateStatement = new SQLUpdateStatement();
                updateStatement.setTable(table);
                Expression whereClause = null;
                if (writeQuery instanceof DeleteAllQuery) {
                    if (writeQuery.getSelectionCriteria() != null) {
                        whereClause = (Expression)writeQuery.getSelectionCriteria().clone();
                    }
                } else {
                    whereClause = descriptor.getObjectBuilder().buildPrimaryKeyExpression(table);
                }
                ExpressionBuilder builder = whereClause == null ? new ExpressionBuilder() : whereClause.getBuilder();
                whereClause = builder.getField(this.getEnd(i)).isNull().and(whereClause);
                updateStatement.setWhereClause(whereClause);
                modifyRow.add(this.getEnd(i), currentTime);
                if (isUpdate) {
                    if (isShallow) {
                        Timestamp incrementedTime = (Timestamp)currentTime;
                        incrementedTime.setTime(incrementedTime.getTime() + this.getMinimumTimeIncrement(writeQuery.getSession()));
                        originalModifyRow.add(this.getStart(i), incrementedTime);
                    } else {
                        originalModifyRow.add(this.getStart(i), currentTime);
                    }
                }
                updateMechanism.getSQLStatements().add(updateStatement);
            }
            ++i;
        }
        if (updateMechanism.hasMultipleStatements()) {
            writeQuery.setModifyRow(modifyRow);
            updateMechanism.updateObject();
            writeQuery.setModifyRow(originalModifyRow);
        }
    }

    public void mappingLogicalDelete(ModifyQuery originalQuery, AbstractRecord arguments, AbstractSession session) {
        SQLDeleteStatement originalStatement = (SQLDeleteStatement)originalQuery.getSQLStatement();
        DataModifyQuery historyQuery = new DataModifyQuery();
        SQLUpdateStatement historyStatement = new SQLUpdateStatement();
        DatabaseTable histTable = this.getHistoricalTables().get(0);
        historyStatement.setTable(histTable);
        Expression whereClause = (Expression)originalStatement.getWhereClause().clone();
        DatabaseField endField = this.getEnd();
        whereClause = whereClause.getBuilder().getField(endField).isNull().and(whereClause);
        historyStatement.setWhereClause(whereClause);
        DatabaseRecord modifyRow = new DatabaseRecord();
        AbstractRecord translationRow = arguments.clone();
        Object time = this.getCurrentTime(session);
        modifyRow.add(this.getEnd(), time);
        translationRow.add(this.getEnd(), time);
        historyStatement.setModifyRow(modifyRow);
        historyQuery.setSQLStatement(historyStatement);
        historyQuery.setModifyRow(modifyRow);
        session.executeQuery((DatabaseQuery)historyQuery, translationRow);
    }
}

