/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public abstract class CompoundExpression
extends Expression {
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Expression firstChild;
    protected Expression secondChild;
    protected ExpressionBuilder builder;

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CompoundExpression expression = (CompoundExpression)object;
        return (this.operator == expression.operator || this.operator != null && this.operator.equals(expression.operator)) && (this.firstChild == expression.firstChild || this.firstChild != null && this.firstChild.equals(expression.firstChild)) && (this.secondChild == expression.secondChild || this.secondChild != null && this.secondChild.equals(expression.secondChild));
    }

    @Override
    public int computeHashCode() {
        int hashCode2 = super.computeHashCode();
        if (this.operator != null) {
            hashCode2 += this.operator.hashCode();
        }
        if (this.firstChild != null) {
            hashCode2 += this.firstChild.hashCode();
        }
        if (this.secondChild != null) {
            hashCode2 += this.secondChild.hashCode();
        }
        return hashCode2;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        DatabaseTable alias = null;
        if (this.firstChild != null) {
            alias = this.firstChild.aliasForTable(table);
        }
        if (alias == null && this.secondChild != null) {
            alias = this.secondChild.aliasForTable(table);
        }
        return alias;
    }

    @Override
    public Expression asOf(AsOfClause clause) {
        final AsOfClause finalClause = clause;
        ExpressionIterator iterator2 = new ExpressionIterator(){

            @Override
            public void iterate(Expression each) {
                if (each.isDataExpression()) {
                    each.asOf(finalClause);
                }
            }

            @Override
            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        iterator2.iterateOn(this);
        return this;
    }

    @Override
    public Expression create(Expression base, Object singleArgument, ExpressionOperator operator) {
        this.setFirstChild(base);
        Expression argument = Expression.from(singleArgument, base);
        this.setSecondChild(argument);
        this.setOperator(operator);
        return this;
    }

    @Override
    public Expression create(Expression base, List arguments, ExpressionOperator operator) {
        this.setFirstChild(base);
        if (!arguments.isEmpty()) {
            this.setSecondChild((Expression)arguments.get(0));
        }
        this.setOperator(operator);
        return this;
    }

    @Override
    public String descriptionOfNodeType() {
        return "Compound Expression";
    }

    @Override
    public ExpressionBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.firstChild.getBuilder();
            if (this.builder == null) {
                this.builder = this.secondChild.getBuilder();
            }
        }
        return this.builder;
    }

    public Expression getFirstChild() {
        return this.firstChild;
    }

    @Override
    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform platform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(platform);
        }
        return this.platformOperator;
    }

    public Expression getSecondChild() {
        return this.secondChild;
    }

    public void initializePlatformOperator(DatabasePlatform platform) {
        if (this.operator.isComplete()) {
            this.platformOperator = this.operator;
            return;
        }
        this.platformOperator = platform.getOperator(this.operator.getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.operator.toString());
        }
    }

    @Override
    public boolean isCompoundExpression() {
        return true;
    }

    @Override
    public void iterateOn(ExpressionIterator iterator2) {
        super.iterateOn(iterator2);
        if (this.firstChild != null) {
            this.firstChild.iterateOn(iterator2);
        }
        if (this.secondChild != null) {
            this.secondChild.iterateOn(iterator2);
        }
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        boolean previous2 = normalizer.isAddAdditionalExpressionsWithinCurrrentExpressionContext();
        boolean isOrExpression = this.isLogicalExpression() && this.operator.getSelector() == 2;
        normalizer.setAddAdditionalExpressionsWithinCurrrentExpressionContext(previous2 || isOrExpression);
        try {
            ExpressionBuilder builder;
            if (this.firstChild != null) {
                builder = this.firstChild.getBuilder();
                if (builder != null) {
                    builder.setSession(normalizer.getSession().getRootSession(null));
                }
                this.setFirstChild(normalizer.processAdditionalLocalExpressions(this.firstChild.normalize(normalizer), isOrExpression));
            }
            if (this.secondChild != null) {
                builder = this.secondChild.getBuilder();
                if (builder != null) {
                    builder.setSession(normalizer.getSession().getRootSession(null));
                }
                this.setSecondChild(normalizer.processAdditionalLocalExpressions(this.secondChild.normalize(normalizer), isOrExpression));
            }
        }
        finally {
            normalizer.setAddAdditionalExpressionsWithinCurrrentExpressionContext(previous2);
        }
        if (this.firstChild == null) {
            return this.secondChild;
        }
        if (this.secondChild == null) {
            return this.firstChild;
        }
        return this;
    }

    @Override
    public void validateNode() {
        if (this.firstChild != null && (this.firstChild.isDataExpression() || this.firstChild.isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
        if (this.secondChild != null && (this.secondChild.isDataExpression() || this.secondChild.isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.firstChild != null) {
            this.setFirstChild(this.firstChild.copiedVersionFrom(alreadyDone));
        }
        if (this.secondChild != null) {
            this.setSecondChild(this.secondChild.copiedVersionFrom(alreadyDone));
        }
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        printer.printString("(");
        realOperator.printDuo(this.firstChild, this.secondChild, printer);
        printer.printString(")");
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printJavaDuo(this.firstChild, this.secondChild, printer);
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        NonSynchronizedVector arguments;
        Expression first = this.firstChild.rebuildOn(newBase);
        if (this.secondChild == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).add(this.secondChild.rebuildOn(newBase));
        }
        return first.performOperator(this.operator, arguments);
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
        this.firstChild.resetPlaceHolderBuilder(queryBuilder);
        if (this.secondChild != null) {
            this.secondChild.resetPlaceHolderBuilder(queryBuilder);
        }
    }

    protected void setFirstChild(Expression firstChild) {
        this.firstChild = firstChild;
        this.builder = null;
    }

    public void setOperator(ExpressionOperator newOperator) {
        this.operator = newOperator;
    }

    protected void setSecondChild(Expression secondChild) {
        this.secondChild = secondChild;
        this.builder = null;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        NonSynchronizedVector arguments;
        if (this.secondChild == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).addElement(this.secondChild.twistedForBaseAndContext(newBase, context, oldBase));
        }
        Expression first = this.firstChild.twistedForBaseAndContext(newBase, context, oldBase);
        return first.performOperator(this.operator, arguments);
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.operator.toString());
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.firstChild != null) {
            this.firstChild.toString(writer, indent);
        }
        if (this.secondChild != null) {
            this.secondChild.toString(writer, indent);
        }
    }

    @Override
    public Expression shallowClone() {
        CompoundExpression clone2 = (CompoundExpression)super.shallowClone();
        clone2.builder = null;
        return clone2;
    }
}

