/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FromSubSelectExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.history.DecoratedDatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public abstract class DataExpression
extends BaseExpression {
    protected List<Expression> derivedTables;
    protected List<Expression> derivedFields;
    protected boolean hasBeenNormalized;
    protected TableAliasLookup tableAliases;
    protected AsOfClause asOfClause;

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DataExpression expression = (DataExpression)object;
        return (this.baseExpression == expression.getBaseExpression() || this.baseExpression != null && this.baseExpression.equals(expression.getBaseExpression())) && (this.getAsOfClause() == expression.getAsOfClause() || this.getAsOfClause() != null && this.getAsOfClause().equals(expression.getAsOfClause()));
    }

    public void addDerivedField(Expression addThis) {
        if (this.derivedFields == null) {
            this.derivedFields = new ArrayList<Expression>();
        }
        this.derivedFields.add(addThis);
    }

    public void addDerivedTable(Expression addThis) {
        if (this.derivedTables == null) {
            this.derivedTables = new ArrayList<Expression>();
        }
        this.derivedTables.add(addThis);
    }

    @Override
    public Expression asOf(AsOfClause clause) {
        this.asOfClause = clause;
        return this;
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        if (this.tableAliases == null) {
            if (this.baseExpression == null) {
                return null;
            }
            return this.baseExpression.aliasForTable(table);
        }
        return this.tableAliases.keyAtValue(table);
    }

    @Override
    protected void assignAlias(String name, DatabaseTable table) {
        if (!this.getBuilder().getSession().getProject().hasGenericHistorySupport()) {
            this.assignAlias(new DecoratedDatabaseTable(name, this.getAsOfClause()), table);
        } else {
            this.assignAlias(new DatabaseTable(name), table);
        }
    }

    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        if (this.tableAliases == null) {
            this.tableAliases = new TableAliasLookup();
        }
        this.tableAliases.put(alias, table);
    }

    public void clearAliases() {
        this.tableAliases = null;
    }

    public List<Expression> copyCollection(List<Expression> in, Map alreadyDone) {
        if (in == null) {
            return null;
        }
        ArrayList<Expression> result2 = new ArrayList<Expression>(in.size());
        for (Expression exp : in) {
            result2.add(exp.copiedVersionFrom(alreadyDone));
        }
        return result2;
    }

    public Expression existingDerivedField(DatabaseField field2) {
        if (this.derivedFields == null) {
            return null;
        }
        for (Expression exp : this.derivedFields) {
            if (!((FieldExpression)exp).getField().equals(field2)) continue;
            return exp;
        }
        return null;
    }

    public Expression existingDerivedTable(DatabaseTable table) {
        if (this.derivedTables == null) {
            return null;
        }
        for (Expression exp : this.derivedTables) {
            if (!((TableExpression)exp).getTable().equals(table)) continue;
            return exp;
        }
        return null;
    }

    public DatabaseField getAliasedField() {
        return null;
    }

    @Override
    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public ClassDescriptor getDescriptor() {
        return null;
    }

    public DatabaseField getField() {
        return null;
    }

    @Override
    public Expression getField(String fieldName) {
        DatabaseField field2 = new DatabaseField(fieldName);
        return this.getField(field2);
    }

    @Override
    public Expression getField(DatabaseField field2) {
        Expression existing = this.existingDerivedField(field2);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedField(field2);
    }

    public ClassDescriptor getContainingDescriptor() {
        return ((DataExpression)this.baseExpression).getDescriptor();
    }

    public DatabaseMapping getMapping() {
        if (this.baseExpression == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getContainingDescriptor();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getObjectBuilder().getMappingForAttributeName(this.getName());
    }

    public QueryKey getQueryKeyOrNull() {
        return null;
    }

    @Override
    public Expression getTable(String tableName) {
        DatabaseTable table = new DatabaseTable(tableName);
        return this.getTable(table);
    }

    @Override
    public Expression getTable(DatabaseTable table) {
        Expression existing = this.existingDerivedTable(table);
        if (existing != null) {
            return existing;
        }
        return this.newDerivedTable(table);
    }

    @Override
    public TableAliasLookup getTableAliases() {
        return this.tableAliases;
    }

    public boolean hasBeenNormalized() {
        return this.hasBeenNormalized;
    }

    @Override
    public boolean hasAsOfClause() {
        return this.getAsOfClause() != null && this.getAsOfClause().getValue() != null;
    }

    @Override
    public boolean hasBeenAliased() {
        return this.tableAliases != null && this.tableAliases.size() != 0;
    }

    protected boolean hasDerivedFields() {
        return this.derivedFields != null;
    }

    protected boolean hasDerivedTables() {
        return this.derivedTables != null;
    }

    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isDataExpression() {
        return true;
    }

    @Override
    public void iterateOn(ExpressionIterator iterator2) {
        super.iterateOn(iterator2);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(iterator2);
        }
    }

    public Expression newDerivedField(DatabaseField field2) {
        FieldExpression result2 = new FieldExpression(field2, this);
        this.addDerivedField(result2);
        return result2;
    }

    public Expression newDerivedTable(DatabaseTable table) {
        TableExpression result2 = new TableExpression(table);
        result2.setBaseExpression(this);
        this.addDerivedTable(result2);
        return result2;
    }

    @Override
    public Expression getAlias(Expression subSelect) {
        FromSubSelectExpression result2 = new FromSubSelectExpression((SubSelectExpression)subSelect);
        result2.setBaseExpression(this);
        return result2;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.hasBeenNormalized) {
            return this;
        }
        this.hasBeenNormalized = true;
        if (this.baseExpression != null) {
            this.setBaseExpression(this.baseExpression.normalize(normalizer));
            if (this.getAsOfClause() == null) {
                this.asOf(this.baseExpression.getAsOfClause());
            }
        }
        return super.normalize(normalizer);
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.clearAliases();
        this.derivedFields = this.copyCollection(this.derivedFields, alreadyDone);
        this.derivedTables = this.copyCollection(this.derivedTables, alreadyDone);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printField(this.getAliasedField());
    }

    public void setHasBeenNormalized(boolean value2) {
        this.hasBeenNormalized = value2;
    }

    public void setTableAliases(TableAliasLookup tableAliases) {
        if (this.tableAliases == null) {
            this.tableAliases = tableAliases;
        }
    }

    public String tableAliasesDescription() {
        if (this.tableAliases == null) {
            return "";
        }
        return this.tableAliases.toString();
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.baseExpression != null) {
            this.baseExpression.toString(writer, indent);
        }
    }
}

