/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;

public class ExpressionJavaPrinter {
    protected StringWriter writer;
    protected String builderString;
    protected DatabasePlatform platform;

    public ExpressionJavaPrinter(String builderString, StringWriter writer, DatabasePlatform platform) {
        this.builderString = builderString;
        this.writer = writer;
        this.platform = platform;
    }

    public String getBuilderString() {
        return this.builderString;
    }

    public DatabasePlatform getPlatform() {
        return this.platform;
    }

    public StringWriter getWriter() {
        return this.writer;
    }

    public void printString(String value2) {
        this.getWriter().write(value2);
    }

    public void printJava(Object object) {
        if (object == null) {
            this.printString("null");
        } else if (object.getClass() == ClassConstants.STRING) {
            this.printString("\"");
            this.printString((String)object);
            this.printString("\"");
        } else if (object instanceof Calendar) {
            this.printString("new java.util.Date(");
            this.printString(String.valueOf(((Calendar)object).getTimeInMillis()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.TIMESTAMP) {
            this.printString("new java.sql.Timestamp(");
            this.printString(String.valueOf(((Timestamp)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.SQLDATE) {
            this.printString("new java.sql.Date(");
            this.printString(String.valueOf(((java.sql.Date)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.TIME) {
            this.printString("new java.sql.Time(");
            this.printString(String.valueOf(((Time)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            this.printString("new java.util.Date(");
            this.printString(String.valueOf(((Date)object).getTime()));
            this.printString("L)");
        } else if (object.getClass() == ClassConstants.BYTE) {
            this.printByte((Byte)object);
        } else if (object.getClass() == ClassConstants.APBYTE) {
            this.printString("new byte[] {");
            byte[] bytes2 = (byte[])object;
            if (bytes2.length > 0) {
                this.printString(String.valueOf(bytes2[0]));
                int index = 1;
                while (index < bytes2.length) {
                    this.printString(",");
                    this.printString(String.valueOf(bytes2[index]));
                    ++index;
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.ABYTE) {
            this.printString("new Byte[] {");
            Byte[] bytes3 = (Byte[])object;
            if (bytes3.length > 0) {
                this.printByte(bytes3[0]);
                int index = 1;
                while (index < bytes3.length) {
                    this.printString(",");
                    this.printByte(bytes3[index]);
                    ++index;
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.CHAR) {
            this.printCharacter((Character)object);
        } else if (object.getClass() == ClassConstants.APCHAR) {
            this.printString("new char[] {");
            char[] chars = (char[])object;
            if (chars.length > 0) {
                this.printString("'");
                this.printString(String.valueOf(chars[0]));
                this.printString("'");
                int index = 1;
                while (index < chars.length) {
                    this.printString(",");
                    this.printString("'");
                    this.printString(String.valueOf(chars[index]));
                    this.printString("'");
                    ++index;
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.ACHAR) {
            this.printString("new Character[] {");
            Character[] chars = (Character[])object;
            if (chars.length > 0) {
                this.printCharacter(chars[0]);
                int index = 1;
                while (index < chars.length) {
                    this.printString(",");
                    this.printCharacter(chars[index]);
                    ++index;
                }
            }
            this.printString("}");
        } else if (object.getClass() == ClassConstants.BIGDECIMAL) {
            this.printString("new java.math.BigDecimal(\"");
            this.printString(((BigDecimal)object).toString());
            this.printString("\")");
        } else if (object.getClass() == ClassConstants.BIGINTEGER) {
            this.printString("new java.math.BigInteger(\"");
            this.printString(((BigInteger)object).toString());
            this.printString("\")");
        } else {
            this.printString((String)ConversionManager.getDefaultManager().convertObject(object, String.class));
        }
    }

    public void printByte(Byte aByte) {
        this.printString("new Byte((byte)");
        this.printString(aByte.toString());
        this.printString(")");
    }

    public void printCharacter(Character aCharacter) {
        this.printString("new Character('");
        this.printString(aCharacter.toString());
        this.printString("')");
    }
}

