/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class FunctionExpression
extends BaseExpression {
    protected Vector children = NonSynchronizedVector.newInstance(2);
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Class resultType = null;

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FunctionExpression expression = (FunctionExpression)object;
        if (!(this.operator == expression.getOperator() || this.operator != null && this.operator.equals(expression.getOperator()))) {
            return false;
        }
        Vector children2 = this.getChildren();
        Vector otherChildren = expression.getChildren();
        int size2 = children2.size();
        if (size2 != otherChildren.size()) {
            return false;
        }
        int index = 0;
        while (index < size2) {
            if (!children2.get(index).equals(otherChildren.get(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public int computeHashCode() {
        int hashCode2 = super.computeHashCode();
        if (this.operator != null) {
            hashCode2 += this.operator.hashCode();
        }
        Vector children2 = this.getChildren();
        int size2 = children2.size();
        int index = 0;
        while (index < size2) {
            hashCode2 += children2.get(index).hashCode();
            ++index;
        }
        return hashCode2;
    }

    public void addChild(Expression child) {
        this.getChildren().addElement(child);
    }

    @Override
    public DatabaseTable aliasForTable(DatabaseTable table) {
        return this.getBaseExpression().aliasForTable(table);
    }

    @Override
    public Expression asOf(AsOfClause clause) {
        final AsOfClause finalClause = clause;
        ExpressionIterator iterator2 = new ExpressionIterator(){

            @Override
            public void iterate(Expression each) {
                if (each.isDataExpression()) {
                    each.asOf(finalClause);
                }
            }

            @Override
            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        iterator2.iterateOn(this);
        return this;
    }

    @Override
    public Expression create(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        ExpressionBuilder builder;
        this.baseExpression = base;
        this.addChild(base);
        Expression localBase = base;
        if (anOperator.isFunctionOperator() && (builder = this.getBuilder()) != null) {
            localBase = builder;
        }
        Expression arg = Expression.from(singleArgument, localBase);
        this.addChild(arg);
        this.setOperator(anOperator);
        return this;
    }

    @Override
    public Expression createWithBaseLast(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        ExpressionBuilder builder;
        this.baseExpression = base;
        Expression localBase = base;
        if (anOperator.isFunctionOperator() && (builder = this.getBuilder()) != null) {
            localBase = builder;
        }
        Expression arg = Expression.from(singleArgument, localBase);
        this.addChild(arg);
        this.addChild(base);
        this.setOperator(anOperator);
        return this;
    }

    @Override
    public Expression create(Expression base, List arguments, ExpressionOperator anOperator) {
        ExpressionBuilder builder;
        this.baseExpression = base;
        this.setOperator(anOperator);
        this.addChild(base);
        Expression localBase = base;
        if (anOperator.isFunctionOperator() && (builder = this.getBuilder()) != null) {
            localBase = builder;
        }
        for (Object argument : arguments) {
            Expression arg = Expression.from(argument, localBase);
            this.addChild(arg);
        }
        return this;
    }

    @Override
    public String descriptionOfNodeType() {
        return "Function";
    }

    @Override
    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        int selector = this.operator.getSelector();
        if (selector == 3) {
            return !this.getBaseExpression().doesConform(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        }
        if (selector == 15 || selector == 16 || selector == 13 || selector == 14 || selector == 11 || selector == 141 || selector == 12) {
            Object leftValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            int size2 = this.children.size();
            Vector rightValue = new Vector(size2);
            int index = 1;
            while (index < size2) {
                Object child = this.children.get(index);
                Object valueFromRight = child instanceof Expression ? ((Expression)child).valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered) : child;
                if (valueFromRight instanceof Vector) {
                    rightValue = (Vector)valueFromRight;
                } else {
                    rightValue.add(valueFromRight);
                }
                ++index;
            }
            if (leftValue instanceof Vector) {
                for (Object tempLeft : (Vector)leftValue) {
                    if (!this.operator.doesRelationConform(tempLeft, rightValue)) continue;
                    return true;
                }
                return false;
            }
            return this.operator.doesRelationConform(leftValue, rightValue);
        }
        if (selector == 17 || selector == 18) {
            Object leftValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            if (leftValue instanceof Vector) {
                for (Object tempLeft : (Vector)leftValue) {
                    if (!this.operator.doesRelationConform(tempLeft, null)) continue;
                    return true;
                }
                return false;
            }
            return this.operator.doesRelationConform(leftValue, null);
        }
        throw QueryException.cannotConformExpression();
    }

    public Vector getChildren() {
        return this.children;
    }

    @Override
    public Vector getFields() {
        return this.getBaseExpression().getFields();
    }

    @Override
    public List<DatabaseField> getSelectionFields(ReadQuery query) {
        return this.getBaseExpression().getSelectionFields(query);
    }

    @Override
    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform platform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(platform);
        }
        return this.platformOperator;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public boolean hasResultType() {
        return this.resultType != null;
    }

    public void initializePlatformOperator(DatabasePlatform platform) {
        if (this.operator.isComplete()) {
            this.platformOperator = this.operator;
            return;
        }
        this.platformOperator = platform.getOperator(this.operator.getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.operator.toString());
        }
    }

    @Override
    public boolean isFunctionExpression() {
        return true;
    }

    protected boolean isObjectComparison() {
        int selector = this.operator.getSelector();
        if ((selector != 17 && selector != 18 || this.children.size() != 1) && (selector != 129 && selector != 130 || this.children.size() != 2)) {
            return false;
        }
        Expression base = this.getBaseExpression();
        return base.isObjectExpression() && !((ObjectExpression)base).isAttribute() && !((ObjectExpression)base).isDirectCollection();
    }

    @Override
    public void iterateOn(ExpressionIterator iterator2) {
        super.iterateOn(iterator2);
        Enumeration childrenEnum = this.children.elements();
        while (childrenEnum.hasMoreElements()) {
            Expression child = (Expression)childrenEnum.nextElement();
            child.iterateOn(iterator2);
        }
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        if (this.children.isEmpty()) {
            return this;
        }
        ExpressionBuilder builder = this.getBuilder();
        if (builder != null && builder.getSession() == null) {
            builder.setSession(normalizer.getSession().getRootSession(null));
        }
        if (this.operator.getSelector() == 19) {
            this.prepareObjectAttributeCount(normalizer, null, null, null);
        }
        if (!this.isObjectComparison()) {
            int index = 0;
            while (index < this.children.size()) {
                this.children.set(index, ((Expression)this.children.get(index)).normalize(normalizer));
                ++index;
            }
            return this;
        }
        int index = 0;
        while (index < this.children.size()) {
            ((Expression)this.children.get(index)).validateNode();
            ++index;
        }
        ObjectExpression base = (ObjectExpression)this.getBaseExpression();
        if (base.getBaseExpression() != null) {
            base.getBaseExpression().normalize(normalizer);
        }
        if (this.operator.getSelector() == 129 || this.operator.getSelector() == 130) {
            ReportQuery query;
            if (this.children.size() != 2) {
                throw QueryException.invalidExpression(this);
            }
            DatabaseMapping mapping = null;
            if (base.isQueryKeyExpression()) {
                mapping = base.getMapping();
            }
            List<DatabaseField> sourceFields = null;
            List<DatabaseField> targetFields = null;
            if (mapping != null && mapping.isOneToOneMapping() && !((OneToOneMapping)mapping).hasRelationTableMechanism() && !((OneToOneMapping)mapping).hasCustomSelectionQuery()) {
                base = (ObjectExpression)base.getBaseExpression();
                Map<DatabaseField, DatabaseField> targetToSourceKeyFields = ((OneToOneMapping)mapping).getTargetToSourceKeyFields();
                sourceFields = new ArrayList<DatabaseField>(targetToSourceKeyFields.size());
                targetFields = new ArrayList<DatabaseField>(targetToSourceKeyFields.size());
                for (Map.Entry<DatabaseField, DatabaseField> entry2 : targetToSourceKeyFields.entrySet()) {
                    sourceFields.add(entry2.getValue());
                    targetFields.add(entry2.getKey());
                }
            } else {
                mapping = null;
                targetFields = sourceFields = base.getDescriptor().getPrimaryKeyFields();
            }
            if (sourceFields.size() != 1) {
                base = (ObjectExpression)this.getBaseExpression();
                SubSelectExpression subSelectExp = (SubSelectExpression)this.children.get(1);
                ReportQuery subQuery = subSelectExp.getSubQuery();
                subQuery.getItems().clear();
                subQuery.addItem("one", new ConstantExpression(1, subQuery.getExpressionBuilder()));
                Expression subSelectCriteria = subQuery.getSelectionCriteria();
                ExpressionBuilder subBuilder = subQuery.getExpressionBuilder();
                subSelectCriteria = this.operator.getSelector() == 129 ? subBuilder.equal(base).and(subSelectCriteria) : subBuilder.notEqual(base).and(subSelectCriteria);
                subQuery.setSelectionCriteria(subSelectCriteria);
                Expression newExp = builder.exists(subQuery);
                return newExp.normalize(normalizer);
            }
            Expression newBase = base.getField(sourceFields.get(0));
            this.setBaseExpression(newBase);
            this.children.set(0, newBase);
            Expression right = (Expression)this.children.get(1);
            if (right.isSubSelectExpression()) {
                query = ((SubSelectExpression)right).getSubQuery();
                if (query.getItems().size() != 1) {
                    throw QueryException.invalidExpression(this);
                }
            } else {
                throw QueryException.invalidExpression(this);
            }
            ReportItem item = query.getItems().get(0);
            item.setAttributeExpression(item.getAttributeExpression().getField(targetFields.get(0)));
            int index2 = 0;
            while (index2 < this.children.size()) {
                this.children.set(index2, ((Expression)this.children.get(index2)).normalize(normalizer));
                ++index2;
            }
            return this;
        }
        Expression foreignKeyJoin = null;
        if (base.getMapping() == null) {
            foreignKeyJoin = base.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromKeys(null, this.getSession());
            foreignKeyJoin = foreignKeyJoin.rebuildOn(base);
        } else {
            foreignKeyJoin = base.getMapping().buildObjectJoinExpression((Expression)base, (Object)null, this.getSession());
        }
        if (this.operator.getSelector() == 18) {
            foreignKeyJoin = foreignKeyJoin.not();
        }
        return foreignKeyJoin.normalize(normalizer);
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        Vector oldChildren = this.children;
        this.children = NonSynchronizedVector.newInstance();
        int i = 0;
        while (i < oldChildren.size()) {
            this.addChild(((Expression)oldChildren.elementAt(i)).copiedVersionFrom(alreadyDone));
            ++i;
        }
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions() && !this.children.isEmpty()) {
            boolean allParams = true;
            for (Expression child : this.children) {
                if (child.isParameterExpression() || child.isConstantExpression()) continue;
                allParams = false;
            }
            if (allParams) {
                printer.getCall().setUsesBinding(false);
            }
        }
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printCollection(this.children, printer);
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printJavaCollection(this.children, printer);
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        NonSynchronizedVector newChildren = NonSynchronizedVector.newInstance(this.children.size());
        int i = 1;
        while (i < this.children.size()) {
            ((Vector)newChildren).addElement(((Expression)this.children.elementAt(i)).rebuildOn(newBase));
            ++i;
        }
        newLocalBase.setSelectIfOrderedBy(this.getBaseExpression().selectIfOrderedBy());
        FunctionExpression rebuilt = (FunctionExpression)newLocalBase.performOperator(this.operator, newChildren);
        rebuilt.setResultType(this.getResultType());
        return rebuilt;
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
        this.getBaseExpression().resetPlaceHolderBuilder(queryBuilder);
        int i = this.children.size() - 1;
        while (i > 0) {
            ((Expression)this.children.elementAt(i)).resetPlaceHolderBuilder(queryBuilder);
            --i;
        }
    }

    @Override
    public void setLocalBase(Expression exp) {
        this.getBaseExpression().setLocalBase(exp);
    }

    public void setOperator(ExpressionOperator theOperator) {
        this.operator = theOperator;
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        if (this.children.isEmpty()) {
            return (Expression)this.clone();
        }
        NonSynchronizedVector newChildren = NonSynchronizedVector.newInstance(this.children.size());
        int index = 1;
        while (index < this.children.size()) {
            ((Vector)newChildren).addElement(((Expression)this.children.elementAt(index)).twistedForBaseAndContext(newBase, context, oldBase));
            ++index;
        }
        Expression oldBaseExp = (Expression)this.children.elementAt(0);
        return oldBaseExp.twistedForBaseAndContext(newBase, context, oldBase).performOperator(this.operator, newChildren);
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        Object baseValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        NonSynchronizedVector arguments = NonSynchronizedVector.newInstance(this.children.size());
        int index = 1;
        while (index < this.children.size()) {
            if (this.children.elementAt(index) instanceof Expression) {
                ((Vector)arguments).addElement(((Expression)this.children.elementAt(index)).valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered));
            } else {
                ((Vector)arguments).addElement(this.children.elementAt(index));
            }
            ++index;
        }
        if (baseValue instanceof Vector) {
            Vector<Object> baseVector = new Vector<Object>();
            Enumeration valuesToCompare = ((Vector)baseValue).elements();
            while (valuesToCompare.hasMoreElements()) {
                Object baseObject = valuesToCompare.nextElement();
                if (baseObject == null) {
                    baseVector.addElement(baseObject);
                    continue;
                }
                baseVector.addElement(this.operator.applyFunction(baseObject, arguments));
            }
            return baseVector;
        }
        if (baseValue == null) {
            return null;
        }
        return this.operator.applyFunction(baseValue, arguments);
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.operator.toString());
    }

    @Override
    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (this.getBaseExpression().isDataExpression()) {
            DatabaseField field2 = ((DataExpression)this.getBaseExpression()).getField();
            field2 = field2 == null ? new DatabaseField("*") : field2.clone();
            field2.setSqlType(Integer.MIN_VALUE);
            if (this.hasResultType()) {
                field2.setType(this.getResultType());
            } else {
                int selector = this.operator.getSelector();
                if (selector != 22 && selector != 23) {
                    field2.setType(null);
                }
            }
            newFields.addElement(field2);
        } else {
            DatabaseField field3 = new DatabaseField("*");
            field3.setSqlType(Integer.MIN_VALUE);
            field3.setType(this.getResultType());
            newFields.addElement(field3);
        }
        this.printSQL(printer);
    }

    @Override
    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.baseExpression != null) {
            this.baseExpression.toString(writer, indent);
        }
    }

    public void prepareObjectAttributeCount(ExpressionNormalizer normalizer, ReportItem item, ReportQuery query, Map clonedExpressions) {
        if (this.getOperator().getSelector() == 19) {
            Expression baseExp = this.getBaseExpression();
            boolean distinctUsed = false;
            if (baseExp.isFunctionExpression() && ((FunctionExpression)baseExp).getOperator().getSelector() == 87) {
                distinctUsed = true;
                baseExp = ((FunctionExpression)baseExp).getBaseExpression();
            }
            boolean outerJoin = false;
            ClassDescriptor newDescriptor = null;
            AbstractSession session = null;
            session = query != null ? query.getSession() : normalizer.getSession();
            if (baseExp.isQueryKeyExpression()) {
                ClassDescriptor descriptor = null;
                descriptor = query == null ? ((QueryKeyExpression)baseExp).getDescriptor() : query.getDescriptor();
                DatabaseMapping mapping = baseExp.getLeafMapping(query, descriptor, session);
                if (mapping != null && !mapping.isAbstractDirectMapping()) {
                    outerJoin = ((QueryKeyExpression)baseExp).shouldUseOuterJoin();
                    if (mapping.isAggregateMapping()) {
                        newDescriptor = mapping.getDescriptor();
                        baseExp = ((QueryKeyExpression)baseExp).getBaseExpression();
                    } else {
                        newDescriptor = mapping.getReferenceDescriptor();
                    }
                } else {
                    QueryKey queryKey = this.getLeafQueryKeyFor(query, baseExp, descriptor, session);
                    if (queryKey != null && queryKey.isForeignReferenceQueryKey()) {
                        outerJoin = ((QueryKeyExpression)baseExp).shouldUseOuterJoin();
                        newDescriptor = session.getDescriptor(((ForeignReferenceQueryKey)queryKey).getReferenceClass());
                    }
                }
            } else if (baseExp.isExpressionBuilder()) {
                if (((ExpressionBuilder)baseExp).getQueryClass() == null) {
                    if (item != null) {
                        item.setResultType(ClassConstants.INTEGER);
                    }
                } else {
                    newDescriptor = session.getDescriptor(((ExpressionBuilder)baseExp).getQueryClass());
                }
            }
            if (newDescriptor != null) {
                if (newDescriptor.getPrimaryKeyFields().size() == 1 || !distinctUsed) {
                    Expression countArg = baseExp.getField(newDescriptor.getPrimaryKeyFields().get(0));
                    if (distinctUsed) {
                        countArg = countArg.distinct();
                    }
                    this.setBaseExpression(countArg);
                    this.getChildren().set(0, countArg);
                } else if (((DatabasePlatform)session.getPlatform(newDescriptor.getJavaClass())).supportsCountDistinctWithMultipleFields()) {
                    ArrayList<Expression> args = new ArrayList<Expression>(newDescriptor.getPrimaryKeyFields().size());
                    Expression firstField = null;
                    for (DatabaseField field2 : newDescriptor.getPrimaryKeyFields()) {
                        if (firstField == null) {
                            firstField = baseExp.getField(field2);
                            continue;
                        }
                        args.add(baseExp.getField(field2));
                    }
                    ExpressionOperator anOperator = new ExpressionOperator();
                    anOperator.setType(5);
                    NonSynchronizedVector v = NonSynchronizedVector.newInstance(args.size());
                    ((Vector)v).addElement("DISTINCT ");
                    int index = 0;
                    while (index < args.size()) {
                        ((Vector)v).add(", ");
                        ++index;
                    }
                    ((Vector)v).add("");
                    anOperator.printsAs(v);
                    anOperator.bePrefix();
                    anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
                    Expression distinctFunction = anOperator.expressionForArguments(firstField, args);
                    this.setBaseExpression(distinctFunction);
                    this.getChildren().set(0, distinctFunction);
                } else if (!outerJoin && query != null) {
                    ExpressionBuilder outerBuilder;
                    if (clonedExpressions != null) {
                        baseExp = clonedExpressions.get(baseExp.getBuilder()) != null ? baseExp.copiedVersionFrom(clonedExpressions) : baseExp.rebuildOn(query.getExpressionBuilder());
                    }
                    ExpressionBuilder countBuilder = baseExp.getBuilder();
                    ReportQuery subSelect = new ReportQuery(query.getReferenceClass(), countBuilder);
                    query.getSession().getPlatform().retrieveFirstPrimaryKeyOrOne(subSelect);
                    if (query.getSelectionCriteria() != null) {
                        outerBuilder = new ExpressionBuilder(newDescriptor.getJavaClass());
                        query.setExpressionBuilder(outerBuilder);
                        subSelect.setSelectionCriteria(baseExp.equal(outerBuilder).and(query.getSelectionCriteria()));
                    } else {
                        outerBuilder = new ExpressionBuilder(newDescriptor.getJavaClass());
                        query.setExpressionBuilder(outerBuilder);
                        subSelect.setSelectionCriteria(baseExp.equal(outerBuilder));
                    }
                    query.setNonFetchJoinAttributeExpressions(null);
                    query.setSelectionCriteria(outerBuilder.exists(subSelect));
                    this.setBaseExpression(outerBuilder);
                    this.getChildren().set(0, outerBuilder);
                    query.setReferenceClass(newDescriptor.getJavaClass());
                    query.changeDescriptor(session);
                } else {
                    ReadQuery reportQuery = query;
                    if (query == null) {
                        reportQuery = normalizer.getStatement().getQuery();
                    }
                    throw QueryException.distinctCountOnOuterJoinedCompositePK(newDescriptor, reportQuery);
                }
            }
        }
    }

    protected QueryKey getLeafQueryKeyFor(DatabaseQuery query, Expression expression, ClassDescriptor rootDescriptor, AbstractSession session) throws QueryException {
        if (expression == null || expression.isFieldExpression()) {
            return null;
        }
        if (!expression.isQueryKeyExpression()) {
            return null;
        }
        QueryKeyExpression qkExpression = (QueryKeyExpression)expression;
        Expression baseExpression = qkExpression.getBaseExpression();
        ClassDescriptor descriptor = baseExpression.getLeafDescriptor(query, rootDescriptor, session);
        return descriptor.getQueryKeyNamed(qkExpression.getName());
    }

    protected DatabaseMapping getMappingOfFirstPrimaryKey(ClassDescriptor descriptor) {
        if (descriptor != null) {
            for (DatabaseMapping m : descriptor.getMappings()) {
                if (!m.isPrimaryKeyMapping()) continue;
                return m;
            }
        }
        return null;
    }
}

