/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class TableExpression
extends DataExpression {
    protected DatabaseTable table;

    public TableExpression() {
    }

    public TableExpression(DatabaseTable table) {
        this.table = table;
    }

    @Override
    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        QueryKeyExpression qkExpression;
        if (this.baseExpression.isQueryKeyExpression() && (qkExpression = (QueryKeyExpression)this.baseExpression).getTableAliases() != null && qkExpression.getTableAliases().keyAtValue(table) != null) {
            return;
        }
        super.assignAlias(alias, table);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TableExpression expression = (TableExpression)object;
        return this.table == expression.table || this.table != null && this.table.equals(expression.table);
    }

    @Override
    public int computeHashCode() {
        int hashCode2 = super.computeHashCode();
        if (this.getTable() != null) {
            hashCode2 += this.getTable().hashCode();
        }
        return hashCode2;
    }

    @Override
    public String descriptionOfNodeType() {
        return "Table";
    }

    @Override
    public Expression getField(String fieldName) {
        DatabaseField field2 = new DatabaseField(fieldName);
        if (!field2.hasTableName()) {
            field2.setTable(this.getTable());
        }
        return this.getField(field2);
    }

    @Override
    public List<DatabaseTable> getOwnedTables() {
        ArrayList<DatabaseTable> result2 = new ArrayList<DatabaseTable>(1);
        result2.add(this.getTable());
        return result2;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    @Override
    public boolean isTableExpression() {
        return true;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.hasBeenNormalized) {
            return this;
        }
        if (this.getTable().getTableQualifier().length() == 0 && normalizer.getSession().getDatasourceLogin().getTableQualifier().length() != 0) {
            this.getTable().setTableQualifier(normalizer.getSession().getDatasourceLogin().getTableQualifier());
        }
        return super.normalize(normalizer);
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        return newLocalBase.getTable(this.getTable());
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context, oldBase);
        return twistedBase.getTable(this.getTable());
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getTable().toString());
        writer.write(this.tableAliasesDescription());
    }
}

