/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapEnumeration;
import org.eclipse.persistence.internal.identitymaps.IdentityMapKeyEnumeration;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class FullIdentityMap
extends AbstractIdentityMap {
    protected Map<Object, CacheKey> cacheKeys;

    public FullIdentityMap() {
    }

    public FullIdentityMap(int size2, ClassDescriptor descriptor, AbstractSession session, boolean isolated) {
        super(size2, descriptor, session, isolated);
        this.cacheKeys = new ConcurrentHashMap<Object, CacheKey>(size2);
    }

    @Override
    public Object clone() {
        FullIdentityMap clone2 = (FullIdentityMap)super.clone();
        clone2.setCacheKeys(new ConcurrentHashMap<Object, CacheKey>(this.cacheKeys.size()));
        Iterator<CacheKey> cacheKeysIterator = this.cacheKeys.values().iterator();
        while (cacheKeysIterator.hasNext()) {
            CacheKey key = (CacheKey)cacheKeysIterator.next().clone();
            clone2.getCacheKeys().put(key.getKey(), key);
        }
        return clone2;
    }

    @Override
    public void collectLocks(HashMap threadList) {
        for (CacheKey cacheKey : this.cacheKeys.values()) {
            if (!cacheKey.isAcquired()) continue;
            Thread activeThread = cacheKey.getActiveThread();
            HashSet<CacheKey> set2 = (HashSet<CacheKey>)threadList.get(activeThread);
            if (set2 == null) {
                set2 = new HashSet<CacheKey>();
                threadList.put(activeThread, set2);
            }
            set2.add(cacheKey);
        }
    }

    @Override
    public Enumeration elements() {
        return new IdentityMapEnumeration(this);
    }

    @Override
    public CacheKey getCacheKey(Object searchKey, boolean forMerge) {
        return this.cacheKeys.get(searchKey);
    }

    @Override
    protected CacheKey putCacheKeyIfAbsent(CacheKey searchKey) {
        searchKey.setOwningMap(this);
        return ((ConcurrentMap)this.cacheKeys).putIfAbsent(searchKey.getKey(), searchKey);
    }

    public Map<Object, CacheKey> getCacheKeys() {
        return this.cacheKeys;
    }

    @Override
    public int getSize() {
        return this.cacheKeys.size();
    }

    @Override
    public int getSize(Class myClass, boolean recurse) {
        int count2 = 0;
        for (CacheKey key : this.cacheKeys.values()) {
            Object object = key.getObject();
            if (object == null) continue;
            if (recurse && myClass.isInstance(object)) {
                ++count2;
                continue;
            }
            if (!object.getClass().equals(myClass)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public Enumeration keys() {
        return this.keys(true);
    }

    @Override
    public Enumeration keys(boolean checkReadLocks) {
        return new IdentityMapKeyEnumeration(this, checkReadLocks);
    }

    @Override
    public void lazyRelationshipLoaded(Object object, ValueHolderInterface valueHolder, ForeignReferenceMapping mapping) {
    }

    @Override
    public CacheKey put(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, object, writeLockValue, readTime);
        CacheKey cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
        if (cacheKey == null) {
            return newCacheKey;
        }
        this.resetCacheKey(cacheKey, object, writeLockValue, readTime);
        return cacheKey;
    }

    @Override
    public Object remove(CacheKey cacheKey) {
        if (cacheKey != null) {
            cacheKey.acquire();
            this.cacheKeys.remove(cacheKey.getKey());
            cacheKey.setOwningMap(null);
            cacheKey.setInvalidationState(-1);
            cacheKey.release();
            return cacheKey.getObject();
        }
        return null;
    }

    public void resetCacheKey(CacheKey key, Object object, Object writeLockValue, long readTime) {
        key.acquire();
        key.setObject(object);
        key.setWriteLockValue(writeLockValue);
        key.setReadTime(readTime);
        key.release();
    }

    protected void setCacheKeys(Map<Object, CacheKey> cacheKeys) {
        this.cacheKeys = cacheKeys;
    }
}

