/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.HashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class UnitOfWorkIdentityMap
extends FullIdentityMap {
    protected UnitOfWorkIdentityMap() {
    }

    public UnitOfWorkIdentityMap(int size2, ClassDescriptor descriptor, AbstractSession session, boolean isolated) {
        this.maxSize = size2;
        this.cacheKeys = new HashMap(size2);
        this.descriptor = descriptor;
        this.session = session;
        this.isIsolated = isolated;
    }

    @Override
    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new CacheKey(primaryKey, object, writeLockValue, readTime, true);
    }

    @Override
    public CacheKey acquireDeferredLock(Object primaryKey, boolean isCacheCheckComplete) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, false);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null, 0L))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    @Override
    public CacheKey acquireLock(Object primaryKey, boolean forMerge, boolean isCacheCheckComplete) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null, 0L))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    @Override
    public CacheKey acquireLockNoWait(Object primaryKey, boolean forMerge) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null, 0L))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    @Override
    public CacheKey acquireLockWithWait(Object primaryKey, boolean forMerge, int wait) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null, 0L))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    @Override
    public CacheKey acquireReadLockOnCacheKey(Object primaryKey) {
        return this.acquireReadLockOnCacheKeyNoWait(primaryKey);
    }

    @Override
    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null, 0L);
        CacheKey cacheKey = this.getCacheKey(newCacheKey, false);
        if (cacheKey == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    @Override
    protected CacheKey getCacheKeyWithReadLock(Object primaryKey) {
        return this.getCacheKey(primaryKey, false);
    }

    @Override
    protected CacheKey putCacheKeyIfAbsent(CacheKey searchKey) {
        searchKey.setOwningMap(this);
        this.cacheKeys.put(searchKey.getKey(), searchKey);
        return null;
    }

    @Override
    public Object remove(CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        this.cacheKeys.remove(cacheKey.getKey());
        cacheKey.setOwningMap(null);
        return cacheKey.getObject();
    }

    @Override
    public void resetCacheKey(CacheKey key, Object object, Object writeLockValue, long readTime) {
        key.setObject(object);
        key.setWriteLockValue(writeLockValue);
        key.setReadTime(readTime);
    }

    @Override
    public void setWriteLockValue(Object primaryKey, Object writeLockValue) {
        CacheKey cacheKey = this.getCacheKeyForLock(primaryKey);
        if (cacheKey != null) {
            cacheKey.setWriteLockValue(writeLockValue);
        }
    }
}

