/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Iterator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakCacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class WeakIdentityMap
extends FullIdentityMap {
    protected volatile int cleanupCount = 0;
    protected volatile int cleanupSize;

    public WeakIdentityMap(int size2, ClassDescriptor descriptor, AbstractSession session, boolean isolated) {
        super(size2, descriptor, session, isolated);
        this.cleanupSize = size2;
    }

    protected void cleanupDeadCacheKeys() {
        Iterator<CacheKey> iterator2 = this.getCacheKeys().values().iterator();
        while (iterator2.hasNext()) {
            CacheKey key = iterator2.next();
            if (key.getObject() != null || !key.acquireIfUnownedNoWait()) continue;
            try {
                if (key.getObject() != null) continue;
                iterator2.remove();
            }
            finally {
                key.release();
            }
        }
    }

    @Override
    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new WeakCacheKey(primaryKey, object, writeLockValue, readTime, this.isIsolated);
    }

    @Override
    protected CacheKey putCacheKeyIfAbsent(CacheKey searchKey) {
        CacheKey cacheKey = super.putCacheKeyIfAbsent(searchKey);
        if (cacheKey == null) {
            this.checkCleanup();
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCleanup() {
        if (this.cleanupCount > this.cleanupSize) {
            WeakIdentityMap weakIdentityMap = this;
            synchronized (weakIdentityMap) {
                if (this.cleanupCount > this.cleanupSize) {
                    if (this.session != null && this.session.isConcurrent()) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                WeakIdentityMap.this.cleanupDeadCacheKeys();
                                WeakIdentityMap.this.cleanupCount = 0;
                                int size2 = WeakIdentityMap.this.getSize();
                                if (size2 > WeakIdentityMap.this.cleanupSize) {
                                    WeakIdentityMap.this.cleanupSize = size2;
                                }
                            }
                        };
                        this.session.getServerPlatform().launchContainerRunnable(runnable);
                    } else {
                        this.cleanupDeadCacheKeys();
                        this.cleanupCount = 0;
                        int size2 = this.getSize();
                        if (size2 > this.cleanupSize) {
                            this.cleanupSize = size2;
                        }
                    }
                }
            }
        }
        ++this.cleanupCount;
    }
}

