/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class WeavedObjectBasicIndirectionPolicy
extends BasicIndirectionPolicy {
    protected String setMethodName = null;
    protected transient Method setMethod = null;
    protected String getMethodName;
    protected boolean hasUsedMethodAccess;
    protected String actualTypeClassName = null;

    public WeavedObjectBasicIndirectionPolicy(String getMethodName, String setMethodName, String actualTypeClassName, boolean hasUsedMethodAccess) {
        this.setMethodName = setMethodName;
        this.getMethodName = getMethodName;
        this.hasUsedMethodAccess = hasUsedMethodAccess;
        this.actualTypeClassName = actualTypeClassName;
    }

    public String getActualTypeClassName() {
        return this.actualTypeClassName;
    }

    @Override
    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        Object value2 = super.getRealAttributeValueFromObject(object, attribute);
        if (value2 != attribute) {
            this.updateValueInObject(object, value2, attribute);
        }
        return value2;
    }

    protected Method getSetMethod() {
        if (this.setMethod == null) {
            ForeignReferenceMapping sourceMapping = (ForeignReferenceMapping)this.mapping;
            Class[] parameterTypes = new Class[]{sourceMapping.getReferenceClass()};
            try {
                this.setMethod = Helper.getDeclaredMethod(sourceMapping.getDescriptor().getJavaClass(), this.setMethodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (this.actualTypeClassName != null) {
                    try {
                        parameterTypes[0] = Helper.getClassFromClasseName(this.actualTypeClassName, sourceMapping.getReferenceClass().getClassLoader());
                        this.setMethod = Helper.getDeclaredMethod(sourceMapping.getDescriptor().getJavaClass(), this.setMethodName, parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    if (this.setMethod != null) {
                        return this.setMethod;
                    }
                }
                try {
                    parameterTypes[0] = Object.class;
                    this.setMethod = Helper.getDeclaredMethod(sourceMapping.getDescriptor().getJavaClass(), this.setMethodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw DescriptorException.errorAccessingSetMethodOfEntity(sourceMapping.getDescriptor().getJavaClass(), this.setMethodName, sourceMapping.getDescriptor(), e);
                }
            }
        }
        return this.setMethod;
    }

    public void updateValueInObject(Object object, Object value2, Object attributeValue) {
        this.setRealAttributeValueInObject(object, value2);
        ((WeavedAttributeValueHolderInterface)attributeValue).setIsCoordinatedWithProperty(true);
    }

    @Override
    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        this.setRealAttributeValueInObject(target, attributeValue, false);
    }

    @Override
    public void setRealAttributeValueInObject(Object target, Object attributeValue, boolean trackChanges) {
        block13: {
            PropertyChangeListener listener = null;
            ChangeTracker trackedObject = null;
            if (!trackChanges && target instanceof ChangeTracker) {
                trackedObject = (ChangeTracker)target;
                listener = trackedObject._persistence_getPropertyChangeListener();
                trackedObject._persistence_setPropertyChangeListener(null);
            }
            Object[] parameters = new Object[]{attributeValue};
            try {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), target, parameters));
                            break block13;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, throwableException);
                            }
                            throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, throwableException);
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), target, parameters);
                }
                catch (IllegalAccessException exception) {
                    throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, exception);
                }
                catch (IllegalArgumentException exception) {
                    throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, exception);
                }
                catch (InvocationTargetException exception) {
                    throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, exception);
                }
            }
            finally {
                if (!trackChanges && trackedObject != null) {
                    trackedObject._persistence_setPropertyChangeListener(listener);
                }
            }
        }
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public boolean hasUsedMethodAccess() {
        return this.hasUsedMethodAccess;
    }

    @Override
    public boolean isWeavedObjectBasicIndirectionPolicy() {
        return true;
    }
}

