/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.many;

import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.core.mappings.CoreAttributeAccessor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.jaxb.many.MapEntry;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class MapValueAttributeAccessor
extends AttributeAccessor {
    private CoreAttributeAccessor nestedAccessor;
    private String mapClassName;
    private Class mapClass;
    private CoreContainerPolicy containerPolicy;
    private Class generatedEntryClass;
    private ClassLoader classLoader;

    public MapValueAttributeAccessor(CoreAttributeAccessor nestedAccessor, CoreContainerPolicy cp, Class generatedEntryClass, String mapClassName, ClassLoader classLoader) {
        this.nestedAccessor = nestedAccessor;
        this.mapClassName = mapClassName;
        this.containerPolicy = cp;
        this.generatedEntryClass = generatedEntryClass;
        this.classLoader = classLoader;
    }

    @Override
    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        Object value2 = this.nestedAccessor.getAttributeValueFromObject(object);
        if (value2 == null) {
            return null;
        }
        Object results = this.containerPolicy.containerInstance(((Map)value2).size());
        Set entrySet = ((Map)value2).entrySet();
        if (entrySet == null) {
            return results;
        }
        for (Map.Entry entry2 : entrySet) {
            MapEntry nextEntry;
            try {
                nextEntry = (MapEntry)this.generatedEntryClass.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
            nextEntry.setKey(entry2.getKey());
            nextEntry.setValue(entry2.getValue());
            this.containerPolicy.addInto(nextEntry, results, null);
        }
        return results;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value2) throws DescriptorException {
        Map mapValue = null;
        try {
            mapValue = (Map)this.mapClass.newInstance();
        }
        catch (InstantiationException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (IllegalAccessException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        if (value2 != null) {
            Object iterator2 = this.containerPolicy.iteratorFor(value2);
            while (this.containerPolicy.hasNext(iterator2)) {
                Object next2 = this.containerPolicy.next(iterator2, null);
                Object nextKey = ((MapEntry)next2).getKey();
                Object nextValue = ((MapEntry)next2).getValue();
                mapValue.put(nextKey, nextValue);
            }
        }
        this.nestedAccessor.setAttributeValueInObject(object, mapValue);
    }

    @Override
    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
        if (this.mapClassName.equals("java.util.Map")) {
            this.mapClassName = "java.util.HashMap";
        } else if (this.mapClassName.equals("java.util.concurrent.ConcurrentMap")) {
            this.mapClassName = "java.util.concurrent.ConcurrentHashMap";
        } else if (this.mapClassName.equals("java.util.SortedMap")) {
            this.mapClassName = "java.util.TreeMap";
        }
        try {
            this.mapClass = PrivilegedAccessHelper.getClassForName(this.mapClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }
}

