/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ArgumentListFunctionExpression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class CoalesceNode
extends Node
implements AliasableNode {
    private List clauses = null;

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = this.generateExpression(generationContext);
            reportQuery.addItem("Coalesce", expression);
        }
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            expressions.add(((Node)i.next()).generateExpression(context));
        }
        ArgumentListFunctionExpression whereClause = context.getBaseExpression().coalesce(expressions);
        return whereClause;
    }

    @Override
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        Iterator i = this.clauses.iterator();
        Object type = null;
        while (i.hasNext()) {
            Node node2 = (Node)i.next();
            node2.validate(context);
            if (type == null) {
                type = node2.getType();
                continue;
            }
            if (type.equals(node2.getType())) continue;
            type = typeHelper.getObjectType();
        }
        this.setType(((Node)this.clauses.get(0)).getType());
    }

    public List getClauses() {
        return this.clauses;
    }

    public void setClauses(List clauses) {
        this.clauses = clauses;
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

