/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.EscapeNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SimpleConditionalExpressionNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class LikeNode
extends SimpleConditionalExpressionNode {
    private EscapeNode escape = null;

    @Override
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            this.left.validateParameter(context, typeHelper.getStringType());
        }
        if (this.right != null) {
            this.right.validate(context);
            this.right.validateParameter(context, typeHelper.getStringType());
        }
        if (this.escape != null) {
            this.escape.validate(context);
        }
        this.setType(typeHelper.getBooleanType());
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = !this.hasEscape() ? whereClause.like(this.getRight().generateExpression(context)) : whereClause.like(this.getRight().generateExpression(context), this.getEscapeNode().generateExpression(context));
        return whereClause;
    }

    public boolean hasEscape() {
        return this.getEscapeNode() != null;
    }

    public EscapeNode getEscapeNode() {
        return this.escape;
    }

    public void setEscapeNode(EscapeNode node2) {
        this.escape = node2;
    }
}

