/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import org.eclipse.persistence.internal.jpa.parsing.AbsNode;
import org.eclipse.persistence.internal.jpa.parsing.AllNode;
import org.eclipse.persistence.internal.jpa.parsing.AndNode;
import org.eclipse.persistence.internal.jpa.parsing.AnyNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.AvgNode;
import org.eclipse.persistence.internal.jpa.parsing.BetweenNode;
import org.eclipse.persistence.internal.jpa.parsing.BooleanLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.CaseNode;
import org.eclipse.persistence.internal.jpa.parsing.ClassForInheritanceNode;
import org.eclipse.persistence.internal.jpa.parsing.CoalesceNode;
import org.eclipse.persistence.internal.jpa.parsing.CollectionMemberDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.ConcatNode;
import org.eclipse.persistence.internal.jpa.parsing.ConstructorNode;
import org.eclipse.persistence.internal.jpa.parsing.CountNode;
import org.eclipse.persistence.internal.jpa.parsing.DateFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.DeleteNode;
import org.eclipse.persistence.internal.jpa.parsing.DivideNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.DoubleLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.EmptyCollectionComparisonNode;
import org.eclipse.persistence.internal.jpa.parsing.EqualsAssignmentNode;
import org.eclipse.persistence.internal.jpa.parsing.EqualsNode;
import org.eclipse.persistence.internal.jpa.parsing.EscapeNode;
import org.eclipse.persistence.internal.jpa.parsing.ExistsNode;
import org.eclipse.persistence.internal.jpa.parsing.FetchJoinNode;
import org.eclipse.persistence.internal.jpa.parsing.FloatLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.FromNode;
import org.eclipse.persistence.internal.jpa.parsing.FuncNode;
import org.eclipse.persistence.internal.jpa.parsing.GreaterThanEqualToNode;
import org.eclipse.persistence.internal.jpa.parsing.GreaterThanNode;
import org.eclipse.persistence.internal.jpa.parsing.GroupByNode;
import org.eclipse.persistence.internal.jpa.parsing.HavingNode;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.InNode;
import org.eclipse.persistence.internal.jpa.parsing.IndexNode;
import org.eclipse.persistence.internal.jpa.parsing.IntegerLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.JoinDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.LengthNode;
import org.eclipse.persistence.internal.jpa.parsing.LessThanEqualToNode;
import org.eclipse.persistence.internal.jpa.parsing.LessThanNode;
import org.eclipse.persistence.internal.jpa.parsing.LikeNode;
import org.eclipse.persistence.internal.jpa.parsing.LiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.LocateNode;
import org.eclipse.persistence.internal.jpa.parsing.LongLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.LowerNode;
import org.eclipse.persistence.internal.jpa.parsing.MapEntryNode;
import org.eclipse.persistence.internal.jpa.parsing.MapKeyNode;
import org.eclipse.persistence.internal.jpa.parsing.MaxNode;
import org.eclipse.persistence.internal.jpa.parsing.MemberOfNode;
import org.eclipse.persistence.internal.jpa.parsing.MinNode;
import org.eclipse.persistence.internal.jpa.parsing.MinusNode;
import org.eclipse.persistence.internal.jpa.parsing.ModNode;
import org.eclipse.persistence.internal.jpa.parsing.MultiplyNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.NodeFactory;
import org.eclipse.persistence.internal.jpa.parsing.NotEqualsNode;
import org.eclipse.persistence.internal.jpa.parsing.NotNode;
import org.eclipse.persistence.internal.jpa.parsing.NullComparisonNode;
import org.eclipse.persistence.internal.jpa.parsing.NullIfNode;
import org.eclipse.persistence.internal.jpa.parsing.OrNode;
import org.eclipse.persistence.internal.jpa.parsing.OrderByItemNode;
import org.eclipse.persistence.internal.jpa.parsing.OrderByNode;
import org.eclipse.persistence.internal.jpa.parsing.ParameterNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.PlusNode;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.internal.jpa.parsing.RangeDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.internal.jpa.parsing.SetNode;
import org.eclipse.persistence.internal.jpa.parsing.SizeNode;
import org.eclipse.persistence.internal.jpa.parsing.SomeNode;
import org.eclipse.persistence.internal.jpa.parsing.SortDirectionNode;
import org.eclipse.persistence.internal.jpa.parsing.SqrtNode;
import org.eclipse.persistence.internal.jpa.parsing.StringLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.SubqueryNode;
import org.eclipse.persistence.internal.jpa.parsing.SubstringNode;
import org.eclipse.persistence.internal.jpa.parsing.SumNode;
import org.eclipse.persistence.internal.jpa.parsing.TemporalLiteralNode;
import org.eclipse.persistence.internal.jpa.parsing.TrimNode;
import org.eclipse.persistence.internal.jpa.parsing.UnaryMinus;
import org.eclipse.persistence.internal.jpa.parsing.UpdateNode;
import org.eclipse.persistence.internal.jpa.parsing.UpperNode;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.internal.jpa.parsing.WhenThenNode;
import org.eclipse.persistence.internal.jpa.parsing.WhereNode;

public class NodeFactoryImpl
implements NodeFactory {
    private ParseTreeContext context;
    private String currentIdentificationVariable;

    public NodeFactoryImpl(String queryInfo) {
        this.context = new ParseTreeContext(this, queryInfo);
    }

    @Override
    public Object newSelectStatement(int line, int column, Object select, Object from2, Object where, Object groupBy2, Object having, Object orderBy) {
        QueryNode queryNode = (QueryNode)select;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setContext(this.context);
        tree.setQueryNode(queryNode);
        tree.setFromNode((FromNode)from2);
        tree.setWhereNode((WhereNode)where);
        tree.setGroupByNode((GroupByNode)groupBy2);
        tree.setHavingNode((HavingNode)having);
        tree.setOrderByNode((OrderByNode)orderBy);
        return tree;
    }

    @Override
    public Object newUpdateStatement(int line, int column, Object update2, Object set2, Object where) {
        QueryNode queryNode = (QueryNode)update2;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setContext(this.context);
        tree.setQueryNode(queryNode);
        tree.setSetNode((SetNode)set2);
        tree.setWhereNode((WhereNode)where);
        return tree;
    }

    @Override
    public Object newDeleteStatement(int line, int column, Object delete2, Object where) {
        QueryNode queryNode = (QueryNode)delete2;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setContext(this.context);
        tree.setQueryNode(queryNode);
        tree.setWhereNode((WhereNode)where);
        return tree;
    }

    @Override
    public Object newSelectClause(int line, int column, boolean distinct2, List selectExprs) {
        return this.newSelectClause(line, column, distinct2, selectExprs, null);
    }

    @Override
    public Object newSelectClause(int line, int column, boolean distinct2, List selectExprs, List identifiers) {
        SelectNode node2 = new SelectNode();
        node2.setContext(this.context);
        node2.setSelectExpressions(selectExprs);
        node2.setIdentifiers(identifiers);
        if (identifiers != null) {
            int i = 0;
            while (i < identifiers.size()) {
                if (identifiers.get(i) != null) {
                    this.context.registerJoinVariable(this.calculateCanonicalName((String)identifiers.get(i)), (Node)selectExprs.get(i), line, column);
                }
                ++i;
            }
        }
        node2.setDistinct(distinct2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newFromClause(int line, int column, List decls) {
        FromNode node2 = new FromNode();
        node2.setContext(this.context);
        node2.setDeclarations(decls);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newWhereClause(int line, int column, Object condition) {
        WhereNode node2 = new WhereNode();
        node2.setContext(this.context);
        node2.setLeft((Node)condition);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newGroupByClause(int line, int column, List items) {
        GroupByNode node2 = new GroupByNode();
        node2.setContext(this.context);
        node2.setGroupByItems(items);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newHavingClause(int line, int column, Object arg) {
        HavingNode node2 = new HavingNode();
        node2.setContext(this.context);
        node2.setHaving((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newOrderByClause(int line, int column, List items) {
        OrderByNode node2 = new OrderByNode();
        node2.setContext(this.context);
        node2.setOrderByItems(items);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newUpdateClause(int line, int column, String schema, String variable) {
        UpdateNode node2 = new UpdateNode();
        node2.setContext(this.context);
        node2.setAbstractSchemaName(schema);
        node2.setAbstractSchemaIdentifier(variable);
        this.setPosition(node2, line, column);
        this.registerSchema(this.calculateCanonicalName(variable), schema, line, column);
        return node2;
    }

    @Override
    public Object newDeleteClause(int line, int column, String schema, String variable) {
        DeleteNode node2 = new DeleteNode();
        node2.setContext(this.context);
        node2.setAbstractSchemaName(schema);
        node2.setAbstractSchemaIdentifier(variable);
        this.setPosition(node2, line, column);
        this.registerSchema(this.calculateCanonicalName(variable), schema, line, column);
        return node2;
    }

    @Override
    public Object newRangeVariableDecl(int line, int column, String schema, String variable) {
        RangeDeclNode node2 = new RangeDeclNode();
        node2.setAbstractSchemaName(schema);
        node2.setVariableName(variable);
        this.setPosition(node2, line, column);
        this.registerSchema(node2.getCanonicalVariableName(), schema, line, column);
        this.currentIdentificationVariable = variable;
        return node2;
    }

    @Override
    public Object newJoinVariableDecl(int line, int column, boolean outerJoin, Object path, String variable, Object downcast) {
        DotNode dotNode = (DotNode)path;
        AttributeNode rightNode = (AttributeNode)dotNode.getRight();
        rightNode.setOuterJoin(outerJoin);
        if (downcast != null) {
            AttributeNode rightMostNode = (AttributeNode)dotNode.getRightMostNode();
            rightMostNode.setCastClassName((String)downcast);
        }
        JoinDeclNode node2 = new JoinDeclNode();
        node2.setPath(dotNode);
        node2.setVariableName(variable);
        node2.setOuterJoin(outerJoin);
        this.setPosition(node2, line, column);
        this.context.registerJoinVariable(node2.getCanonicalVariableName(), dotNode, line, column);
        this.currentIdentificationVariable = variable;
        return node2;
    }

    @Override
    public Object newFetchJoin(int line, int column, boolean outerJoin, Object path) {
        DotNode dotNode = (DotNode)path;
        AttributeNode rightNode = (AttributeNode)dotNode.getRight();
        rightNode.setOuterJoin(outerJoin);
        FetchJoinNode node2 = new FetchJoinNode();
        node2.setPath(dotNode);
        node2.setOuterJoin(outerJoin);
        this.setPosition(node2, line, column);
        this.context.registerFetchJoin(this.currentIdentificationVariable, dotNode);
        return node2;
    }

    @Override
    public Object newCollectionMemberVariableDecl(int line, int column, Object path, String variable) {
        DotNode dotNode = (DotNode)path;
        AttributeNode rightNode = (AttributeNode)dotNode.getRight();
        rightNode.setRequiresCollectionAttribute(true);
        CollectionMemberDeclNode node2 = new CollectionMemberDeclNode();
        node2.setPath(dotNode);
        node2.setVariableName(variable);
        this.setPosition(node2, line, column);
        this.context.registerJoinVariable(node2.getCanonicalVariableName(), dotNode, line, column);
        this.currentIdentificationVariable = variable;
        return node2;
    }

    @Override
    public Object newVariableDecl(int line, int column, Object path, String variable) {
        DotNode dotNode = (DotNode)path;
        JoinDeclNode node2 = new JoinDeclNode();
        node2.setPath(dotNode);
        node2.setVariableName(variable);
        this.setPosition(node2, line, column);
        this.context.registerJoinVariable(node2.getCanonicalVariableName(), dotNode, line, column);
        this.currentIdentificationVariable = variable;
        return node2;
    }

    @Override
    public Object newDot(int line, int column, Object left, Object right) {
        DotNode node2 = new DotNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newVariableAccessOrTypeConstant(int line, int column, String identifier2) {
        VariableNode node2 = new VariableNode(identifier2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newAttribute(int line, int column, String identifier2) {
        AttributeNode node2 = new AttributeNode(identifier2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newQualifiedAttribute(int line, int column, String variable, String attribute) {
        Object varNode = this.newVariableAccessOrTypeConstant(line, column, variable);
        Object attrNode = this.newAttribute(line, column, attribute);
        return this.newDot(line, column, varNode, attrNode);
    }

    @Override
    public Object newAvg(int line, int column, boolean distinct2, Object arg) {
        AvgNode node2 = new AvgNode();
        node2.setLeft((Node)arg);
        node2.setDistinct(distinct2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newMax(int line, int column, boolean distinct2, Object arg) {
        MaxNode node2 = new MaxNode();
        node2.setLeft((Node)arg);
        node2.setDistinct(distinct2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newMin(int line, int column, boolean distinct2, Object arg) {
        MinNode node2 = new MinNode();
        node2.setLeft((Node)arg);
        node2.setDistinct(distinct2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSum(int line, int column, boolean distinct2, Object arg) {
        SumNode node2 = new SumNode();
        node2.setLeft((Node)arg);
        node2.setDistinct(distinct2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newCount(int line, int column, boolean distinct2, Object arg) {
        CountNode node2 = new CountNode();
        node2.setLeft((Node)arg);
        node2.setDistinct(distinct2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newOr(int line, int column, Object left, Object right) {
        OrNode node2 = new OrNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newAnd(int line, int column, Object left, Object right) {
        AndNode node2 = new AndNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newEquals(int line, int column, Object left, Object right) {
        EqualsNode node2 = new EqualsNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newNotEquals(int line, int column, Object left, Object right) {
        NotEqualsNode node2 = new NotEqualsNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newGreaterThan(int line, int column, Object left, Object right) {
        GreaterThanNode node2 = new GreaterThanNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newGreaterThanEqual(int line, int column, Object left, Object right) {
        GreaterThanEqualToNode node2 = new GreaterThanEqualToNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newLessThan(int line, int column, Object left, Object right) {
        LessThanNode node2 = new LessThanNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newLessThanEqual(int line, int column, Object left, Object right) {
        LessThanEqualToNode node2 = new LessThanEqualToNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newPlus(int line, int column, Object left, Object right) {
        PlusNode node2 = new PlusNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newMinus(int line, int column, Object left, Object right) {
        MinusNode node2 = new MinusNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newMultiply(int line, int column, Object left, Object right) {
        MultiplyNode node2 = new MultiplyNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newBetween(int line, int column, boolean not, Object arg, Object lower, Object upper) {
        BetweenNode node2 = new BetweenNode();
        node2.setLeft((Node)arg);
        node2.setRightForBetween((Node)lower);
        node2.setRightForAnd((Node)upper);
        this.setPosition(node2, line, column);
        return not ? this.newNot(line, column, node2) : node2;
    }

    @Override
    public Object newDivide(int line, int column, Object left, Object right) {
        DivideNode node2 = new DivideNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newUnaryPlus(int line, int column, Object arg) {
        return arg;
    }

    @Override
    public Object newUnaryMinus(int line, int column, Object arg) {
        UnaryMinus node2 = new UnaryMinus();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newNot(int line, int column, Object arg) {
        NotNode node2 = new NotNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newLike(int line, int column, boolean not, Object string2, Object pattern, Object escape2) {
        LikeNode node2 = new LikeNode();
        node2.setLeft((Node)string2);
        node2.setRight((Node)pattern);
        node2.setEscapeNode((EscapeNode)escape2);
        this.setPosition(node2, line, column);
        return not ? this.newNot(line, column, node2) : node2;
    }

    @Override
    public Object newEscape(int line, int column, Object arg) {
        EscapeNode node2 = new EscapeNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newIn(int line, int column, boolean not, Object expr, List items) {
        InNode node2 = new InNode();
        if (not) {
            node2.indicateNot();
        }
        node2.setLeft((Node)expr);
        node2.setTheObjects(items);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newIsNull(int line, int column, boolean not, Object expr) {
        NullComparisonNode node2 = new NullComparisonNode();
        node2.setLeft((Node)expr);
        this.setPosition(node2, line, column);
        return not ? this.newNot(line, column, node2) : node2;
    }

    @Override
    public Object newIsEmpty(int line, int column, boolean not, Object expr) {
        EmptyCollectionComparisonNode node2 = new EmptyCollectionComparisonNode();
        node2.setLeft((Node)expr);
        if (not) {
            node2.indicateNot();
        }
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newMemberOf(int line, int column, boolean not, Object expr, Object collection) {
        MemberOfNode node2 = new MemberOfNode();
        node2.setLeft((Node)expr);
        node2.setRight((Node)collection);
        if (not) {
            node2.indicateNot();
        }
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newPositionalParameter(int line, int column, String position) {
        ParameterNode node2 = new ParameterNode(position);
        this.context.addParameter(position);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newNamedParameter(int line, int column, String name) {
        ParameterNode node2 = new ParameterNode(name);
        this.context.addParameter(name);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newBooleanLiteral(int line, int column, Object value2) {
        BooleanLiteralNode node2 = new BooleanLiteralNode();
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newIntegerLiteral(int line, int column, Object value2) {
        IntegerLiteralNode node2 = new IntegerLiteralNode();
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newLongLiteral(int line, int column, Object value2) {
        LongLiteralNode node2 = new LongLiteralNode();
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newFloatLiteral(int line, int column, Object value2) {
        FloatLiteralNode node2 = new FloatLiteralNode();
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newDoubleLiteral(int line, int column, Object value2) {
        DoubleLiteralNode node2 = new DoubleLiteralNode();
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newStringLiteral(int line, int column, Object value2) {
        StringLiteralNode node2 = new StringLiteralNode();
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newNullLiteral(int line, int column) {
        LiteralNode node2 = new LiteralNode();
        node2.setLiteral(null);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newConcat(int line, int column, List objects) {
        ConcatNode node2 = new ConcatNode();
        node2.setObjects(objects);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSubstring(int line, int column, Object string2, Object start2, Object length) {
        SubstringNode node2 = new SubstringNode();
        node2.setLeft((Node)string2);
        node2.setStartPosition((Node)start2);
        node2.setStringLength((Node)length);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newTrim(int line, int column, NodeFactory.TrimSpecification trimSpec, Object trimChar, Object string2) {
        TrimNode node2 = new TrimNode();
        node2.setLeft((Node)string2);
        node2.setTrimChar((Node)trimChar);
        switch (trimSpec) {
            case LEADING: {
                node2.setLeading(true);
                break;
            }
            case TRAILING: {
                node2.setTrailing(true);
                break;
            }
            case BOTH: {
                node2.setBoth(true);
            }
        }
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newLower(int line, int column, Object arg) {
        LowerNode node2 = new LowerNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newUpper(int line, int column, Object arg) {
        UpperNode node2 = new UpperNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newLocate(int line, int column, Object pattern, Object arg, Object startPos) {
        LocateNode node2 = new LocateNode();
        node2.setFind((Node)pattern);
        node2.setFindIn((Node)arg);
        node2.setStartPosition((Node)startPos);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newLength(int line, int column, Object arg) {
        LengthNode node2 = new LengthNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newAbs(int line, int column, Object arg) {
        AbsNode node2 = new AbsNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSqrt(int line, int column, Object arg) {
        SqrtNode node2 = new SqrtNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newMod(int line, int column, Object left, Object right) {
        ModNode node2 = new ModNode();
        node2.setLeft((Node)left);
        node2.setDenominator((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSize(int line, int column, Object arg) {
        SizeNode node2 = new SizeNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newCurrentDate(int line, int column) {
        DateFunctionNode node2 = new DateFunctionNode();
        node2.useCurrentDate();
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newCurrentTime(int line, int column) {
        DateFunctionNode node2 = new DateFunctionNode();
        node2.useCurrentTime();
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newCurrentTimestamp(int line, int column) {
        DateFunctionNode node2 = new DateFunctionNode();
        node2.useCurrentTimestamp();
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newFunc(int line, int column, String name, List parameters) {
        FuncNode node2 = new FuncNode();
        if (name.startsWith("'") && name.endsWith("'")) {
            name = name.substring(1, name.length() - 1);
        }
        node2.setName(name);
        node2.setParameters(parameters);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSubquery(int line, int column, Object select, Object from2, Object where, Object groupBy2, Object having) {
        QueryNode queryNode = (QueryNode)select;
        JPQLParseTree tree = new JPQLParseTree();
        queryNode.setParseTree(tree);
        tree.setQueryNode(queryNode);
        tree.setFromNode((FromNode)from2);
        tree.setWhereNode((WhereNode)where);
        tree.setGroupByNode((GroupByNode)groupBy2);
        tree.setHavingNode((HavingNode)having);
        tree.setContext(this.context);
        SubqueryNode node2 = new SubqueryNode();
        node2.setParseTree(tree);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newExists(int line, int column, boolean not, Object subquery) {
        ExistsNode node2 = new ExistsNode();
        if (not) {
            node2.indicateNot();
        }
        node2.setLeft((Node)subquery);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newIn(int line, int column, boolean not, Object expr, Object subquery) {
        InNode node2 = new InNode();
        if (not) {
            node2.indicateNot();
        }
        node2.setLeft((Node)expr);
        node2.addNodeToTheObjects((Node)subquery);
        this.setPosition(node2, line, column);
        node2.setIsListParameterOrSubquery(true);
        return node2;
    }

    @Override
    public Object newAll(int line, int column, Object subquery) {
        AllNode node2 = new AllNode();
        node2.setLeft((Node)subquery);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newAny(int line, int column, Object subquery) {
        AnyNode node2 = new AnyNode();
        node2.setLeft((Node)subquery);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSome(int line, int column, Object subquery) {
        SomeNode node2 = new SomeNode();
        node2.setLeft((Node)subquery);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newAscOrdering(int line, int column, Object arg) {
        OrderByItemNode node2 = new OrderByItemNode();
        SortDirectionNode sortDirection = new SortDirectionNode();
        sortDirection.useAscending();
        node2.setDirection(sortDirection);
        node2.setOrderByItem(arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newDescOrdering(int line, int column, Object arg) {
        OrderByItemNode node2 = new OrderByItemNode();
        SortDirectionNode sortDirection = new SortDirectionNode();
        sortDirection.useDescending();
        node2.setDirection(sortDirection);
        node2.setOrderByItem(arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newConstructor(int line, int column, String className, List args) {
        ConstructorNode node2 = new ConstructorNode(className);
        node2.setConstructorItems(args);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSetClause(int line, int column, List assignments) {
        SetNode node2 = new SetNode();
        node2.setAssignmentNodes(assignments);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newSetAssignmentClause(int line, int column, Object target, Object value2) {
        EqualsAssignmentNode node2 = new EqualsAssignmentNode();
        node2.setLeft((Node)target);
        node2.setRight((Node)value2);
        return node2;
    }

    private void setPosition(Node node2, int line, int column) {
        node2.setLine(line);
        node2.setColumn(column);
    }

    private void registerSchema(String variable, String schema, int line, int column) {
        if (variable != null) {
            this.context.registerSchema(variable, schema, line, column);
        } else {
            this.context.registerSchema(this.calculateCanonicalName(schema), schema, line, column);
        }
    }

    private String calculateCanonicalName(String name) {
        return name == null ? null : IdentificationVariableDeclNode.calculateCanonicalName(name);
    }

    @Override
    public Object newKey(int line, int column, Object left) {
        MapKeyNode node2 = new MapKeyNode();
        node2.setLeft((Node)left);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newMapEntry(int line, int column, Object arg) {
        MapEntryNode node2 = new MapEntryNode();
        node2.setLeft((Node)arg);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newType(int line, int column, Object left) {
        ClassForInheritanceNode node2 = new ClassForInheritanceNode();
        node2.setLeft((Node)left);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newCaseClause(int line, int column, Object base, List whenClauses, Object elseClause) {
        CaseNode node2 = new CaseNode();
        node2.setWhenClauses(whenClauses);
        if (base != null) {
            node2.setLeft((Node)base);
        }
        node2.setRight((Node)elseClause);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newCoalesceClause(int line, int column, List clauses) {
        CoalesceNode node2 = new CoalesceNode();
        node2.setClauses(clauses);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newNullIfClause(int line, int column, Object left, Object right) {
        NullIfNode node2 = new NullIfNode();
        node2.setLeft((Node)left);
        node2.setRight((Node)right);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newWhenClause(int line, int column, Object conditionClause, Object thenClause) {
        WhenThenNode node2 = new WhenThenNode();
        node2.setLeft((Node)conditionClause);
        node2.setRight((Node)thenClause);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newIndex(int line, int column, Object object) {
        IndexNode node2 = new IndexNode();
        node2.setLeft((Node)object);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newDateLiteral(int line, int column, Object value2) {
        TemporalLiteralNode node2 = new TemporalLiteralNode(TemporalLiteralNode.TemporalType.DATE);
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newTimeLiteral(int line, int column, Object value2) {
        TemporalLiteralNode node2 = new TemporalLiteralNode(TemporalLiteralNode.TemporalType.TIME);
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }

    @Override
    public Object newTimeStampLiteral(int line, int column, Object value2) {
        TemporalLiteralNode node2 = new TemporalLiteralNode(TemporalLiteralNode.TemporalType.TIMESTAMP);
        node2.setLiteral(value2);
        this.setPosition(node2, line, column);
        return node2;
    }
}

