/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.NodeFactory;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class ParseTreeContext {
    private Map variableDecls = new HashMap();
    private String baseVariable;
    private int currentScope = 0;
    private Set outerScopeVariables;
    private Map fetchJoins = new HashMap();
    private TypeHelper typeHelper = null;
    private Map parameterTypes = new HashMap();
    private List parameterNames = new ArrayList();
    private NodeFactory nodeFactory;
    private String queryInfo;

    public ParseTreeContext(NodeFactory nodeFactory, String queryInfo) {
        this.nodeFactory = nodeFactory;
        this.queryInfo = queryInfo;
    }

    public void registerSchema(String variable, String schema, int line, int column) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        if (decl != null) {
            String text = decl.isRangeVariable ? decl.schema : decl.path.getAsString();
            throw JPQLException.multipleVariableDeclaration(this.getQueryInfo(), line, column, variable, text);
        }
        decl = new VariableDecl(variable, schema);
        this.variableDecls.put(variable, decl);
    }

    public void registerJoinVariable(String variable, Node path, int line, int column) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        if (decl != null) {
            String text = decl.isRangeVariable ? decl.schema : decl.path.getAsString();
            throw JPQLException.multipleVariableDeclaration(this.getQueryInfo(), line, column, variable, text);
        }
        decl = new VariableDecl(variable, path);
        this.variableDecls.put(variable, decl);
    }

    public void unregisterVariable(String variable) {
        this.variableDecls.remove(variable);
    }

    public boolean isVariable(String variable) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        return decl != null;
    }

    public boolean isRangeVariable(String variable) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        return decl != null && decl.isRangeVariable;
    }

    public String schemaForVariable(String variable) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        return decl != null ? decl.schema : null;
    }

    public Class classForSchemaName(String schemaName, GenerationContext context) {
        ClassDescriptor descriptor = context.getSession().getDescriptorForAlias(schemaName);
        if (descriptor == null) {
            throw JPQLException.entityTypeNotFound(this.getQueryInfo(), schemaName);
        }
        Class theClass = descriptor.getJavaClass();
        if (theClass == null) {
            throw JPQLException.resolutionClassNotFoundException(this.getQueryInfo(), schemaName);
        }
        return theClass;
    }

    public String getVariableNameForClass(Class theClass, GenerationContext context) {
        for (Map.Entry entry2 : this.variableDecls.entrySet()) {
            String nextVariable = (String)entry2.getKey();
            VariableDecl decl = (VariableDecl)entry2.getValue();
            if (decl.schema == null || theClass != this.classForSchemaName(decl.schema, context)) continue;
            return nextVariable;
        }
        return null;
    }

    public Node pathForVariable(String variable) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        return decl != null ? decl.path : null;
    }

    public String getBaseVariable() {
        return this.baseVariable;
    }

    public void setBaseVariable(String variable) {
        this.baseVariable = variable;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public String getQueryInfo() {
        return this.queryInfo;
    }

    public boolean isDeclaredInOuterScope(String variable) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        return decl != null ? decl.scope < this.currentScope : false;
    }

    public void setScopeOfVariable(String variable) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        if (decl != null) {
            decl.scope = this.currentScope;
        }
    }

    public void enterScope() {
        ++this.currentScope;
        this.resetOuterScopeVariables();
    }

    public void leaveScope() {
        --this.currentScope;
    }

    public void registerOuterScopeVariable(String variable) {
        this.outerScopeVariables.add(variable);
    }

    public Set getOuterScopeVariables() {
        return this.outerScopeVariables;
    }

    public void resetOuterScopeVariables() {
        this.outerScopeVariables = new HashSet();
    }

    public void resetOuterScopeVariables(Set variables) {
        this.outerScopeVariables = variables;
    }

    public void registerFetchJoin(String variableName, Node node2) {
        ArrayList<Node> joins = (ArrayList<Node>)this.fetchJoins.get(variableName);
        if (joins == null) {
            joins = new ArrayList<Node>();
            this.fetchJoins.put(variableName, joins);
        }
        joins.add(node2);
    }

    public List getFetchJoins(String variableName) {
        return (List)this.fetchJoins.get(variableName);
    }

    public void usedVariable(String variable) {
        VariableDecl decl = (VariableDecl)this.variableDecls.get(variable);
        if (decl != null && decl.scope == this.currentScope) {
            decl.used = true;
        }
    }

    public Set getUnusedVariables() {
        HashSet<String> unused = new HashSet<String>();
        for (Map.Entry entry2 : this.variableDecls.entrySet()) {
            String variable = (String)entry2.getKey();
            VariableDecl decl = (VariableDecl)entry2.getValue();
            if (decl.scope != this.currentScope || decl.used) continue;
            unused.add(variable);
        }
        return unused;
    }

    public boolean hasMoreThanOneVariablePerType() {
        HashMap<String, String> typeNamesToVariables = new HashMap<String, String>();
        int nrOfRangeVariables = 0;
        for (Map.Entry entry2 : this.variableDecls.entrySet()) {
            String variable = (String)entry2.getKey();
            VariableDecl decl = (VariableDecl)entry2.getValue();
            if (!decl.isRangeVariable) continue;
            ++nrOfRangeVariables;
            typeNamesToVariables.put(decl.schema, variable);
        }
        return typeNamesToVariables.size() != nrOfRangeVariables;
    }

    public boolean hasMoreThanOneAliasInFrom() {
        HashMap<String, String> typeNamesToVariables = new HashMap<String, String>();
        for (Map.Entry entry2 : this.variableDecls.entrySet()) {
            String variable = (String)entry2.getKey();
            VariableDecl decl = (VariableDecl)entry2.getValue();
            if (!decl.isRangeVariable) continue;
            typeNamesToVariables.put(decl.schema, variable);
        }
        return typeNamesToVariables.size() > 1;
    }

    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    public void setTypeHelper(TypeHelper typeHelper) {
        this.typeHelper = typeHelper;
    }

    public void addParameter(String parameterName) {
        if (!this.parameterNames.contains(parameterName)) {
            this.parameterNames.add(parameterName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineParameterType(String parameterName, Object parameterType, int line, int column) {
        if (this.parameterTypes.containsKey(parameterName)) {
            Object oldType = this.parameterTypes.get(parameterName);
            if (this.typeHelper.isAssignableFrom(oldType, parameterType)) return;
            if (!this.typeHelper.isAssignableFrom(parameterType, oldType)) throw JPQLException.invalidMultipleUseOfSameParameter(this.getQueryInfo(), line, column, parameterName, this.typeHelper.getTypeName(oldType), this.typeHelper.getTypeName(parameterType));
            this.parameterTypes.put(parameterName, parameterType);
            return;
        } else {
            this.parameterTypes.put(parameterName, parameterType);
        }
    }

    public boolean hasParameters() {
        return !this.parameterNames.isEmpty();
    }

    public Object getParameterType(String parameter) {
        return this.parameterTypes.get(parameter);
    }

    public List getParameterNames() {
        return this.parameterNames;
    }

    static class VariableDecl {
        public final String variable;
        public final boolean isRangeVariable;
        public final String schema;
        public final Node path;
        public int scope;
        public boolean used;

        public VariableDecl(String variable, String schema) {
            this.variable = variable;
            this.isRangeVariable = true;
            this.schema = schema;
            this.path = null;
            this.used = false;
        }

        public VariableDecl(String variable, Node path) {
            this.variable = variable;
            this.isRangeVariable = false;
            this.schema = null;
            this.path = path;
            this.used = false;
        }
    }
}

