/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.ConstructorNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.QueryNode;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class SelectNode
extends QueryNode {
    private List selectExpressions = new ArrayList();
    private List identifiers = new ArrayList();
    private boolean distinct = false;

    public List getSelectExpressions() {
        return this.selectExpressions;
    }

    public void setSelectExpressions(List exprs) {
        this.selectExpressions = exprs;
    }

    public List getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List identifiers) {
        this.identifiers = identifiers;
    }

    public boolean usesDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct2) {
        this.distinct = distinct2;
    }

    @Override
    public DatabaseQuery createDatabaseQuery(ParseTreeContext context) {
        ReadAllQuery query = this.isReadAllQuery(context) ? new ReadAllQuery() : new ReportQuery();
        query.dontUseDistinct();
        return query;
    }

    private boolean isReadAllQuery(ParseTreeContext context) {
        if (!this.isSingleSelectExpression()) {
            return false;
        }
        Node node2 = this.getFirstSelectExpressionNode();
        if (!node2.isVariableNode()) {
            return false;
        }
        String variable = ((VariableNode)node2).getCanonicalVariableName();
        String baseVariable = this.getParseTree().getFromNode().getFirstVariable();
        if (!context.isRangeVariable(baseVariable)) {
            return false;
        }
        if (this.getParseTree().hasGroupBy() || this.getParseTree().hasHaving()) {
            return false;
        }
        return baseVariable.equals(variable);
    }

    @Override
    public void applyToQuery(DatabaseQuery theQuery, GenerationContext context) {
        ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)theQuery;
        if (this.selectExpressions.isEmpty()) {
            return;
        }
        if (!(this.isSingleSelectExpression() && this.getFirstSelectExpressionNode().isCountNode() || !this.usesDistinct())) {
            this.getParseTree().setDistinctState((short)1);
            readQuery.setDistinctState((short)1);
        }
        if (readQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)readQuery;
            reportQuery.returnWithoutReportQueryResult();
            if (this.isSingleSelectExpression()) {
                reportQuery.returnSingleAttribute();
            }
        }
        SelectGenerationContext selectContext = (SelectGenerationContext)context;
        int i = 0;
        while (i < this.selectExpressions.size()) {
            String alias;
            Node node2 = (Node)this.selectExpressions.get(i);
            if (this.selectingRelationshipField(node2, context)) {
                selectContext.useOuterJoins();
            }
            if (node2.isAliasableNode() && this.identifiers != null && (alias = (String)this.identifiers.get(i)) != null) {
                ((AliasableNode)((Object)node2)).setAlias(alias);
            }
            node2.applyToQuery(readQuery, context);
            selectContext.dontUseOuterJoins();
            ++i;
        }
        readQuery.setShouldBuildNullForNullPk(this.hasOneToOneSelected(context));
    }

    public boolean hasOneToOneSelected(GenerationContext context) {
        for (Node node2 : this.selectExpressions) {
            if (!this.hasOneToOneSelected(node2, context)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOneToOneSelected(Node node2, GenerationContext context) {
        if (node2.isCountNode()) {
            return false;
        }
        if (node2.isAggregateNode()) {
            return this.hasOneToOneSelected(node2.getLeft(), context);
        }
        if (node2.isVariableNode()) {
            return !this.nodeRefersToObject(node2, context);
        }
        if (node2.isConstructorNode()) {
            List args = ((ConstructorNode)node2).getConstructorItems();
            for (Node arg : args) {
                if (!this.hasOneToOneSelected(arg, context)) continue;
                return true;
            }
            return false;
        }
        return !this.selectingDirectToField(node2, context);
    }

    public void verifySelectedAlias(GenerationContext context) {
        for (Node node2 : this.selectExpressions) {
            if (node2.isDotNode()) {
                return;
            }
            node2.resolveClass(context);
        }
    }

    public boolean isSelected(String variableName) {
        for (Node node2 : this.selectExpressions) {
            if (!node2.isVariableNode() || !((VariableNode)node2).getCanonicalVariableName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelectNode() {
        return true;
    }

    @Override
    public Node qualifyAttributeAccess(ParseTreeContext context) {
        int i = 0;
        while (i < this.selectExpressions.size()) {
            Node item = (Node)this.selectExpressions.get(i);
            this.selectExpressions.set(i, item.qualifyAttributeAccess(context));
            ++i;
        }
        return this;
    }

    @Override
    public void validate(ParseTreeContext context) {
        for (Node item : this.selectExpressions) {
            item.validate(context);
        }
    }

    @Override
    public Class resolveClass(GenerationContext context) {
        return this.getReferenceClass(context);
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        return null;
    }

    @Override
    public Class getReferenceClass(GenerationContext context) {
        return this.getClassOfFirstVariable(context);
    }

    private Class getClassOfFirstVariable(GenerationContext context) {
        Class clazz = null;
        String variable = this.getParseTree().getFromNode().getFirstVariable();
        ParseTreeContext parseTreeContext = context.getParseTreeContext();
        if (parseTreeContext.isRangeVariable(variable)) {
            String schema = parseTreeContext.schemaForVariable(variable);
            clazz = parseTreeContext.classForSchemaName(schema, context);
        } else {
            Node path = parseTreeContext.pathForVariable(variable);
            clazz = path.resolveClass(context);
        }
        return clazz;
    }

    public boolean isVariableInINClauseSelected(GenerationContext context) {
        for (Node node2 : this.selectExpressions) {
            if (!node2.isVariableNode()) continue;
            String variableNameForLeft = ((VariableNode)node2).getCanonicalVariableName();
            if (context.getParseTreeContext().isRangeVariable(variableNameForLeft)) continue;
            return true;
        }
        return false;
    }

    public boolean nodeRefersToObject(Node node2, GenerationContext context) {
        ClassDescriptor descriptor;
        if (!node2.isVariableNode()) {
            return false;
        }
        String name = ((VariableNode)node2).getCanonicalVariableName();
        String alias = context.getParseTreeContext().schemaForVariable(name);
        return alias != null && (descriptor = context.getSession().getDescriptorForAlias(alias)) != null;
    }

    private boolean selectingRelationshipField(Node node2, GenerationContext context) {
        if (node2 == null || !node2.isDotNode()) {
            return false;
        }
        TypeHelper typeHelper = context.getParseTreeContext().getTypeHelper();
        Node path = node2.getLeft();
        AttributeNode attribute = (AttributeNode)node2.getRight();
        return typeHelper.isRelationship(path.getType(), attribute.getAttributeName());
    }

    private boolean selectingDirectToField(Node node2, GenerationContext context) {
        if (node2 == null || !node2.isDotNode()) {
            return false;
        }
        return ((DotNode)node2).endsWithDirectToField(context);
    }

    private Node getFirstSelectExpressionNode() {
        return this.selectExpressions.size() > 0 ? (Node)this.selectExpressions.get(0) : null;
    }

    private boolean isSingleSelectExpression() {
        return this.selectExpressions.size() == 1;
    }
}

