/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing.jpql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.NodeFactory;
import org.eclipse.persistence.internal.jpa.parsing.NodeFactoryImpl;
import org.eclipse.persistence.internal.jpa.parsing.jpql.InvalidIdentifierException;
import org.eclipse.persistence.internal.jpa.parsing.jpql.InvalidIdentifierStartException;
import org.eclipse.persistence.internal.jpa.parsing.jpql.antlr.JPQLParserBuilder;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedTokenException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.NoViableAltException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Parser;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognizerSharedState;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;

public abstract class JPQLParser
extends Parser {
    private List errors = new ArrayList();
    private String queryName = null;
    private String queryText = null;
    protected NodeFactory factory;

    protected JPQLParser(TokenStream stream) {
        super(stream);
    }

    public JPQLParser(TokenStream input2, RecognizerSharedState state) {
        super(input2, state);
    }

    public static String ANTLRVersion() throws Exception {
        return "2.7.3";
    }

    public static JPQLParseTree buildParseTree(String queryText) throws JPQLException {
        return JPQLParser.buildParseTree(null, queryText);
    }

    public static JPQLParseTree buildParseTree(String queryName, String queryText) throws JPQLException {
        JPQLParser parser = JPQLParser.buildParserFor(queryName, queryText);
        return parser.parse();
    }

    public static JPQLParser buildParserFor(String queryText) throws JPQLException {
        return JPQLParser.buildParserFor(null, queryText);
    }

    public static JPQLParser buildParserFor(String queryName, String queryText) throws JPQLException {
        try {
            org.eclipse.persistence.internal.jpa.parsing.jpql.antlr.JPQLParser parser = JPQLParserBuilder.buildParser(queryText);
            parser.setQueryName(queryName);
            parser.setQueryText(queryText);
            parser.setNodeFactory(new NodeFactoryImpl(parser.getQueryInfo()));
            return parser;
        }
        catch (Exception ex) {
            throw JPQLException.generalParsingException(queryText, ex);
        }
    }

    public JPQLParseTree parse() throws JPQLException {
        try {
            this.document();
        }
        catch (Exception e) {
            this.addError(e);
        }
        if (this.hasErrors()) {
            throw this.generateException();
        }
        return this.getParseTree();
    }

    public JPQLParseTree getParseTree() {
        return (JPQLParseTree)this.getRootNode();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getQueryName() {
        return this.queryText;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public String getQueryInfo() {
        return this.queryName == null ? this.queryText : String.valueOf(this.queryName) + ": " + this.queryText;
    }

    public void setNodeFactory(NodeFactory factory) {
        this.factory = factory;
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    public List getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public void addError(Exception e) {
        if (e instanceof RecognitionException) {
            e = this.handleRecognitionException((RecognitionException)e);
        } else if (!(e instanceof JPQLException)) {
            e = JPQLException.generalParsingException(this.getQueryInfo(), e);
        }
        this.errors.add(e);
    }

    protected JPQLException generateException() {
        Exception firstException = (Exception)this.getErrors().get(0);
        if (firstException instanceof JPQLException) {
            return (JPQLException)firstException;
        }
        JPQLException exception = JPQLException.generalParsingException(this.getQueryInfo());
        exception.setInternalExceptions(this.getErrors());
        return exception;
    }

    protected JPQLException handleRecognitionException(RecognitionException ex) {
        JPQLException result2 = null;
        if (ex instanceof MismatchedTokenException) {
            MismatchedTokenException mismatched = (MismatchedTokenException)ex;
            Token token = mismatched.token;
            if (token != null) {
                result2 = token.equals(Token.EOF_TOKEN) ? JPQLException.unexpectedEOF(this.getQueryInfo(), mismatched.line, mismatched.charPositionInLine, ex) : JPQLException.syntaxErrorAt(this.getQueryInfo(), mismatched.line, mismatched.charPositionInLine, token.getText(), ex);
            }
        } else if (ex instanceof NoViableAltException) {
            NoViableAltException noviable = (NoViableAltException)ex;
            Token token = noviable.token;
            if (token != null) {
                result2 = token.equals(Token.EOF_TOKEN) ? JPQLException.unexpectedEOF(this.getQueryInfo(), noviable.line, noviable.charPositionInLine, ex) : JPQLException.unexpectedToken(this.getQueryInfo(), noviable.line, noviable.charPositionInLine, token.getText(), ex);
            }
        } else if (ex instanceof InvalidIdentifierException) {
            InvalidIdentifierException invalid = (InvalidIdentifierException)ex;
            Token token = invalid.getToken();
            if (token != null) {
                result2 = token.equals(Token.EOF_TOKEN) ? JPQLException.unexpectedEOF(this.getQueryInfo(), token.getLine(), token.getCharPositionInLine(), ex) : JPQLException.unexpectedToken(this.getQueryInfo(), token.getLine(), token.getCharPositionInLine(), token.getText(), ex);
            }
        } else if (ex instanceof InvalidIdentifierStartException) {
            InvalidIdentifierStartException invalid = (InvalidIdentifierStartException)ex;
            result2 = JPQLException.unexpectedChar(this.getQueryInfo(), invalid.line, invalid.charPositionInLine, String.valueOf((char)invalid.c), ex);
        }
        if (result2 == null) {
            result2 = JPQLException.syntaxError(this.getQueryInfo(), ex);
        }
        return result2;
    }

    @Override
    public void reportError(RecognitionException ex) {
        this.addError(ex);
    }

    public abstract void document() throws RecognitionException;

    public abstract Object getRootNode();
}

